/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.graphics2d;

import armyc2.c2sd.graphics2d.Line2D;
import armyc2.c2sd.graphics2d.Point2D;

public abstract class Rectangle2D {
    public double x = 0.0;
    public double y = 0.0;
    public double width = 0.0;
    public double height = 0.0;

    protected Rectangle2D() {
    }

    public void add(double x1, double y1) {
        if (x1 < this.x) {
            this.width += this.x - x1;
            this.x = x1;
        }
        if (y1 < this.y) {
            this.height += this.y - y1;
            this.y = y1;
        }
        if (x1 > this.x + this.width) {
            this.width += x1 - this.x;
        }
        if (y1 > this.y + this.height) {
            this.height += y1 - this.y;
        }
    }

    public Rectangle2D createIntersection(Rectangle2D r) {
        if (r.x > this.x + this.width) {
            return null;
        }
        if (r.x + r.width < this.x) {
            return null;
        }
        if (r.y > this.y + this.height) {
            return null;
        }
        if (r.y + r.height < this.y) {
            return null;
        }
        if (r.contains(this)) {
            return this;
        }
        if (this.contains(r)) {
            return r;
        }
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        if (this.x < r.x) {
            x1 = r.x;
            x2 = this.x + this.width;
        } else {
            x1 = this.x;
            x2 = r.x + r.width;
        }
        if (this.y < r.y) {
            y1 = r.y;
            y2 = this.y + this.height;
        } else {
            y1 = this.y;
            y2 = r.y + r.height;
        }
        return new Double(x1, y1, x2 - x1, y2 - y1);
    }

    public Rectangle2D createUnion(Rectangle2D r) {
        return null;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getMinX() {
        return this.x;
    }

    public double getMinY() {
        return this.y;
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean contains(double x1, double y1) {
        return this.x <= x1 && x1 <= this.x + this.width && this.y <= y1 && y1 <= this.y + this.width;
    }

    public boolean intersects(Rectangle2D rect) {
        if (this.x + this.width < rect.x) {
            return false;
        }
        if (this.x > rect.x + rect.width) {
            return false;
        }
        if (this.y + this.height < rect.y) {
            return false;
        }
        return !(this.y > rect.y + rect.height);
    }

    public boolean intersects(int x1, int y1, int width1, int height1) {
        if (this.x + this.width < (double)x1) {
            return false;
        }
        if (this.x > (double)(x1 + width1)) {
            return false;
        }
        if (this.y + this.height < (double)y1) {
            return false;
        }
        return !(this.y > (double)(y1 + height1));
    }

    public boolean contains(Rectangle2D rect) {
        double y1;
        double x1 = rect.getX();
        return this.contains(x1, y1 = rect.getY()) && this.contains(x1 += rect.getWidth(), y1 += rect.getHeight());
    }

    public boolean contains(Point2D pt) {
        return this.x <= pt.getX() && pt.getX() <= this.x + this.width && this.y <= pt.getY() && pt.getY() <= this.x + this.height;
    }

    public boolean intersectsLine(Line2D line) {
        return false;
    }

    public boolean contains(int x, int y, int width, int height) {
        double x1 = x;
        double y1 = y;
        return this.contains(x1, y1) && this.contains(x1 += (double)width, y1 += (double)height);
    }

    public boolean isEmpty() {
        return this.width == 0.0 && this.height == 0.0;
    }

    public void setRect(double x1, double y1, double width1, double height1) {
        this.x = x1;
        this.y = y1;
        this.width = width1;
        this.height = height1;
    }

    public void setRect(Rectangle2D r) {
        this.x = r.getX();
        this.y = r.getY();
        this.width = r.getWidth();
        this.height = r.getHeight();
    }

    public static class Double
    extends Rectangle2D {
        public Double() {
            this.x = 0.0;
            this.y = 0.0;
            this.width = 0.0;
            this.height = 0.0;
        }

        public Double(double x1, double y1, double width1, double height1) {
            this.x = x1;
            this.y = y1;
            this.width = width1;
            this.height = height1;
        }
    }
}

