/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.graphics2d;

import armyc2.c2sd.graphics2d.AffineTransform;
import armyc2.c2sd.graphics2d.PathIterator;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Rectangle2D;
import armyc2.c2sd.graphics2d.Shape;

public class Rectangle
implements Shape {
    public int x = 0;
    public int y = 0;
    public int width = 0;
    public int height = 0;

    public Rectangle() {
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    public Rectangle(int x1, int y1, int width1, int height1) {
        this.x = x1;
        this.y = y1;
        this.width = width1;
        this.height = height1;
    }

    @Override
    public Rectangle getBounds() {
        return this;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return null;
    }

    @Override
    public boolean intersects(Rectangle2D rect) {
        if ((double)(this.x + this.width) < rect.x) {
            return false;
        }
        if ((double)this.x > rect.x + rect.width) {
            return false;
        }
        if ((double)(this.y + this.height) < rect.y) {
            return false;
        }
        return !((double)this.y > rect.y + rect.height);
    }

    @Override
    public boolean intersects(double x1, double y1, double width1, double height1) {
        if ((double)(this.x + this.width) < x1) {
            return false;
        }
        if ((double)this.x > x1 + width1) {
            return false;
        }
        if ((double)(this.y + this.height) < y1) {
            return false;
        }
        return !((double)this.y > y1 + height1);
    }

    @Override
    public boolean contains(int x1, int y1) {
        return this.x <= x1 && x1 <= this.x + this.width && this.y <= y1 && y1 <= this.y + this.height;
    }

    @Override
    public boolean contains(int x1, int y1, int width1, int height1) {
        return this.contains(x1, y1) && this.contains(x1 + width1, y1 + height1);
    }

    @Override
    public boolean contains(Point2D pt) {
        return (double)this.x <= pt.getX() && pt.getX() <= (double)(this.x + this.width) && (double)this.y <= pt.getY() && pt.getY() <= (double)(this.y + this.height);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public double getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getMinX() {
        return this.x;
    }

    public int getMinY() {
        return this.y;
    }

    public int getMaxX() {
        return this.x + this.width;
    }

    public int getMaxY() {
        return this.y + this.height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void grow(int h, int v) {
    }

    public void setRect(Rectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }
}

