/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.graphics2d;

import android.graphics.Path;
import android.graphics.RectF;
import armyc2.c2sd.graphics2d.AffineTransform;
import armyc2.c2sd.graphics2d.PathIterator;
import armyc2.c2sd.graphics2d.Point;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Rectangle;
import armyc2.c2sd.graphics2d.Rectangle2D;
import java.util.Arrays;

public class Polygon {
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    protected Rectangle bounds;
    private static final long serialVersionUID = -6460061437900069969L;
    private static final int MIN_LENGTH = 4;

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public Polygon(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        if (npoints < 0) {
            throw new NegativeArraySizeException("npoints < 0");
        }
        this.npoints = npoints;
        this.xpoints = Arrays.copyOf(xpoints, npoints);
        this.ypoints = Arrays.copyOf(ypoints, npoints);
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
    }

    public void invalidate() {
        this.bounds = null;
    }

    void calculateBounds(int[] xpoints, int[] ypoints, int npoints) {
        int boundsMinX = Integer.MAX_VALUE;
        int boundsMinY = Integer.MAX_VALUE;
        int boundsMaxX = Integer.MIN_VALUE;
        int boundsMaxY = Integer.MIN_VALUE;
        for (int i = 0; i < npoints; ++i) {
            int x = xpoints[i];
            boundsMinX = Math.min(boundsMinX, x);
            boundsMaxX = Math.max(boundsMaxX, x);
            int y = ypoints[i];
            boundsMinY = Math.min(boundsMinY, y);
            boundsMaxY = Math.max(boundsMaxY, y);
        }
        this.bounds = new Rectangle(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
    }

    void updateBounds(int x, int y) {
        if (x < this.bounds.x) {
            this.bounds.width += this.bounds.x - x;
            this.bounds.x = x;
        } else {
            this.bounds.width = Math.max(this.bounds.width, x - this.bounds.x);
        }
        if (y < this.bounds.y) {
            this.bounds.height += this.bounds.y - y;
            this.bounds.y = y;
        } else {
            this.bounds.height = Math.max(this.bounds.height, y - this.bounds.y);
        }
    }

    public void addPoint(int x, int y) {
        if (this.npoints >= this.xpoints.length || this.npoints >= this.ypoints.length) {
            int newLength = this.npoints * 2;
            if (newLength < 4) {
                newLength = 4;
            } else if ((newLength & newLength - 1) != 0) {
                newLength = Integer.highestOneBit(newLength);
            }
            this.xpoints = Arrays.copyOf(this.xpoints, newLength);
            this.ypoints = Arrays.copyOf(this.ypoints, newLength);
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        if (this.bounds != null) {
            this.updateBounds(x, y);
        }
    }

    public Rectangle getBounds() {
        return this.getBoundingBox();
    }

    @Deprecated
    public Rectangle getBoundingBox() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds.getBounds();
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    @Deprecated
    public boolean inside(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public Rectangle2D getBounds2D() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(double x, double y) {
        if (this.npoints <= 2 || !this.getBoundingBox().contains((int)x, (int)y)) {
            return false;
        }
        hits = 0;
        lastx = this.xpoints[this.npoints - 1];
        lasty = this.ypoints[this.npoints - 1];
        for (i = 0; i < this.npoints; ++i) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                curx = this.xpoints[i];
                                cury = this.ypoints[i];
                                if (cury == lasty) break block8;
                                if (curx >= lastx) break block9;
                                if (x >= (double)lastx) break block8;
                                leftx = curx;
                                break block10;
                            }
                            if (x >= (double)curx) break block8;
                            leftx = lastx;
                        }
                        if (cury >= lasty) break block11;
                        if (y < (double)cury || y >= (double)lasty) break block8;
                        if (!(x < (double)leftx)) break block12;
                        ++hits;
                        break block8;
                    }
                    test1 = x - (double)curx;
                    test2 = y - (double)cury;
                    ** GOTO lbl34
                }
                if (y < (double)lasty || y >= (double)cury) break block8;
                if (x < (double)leftx) {
                    ++hits;
                } else {
                    test1 = x - (double)lastx;
                    test2 = y - (double)lasty;
lbl34:
                    // 2 sources

                    if (test1 < test2 / (double)(lasty - cury) * (double)(lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
        }
        return (hits & true) != false;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h)) {
            return false;
        }
        if (this.bounds != null) {
            float fx = (float)x;
            float fy = (float)y;
            float fw = (float)w;
            float fh = (float)h;
            Path that = new Path();
            that.moveTo(fx, fy);
            that.lineTo(fx + fw, fy);
            that.lineTo(fx + fw, fy - fh);
            that.lineTo(fx, fy - fh);
            that.close();
            RectF thatBounds = new RectF();
            RectF rectf = new RectF((float)this.bounds.x, (float)this.bounds.y, (float)this.bounds.x + (float)this.bounds.width, (float)this.bounds.y + (float)this.bounds.height);
            return RectF.intersects((RectF)rectf, (RectF)thatBounds);
        }
        return false;
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h)) {
            return false;
        }
        return false;
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        PathIterator pi = new PathIterator(null);
        int j = 0;
        if (this.npoints > 0) {
            pi.moveTo(this.xpoints[0], this.ypoints[0]);
            for (j = 1; j < this.npoints; ++j) {
                pi.lineTo(this.xpoints[j], this.ypoints[j]);
            }
        }
        pi.reset();
        return pi;
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }
}

