/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.graphics2d;

import armyc2.c2sd.JavaLineArray.POINT2;
import armyc2.c2sd.graphics2d.AffineTransform;
import armyc2.c2sd.graphics2d.IPathIterator;
import armyc2.c2sd.graphics2d.Rectangle2D;
import java.util.ArrayList;

public class PathIterator
implements IPathIterator {
    private int _currentSeg = 0;
    private ArrayList<POINT2> _pts = new ArrayList();

    public PathIterator(AffineTransform tx) {
    }

    public ArrayList<POINT2> getPoints() {
        return this._pts;
    }

    @Override
    public int currentSegment(double[] coords) {
        int type = this._pts.get((int)this._currentSeg).style;
        if (type == 1 || type == 0) {
            coords[0] = this._pts.get((int)this._currentSeg).x;
            coords[1] = this._pts.get((int)this._currentSeg).y;
        } else if (type == 3) {
            coords[0] = this._pts.get((int)this._currentSeg).x;
            coords[1] = this._pts.get((int)this._currentSeg).y;
            ++this._currentSeg;
            coords[2] = this._pts.get((int)this._currentSeg).x;
            coords[3] = this._pts.get((int)this._currentSeg).y;
            ++this._currentSeg;
            coords[4] = this._pts.get((int)this._currentSeg).x;
            coords[5] = this._pts.get((int)this._currentSeg).y;
        } else if (type == 2) {
            coords[0] = this._pts.get((int)this._currentSeg).x;
            coords[1] = this._pts.get((int)this._currentSeg).y;
            ++this._currentSeg;
            coords[2] = this._pts.get((int)this._currentSeg).x;
            coords[3] = this._pts.get((int)this._currentSeg).y;
        }
        return type;
    }

    @Override
    public int currentSegment(float[] coords) {
        coords[0] = (float)this._pts.get((int)this._currentSeg).x;
        coords[1] = (float)this._pts.get((int)this._currentSeg).y;
        return this._pts.get((int)this._currentSeg).style;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this._currentSeg == this._pts.size();
    }

    @Override
    public void next() {
        ++this._currentSeg;
    }

    public void reset() {
        this._currentSeg = 0;
    }

    public void moveTo(double x, double y) {
        this._pts.add(new POINT2(x, y, 0));
    }

    public void lineTo(double x, double y) {
        this._pts.add(new POINT2(x, y, 1));
    }

    public void cubicTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        this._pts.add(new POINT2(x1, y1, 3));
        this._pts.add(new POINT2(x2, y2, 3));
        this._pts.add(new POINT2(x3, y3, 3));
    }

    public void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        this._pts.add(new POINT2(x1, y1, 3));
        this._pts.add(new POINT2(x2, y2, 3));
        this._pts.add(new POINT2(x3, y3, 3));
    }

    public void quadTo(double x1, double y1, double x2, double y2) {
        this._pts.add(new POINT2(x1, y1, 2));
        this._pts.add(new POINT2(x2, y2, 2));
    }

    public Rectangle2D getBounds() {
        int j = 0;
        double left = this._pts.get((int)0).x;
        double right = this._pts.get((int)0).x;
        double top = this._pts.get((int)0).y;
        double bottom = this._pts.get((int)0).y;
        int n = this._pts.size();
        for (j = 1; j < n; ++j) {
            if (this._pts.get((int)j).x < left) {
                left = this._pts.get((int)j).x;
            }
            if (this._pts.get((int)j).x > right) {
                right = this._pts.get((int)j).x;
            }
            if (this._pts.get((int)j).y < top) {
                top = this._pts.get((int)j).y;
            }
            if (!(this._pts.get((int)j).y > bottom)) continue;
            bottom = this._pts.get((int)j).y;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(left, top, right - left, bottom - top);
        return rect;
    }

    public void setPathIterator(ArrayList<POINT2> pts) {
        this.reset();
        this._pts = pts;
    }
}

