/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.graphics2d;

import armyc2.c2sd.JavaLineArray.POINT2;
import armyc2.c2sd.JavaLineArray.lineutility;
import armyc2.c2sd.graphics2d.GeneralPath;
import armyc2.c2sd.graphics2d.Line2D;
import armyc2.c2sd.graphics2d.PathIterator;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Polygon;
import armyc2.c2sd.graphics2d.Rectangle2D;
import armyc2.c2sd.graphics2d.Shape;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.RendererException;
import java.util.ArrayList;
import java.util.HashMap;

public class Area
extends GeneralPath {
    private static final String _className = "Area";

    public Area(Polygon poly) {
        int j = 0;
        int n = poly.npoints;
        for (j = 0; j < n; ++j) {
            if (j == 0) {
                this.moveTo(poly.xpoints[j], poly.ypoints[j]);
                continue;
            }
            this.lineTo(poly.xpoints[j], poly.ypoints[j]);
        }
    }

    public Area(Shape shape) {
        int j = 0;
        PathIterator p = shape.getPathIterator(null);
        ArrayList<POINT2> pts = p.getPoints();
        POINT2 pt = null;
        int n = pts.size();
        block4: for (j = 0; j < n; ++j) {
            pt = pts.get(j);
            switch (pt.style) {
                case 0: {
                    this.moveTo(pt.x, pt.y);
                    continue block4;
                }
                case 1: {
                    this.lineTo(pt.x, pt.y);
                    continue block4;
                }
            }
        }
    }

    private void reorderPointsByDistance(Line2D hatchLine, ArrayList<Point2D> pts) {
        try {
            double minDistance = 0.0;
            double dist = 0.0;
            int j = 0;
            int minIndex = -1;
            HashMap<Integer, Double> distances = new HashMap<Integer, Double>();
            ArrayList<Point2D> ptsOrdered = new ArrayList<Point2D>();
            Point2D origin = hatchLine.getP1();
            POINT2 pt0 = new POINT2(origin.getX(), origin.getY());
            POINT2 pt1 = null;
            int n = pts.size();
            for (j = 0; j < n; ++j) {
                pt1 = new POINT2(pts.get(j).getX(), pts.get(j).getY());
                dist = lineutility.CalcDistanceDouble(pt0, pt1);
                distances.put(j, dist);
            }
            while (distances.size() > 0) {
                for (j = 0; j < n; ++j) {
                    if (!distances.containsKey(j)) continue;
                    minIndex = j;
                    minDistance = (Double)distances.get(j);
                    break;
                }
                for (j = 0; j < n; ++j) {
                    if (!distances.containsKey(j) || !((dist = ((Double)distances.get(j)).doubleValue()) < minDistance)) continue;
                    minDistance = dist;
                    minIndex = j;
                }
                ptsOrdered.add(pts.get(minIndex));
                distances.remove(minIndex);
            }
            pts.clear();
            n = ptsOrdered.size();
            for (j = 0; j < n; ++j) {
                pts.add((Point2D)ptsOrdered.get(j));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "reorderPointsByDistance", new RendererException("Failed inside reorderPointsByDistance", exc));
        }
    }

    Rectangle2D getMBR(ArrayList<POINT2> polygon) {
        int j = 0;
        double left = polygon.get((int)0).x;
        double top = polygon.get((int)0).y;
        double right = polygon.get((int)0).x;
        double bottom = polygon.get((int)0).y;
        int n = polygon.size();
        for (j = 1; j < n; ++j) {
            if (polygon.get((int)j).x < left) {
                left = polygon.get((int)j).x;
            }
            if (polygon.get((int)j).x > right) {
                right = polygon.get((int)j).x;
            }
            if (polygon.get((int)j).y < top) {
                top = polygon.get((int)j).y;
            }
            if (!(polygon.get((int)j).y > bottom)) continue;
            bottom = polygon.get((int)j).y;
        }
        return new Rectangle2D.Double(left, top, right - left, bottom - top);
    }

    boolean isVertical(Line2D edge) {
        return edge.getX1() == edge.getX2();
    }

    private void adjustVerticalLine(Line2D line) {
        Point2D linePt0 = line.getP1();
        Point2D linePt1 = line.getP1();
        if (this.isVertical(line)) {
            double x = line.getX2() + 1.0;
            double y = line.getY2();
            linePt1.setLocation(x, y);
            line.setLine(linePt0, linePt1);
        }
    }

    private ArrayList<POINT2> getLineIntersectPoints(ArrayList<POINT2> polygon, Line2D hatchLine) {
        ArrayList<POINT2> pts = null;
        try {
            int j = 0;
            int k = 0;
            Line2D.Double segment = null;
            Point2D pt0 = null;
            Point2D pt1 = null;
            this.adjustVerticalLine(hatchLine);
            ArrayList<Point2D> ptsPath = new ArrayList<Point2D>();
            double x = 0.0;
            double y = 0.0;
            double m1 = 0.0;
            double m2 = 0.0;
            double b1 = 0.0;
            double b2 = 0.0;
            int n = polygon.size();
            for (j = 0; j < n - 1; ++j) {
                pt0 = new Point2D.Double(polygon.get(j));
                pt1 = new Point2D.Double(polygon.get(j + 1));
                segment = new Line2D.Double(pt0, pt1);
                this.adjustVerticalLine(segment);
                pt0 = ((Line2D)segment).getP1();
                pt1 = ((Line2D)segment).getP2();
                m1 = (hatchLine.getY1() - hatchLine.getY2()) / (hatchLine.getX1() - hatchLine.getX2());
                m2 = (pt0.getY() - pt1.getY()) / (pt0.getX() - pt1.getX());
                if (!hatchLine.intersectsLine(segment)) continue;
                if (m1 == m2) {
                    ptsPath.add(pt0);
                    ptsPath.add(pt1);
                    continue;
                }
                b1 = hatchLine.getY1() - m1 * hatchLine.getX1();
                b2 = ((Line2D)segment).getY1() - m2 * ((Line2D)segment).getX1();
                x = (b2 - b1) / (m1 - m2);
                y = m1 * x + b1;
                ptsPath.add(new Point2D.Double(x, y));
            }
            this.reorderPointsByDistance(hatchLine, ptsPath);
            Point2D pt = null;
            pts = new ArrayList<POINT2>();
            n = ptsPath.size();
            for (k = 0; k < n; ++k) {
                pt = ptsPath.get(k);
                if (k % 2 == 0) {
                    pts.add(new POINT2(pt.getX(), pt.getY(), 0));
                    continue;
                }
                pts.add(new POINT2(pt.getX(), pt.getY(), 1));
            }
            ptsPath.clear();
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getLineIntersectPoints", new RendererException("Failed inside getLineIntersectPoints", exc));
        }
        return pts;
    }

    public void intersect(Area area) {
        try {
            int j = 0;
            ArrayList<POINT2> polygon = area.getPathIterator(null).getPoints();
            ArrayList<POINT2> hatchLines = this.getPathIterator(null).getPoints();
            if (polygon.get((int)0).x != polygon.get((int)(polygon.size() - 1)).x || polygon.get((int)0).y != polygon.get((int)(polygon.size() - 1)).y) {
                polygon.add(new POINT2(polygon.get(polygon.size() - 1)));
            }
            Line2D.Double hatchLine = null;
            Rectangle2D rectHatch = null;
            Rectangle2D rectPoly = this.getMBR(polygon);
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            ArrayList<POINT2> ptsTemp = null;
            int n = hatchLines.size();
            for (j = 0; j < n - 1; ++j) {
                hatchLine = new Line2D.Double(hatchLines.get((int)j).x, hatchLines.get((int)j).y, hatchLines.get((int)(j + 1)).x, hatchLines.get((int)(j + 1)).y);
                rectHatch = ((Line2D)hatchLine).getBounds2D();
                if (!rectHatch.intersects(rectPoly) || (ptsTemp = this.getLineIntersectPoints(polygon, hatchLine)) == null) continue;
                pts.addAll(ptsTemp);
            }
            POINT2 pt = null;
            this.getPathIterator(null).getPoints().clear();
            n = pts.size();
            block7: for (j = 0; j < n; ++j) {
                pt = (POINT2)pts.get(j);
                switch (pt.style) {
                    case 0: {
                        this.moveTo(pt.x, pt.y);
                        continue block7;
                    }
                    case 1: {
                        this.lineTo(pt.x, pt.y);
                        continue block7;
                    }
                }
            }
            this.getPathIterator(null).reset();
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "intersect", new RendererException("Failed inside intersect", exc));
        }
    }
}

