/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.JavaTacticalRenderer;

import armyc2.c2sd.JavaLineArray.POINT2;
import armyc2.c2sd.JavaLineArray.Shape2;
import armyc2.c2sd.JavaLineArray.lineutility;
import armyc2.c2sd.JavaLineArray.ref;
import armyc2.c2sd.JavaTacticalRenderer.TGLight;
import armyc2.c2sd.JavaTacticalRenderer.clsMETOC;
import armyc2.c2sd.JavaTacticalRenderer.mdlGeodesic;
import armyc2.c2sd.graphics2d.BasicStroke;
import armyc2.c2sd.graphics2d.BufferedImage;
import armyc2.c2sd.graphics2d.Graphics2D;
import armyc2.c2sd.graphics2d.Line2D;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Polygon;
import armyc2.c2sd.graphics2d.Rectangle2D;
import armyc2.c2sd.graphics2d.TexturePaint;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.RendererException;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class clsUtility {
    private static Map<String, Object> linetypes = null;
    private static Map<String, Object> metocs = null;
    private static final String _className = "clsUtility";

    protected static Point2D POINT2ToPoint2D(POINT2 pt2) {
        if (pt2 == null) {
            return null;
        }
        double x = pt2.x;
        double y = pt2.y;
        Point2D.Double pt = new Point2D.Double(x, y);
        return pt;
    }

    public static boolean linesOutsideClipBounds(TGLight tg, Rectangle2D clipBounds) {
        try {
            boolean isAutoshape = clsUtility.isAutoshape(tg);
            if (isAutoshape) {
                return false;
            }
            double xmin = clipBounds.getMinX();
            double xmax = clipBounds.getMaxX();
            double ymin = clipBounds.getMinY();
            double ymax = clipBounds.getMaxY();
            int j = 0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            Line2D.Double boundsEdge = null;
            Line2D.Double ptsLine = null;
            int n = tg.Pixels.size();
            for (j = 0; j < n - 1; ++j) {
                pt0 = tg.Pixels.get(j);
                pt1 = tg.Pixels.get(j + 1);
                if (clipBounds.contains(pt0.x, pt0.y)) {
                    return false;
                }
                if (clipBounds.contains(pt1.x, pt1.y)) {
                    return false;
                }
                ptsLine = new Line2D.Double(pt0.x, pt0.y, pt1.x, pt1.y);
                boundsEdge = new Line2D.Double(xmin, ymin, xmax, ymin);
                if (ptsLine.intersectsLine(boundsEdge)) {
                    return false;
                }
                boundsEdge = new Line2D.Double(xmax, ymin, xmax, ymax);
                if (ptsLine.intersectsLine(boundsEdge)) {
                    return false;
                }
                boundsEdge = new Line2D.Double(xmax, ymax, xmin, ymax);
                if (ptsLine.intersectsLine(boundsEdge)) {
                    return false;
                }
                boundsEdge = new Line2D.Double(xmin, ymax, xmin, ymin);
                if (!ptsLine.intersectsLine(boundsEdge)) continue;
                return false;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "linesOutsideClipBounds", new RendererException("Failed inside linesOutsideClipBounds", exc));
        }
        return true;
    }

    public static int GetMinPoints(int lineType) {
        int result = -1;
        switch (lineType) {
            case 14000001: 
            case 14000002: 
            case 24311000: {
                result = 1;
                break;
            }
            case 15000002: 
            case 24312000: 
            case 24321300: 
            case 24322300: 
            case 24323300: 
            case 24324300: 
            case 24325300: 
            case 24326200: 
            case 24331300: 
            case 24332300: 
            case 24333300: 
            case 24334300: 
            case 24335300: 
            case 24336300: 
            case 24337300: 
            case 24338300: 
            case 24339300: 
            case 24353000: 
            case 24363000: 
            case 25200101: {
                result = 1;
                break;
            }
            case 243111000: 
            case 243112000: {
                result = 1;
                break;
            }
            case 24321200: 
            case 24322200: 
            case 24323200: 
            case 24324200: 
            case 24325200: 
            case 24326101: 
            case 24331200: 
            case 24332200: 
            case 24333200: 
            case 24334200: 
            case 24335200: 
            case 24336200: 
            case 24337200: 
            case 24338200: 
            case 24339200: 
            case 24352000: 
            case 24362000: {
                result = 2;
                break;
            }
            case 22534000: 
            case 23163000: 
            case 23221000: 
            case 23222000: 
            case 23410000: 
            case 211800000: 
            case 212210001: 
            case 212220001: 
            case 212230001: 
            case 212300001: {
                result = 4;
                break;
            }
            case 0x222248: 
            case 21100000: 
            case 21200000: 
            case 21300000: 
            case 21400000: 
            case 21500000: 
            case 21600000: 
            case 21800000: 
            case 22139000: 
            case 22310000: 
            case 22422000: 
            case 22524000: 
            case 22533000: 
            case 22611000: 
            case 22612000: 
            case 22613000: 
            case 22623000: 
            case 23171000: 
            case 23173000: 
            case 23174000: 
            case 23191000: 
            case 23192000: 
            case 23193000: 
            case 23194000: 
            case 23211000: 
            case 23212000: 
            case 23213000: 
            case 23224000: 
            case 23225000: 
            case 31710000: 
            case 31720000: 
            case 31730000: 
            case 31740000: 
            case 31750000: 
            case 31751000: 
            case 31760000: 
            case 31770000: 
            case 31780000: 
            case 31790000: 
            case 32214000: 
            case 32222000: 
            case 32223000: 
            case 32224000: 
            case 32225200: 
            case 32231500: 
            case 32232400: 
            case 32233100: 
            case 32233500: 
            case 32244200: 
            case 32253000: 
            case 32254200: 
            case 32255200: 
            case 32311000: 
            case 32312000: 
            case 32313000: 
            case 32314000: 
            case 32315000: 
            case 32316000: 
            case 32317000: 
            case 32318000: 
            case 32319000: 
            case 32321000: 
            case 32322000: 
            case 32323000: 
            case 32324000: 
            case 32411100: 
            case 32411200: 
            case 32411300: 
            case 32411400: 
            case 32411500: 
            case 32411600: 
            case 32411700: 
            case 32411800: 
            case 32411900: 
            case 32412100: 
            case 32412200: 
            case 32412300: 
            case 32413100: 
            case 32413200: 
            case 32413300: 
            case 32414100: 
            case 32414200: 
            case 32414300: 
            case 32414400: 
            case 32414500: 
            case 32415100: 
            case 32415200: 
            case 32415300: 
            case 32416100: 
            case 32416200: 
            case 32416300: 
            case 32416400: 
            case 32416500: 
            case 32416600: 
            case 32416700: 
            case 32416800: 
            case 32416900: 
            case 32520000: 
            case 32540000: 
            case 32550000: 
            case 32560000: 
            case 32620000: 
            case 32670000: 
            case 211000000: 
            case 211700000: 
            case 212000000: 
            case 212210000: 
            case 212220000: 
            case 212230000: 
            case 212300000: 
            case 212400000: 
            case 212410000: 
            case 231100000: 
            case 317100000: 
            case 322512000: 
            case 324111000: 
            case 324111100: 
            case 324111200: 
            case 324111300: 
            case 324111400: 
            case 324111500: 
            case 324111600: 
            case 324111700: {
                result = 3;
                break;
            }
            case 22222000: 
            case 22224000: 
            case 22225000: 
            case 22421000: 
            case 22522100: 
            case 23120000: 
            case 23157000: 
            case 23172000: 
            case 23223000: 
            case 23226000: 
            case 23227000: 
            case 23340000: 
            case 24211000: 
            case 24250000: 
            case 24260000: 
            case 25211000: 
            case 25212000: {
                result = 2;
                break;
            }
            default: {
                result = 2;
            }
        }
        if (clsUtility.isClosedPolygon(lineType)) {
            result = 3;
        }
        return result;
    }

    public static boolean isBasicShape(int linetype) {
        switch (linetype) {
            case 10000000: 
            case 11000000: 
            case 12000000: 
            case 13000000: 
            case 13000001: 
            case 13000002: 
            case 14000000: 
            case 14000001: 
            case 14000002: 
            case 15000000: 
            case 15000001: 
            case 15000002: 
            case 15000003: 
            case 15000004: {
                return true;
            }
        }
        return false;
    }

    public static boolean isClosedPolygon(int linetype) {
        boolean result = false;
        switch (linetype) {
            case 0x222248: 
            case 11000000: 
            case 15000001: 
            case 15000004: 
            case 22131000: 
            case 22132000: 
            case 22133000: 
            case 22134000: 
            case 22135000: 
            case 22136000: 
            case 22137000: 
            case 22138000: 
            case 22231000: 
            case 22232000: 
            case 22233000: 
            case 22234000: 
            case 22234100: 
            case 22234200: 
            case 22235000: 
            case 22340000: 
            case 22350000: 
            case 22431000: 
            case 22431100: 
            case 22432000: 
            case 22531000: 
            case 22532000: 
            case 22535000: 
            case 22536000: 
            case 22621000: 
            case 22622000: 
            case 22624000: 
            case 22625000: 
            case 22626000: 
            case 23111000: 
            case 23113000: 
            case 23114000: 
            case 23115000: 
            case 23162000: 
            case 23164000: 
            case 23180000: 
            case 23350000: 
            case 23440000: 
            case 23450000: 
            case 23460000: 
            case 23490000: 
            case 24226000: 
            case 24313000: 
            case 24314000: 
            case 24315000: 
            case 24321100: 
            case 24322100: 
            case 24323100: 
            case 24324100: 
            case 24325100: 
            case 24330000: 
            case 24331100: 
            case 24332100: 
            case 24333100: 
            case 24334100: 
            case 24335100: 
            case 24336100: 
            case 24337100: 
            case 24338100: 
            case 24339100: 
            case 24351000: 
            case 24361000: 
            case 25310000: 
            case 25320000: 
            case 25330000: 
            case 25340000: 
            case 25351000: 
            case 25352000: 
            case 25353000: 
            case 31710000: 
            case 31720000: 
            case 31730000: 
            case 31740000: 
            case 31750000: 
            case 31751000: 
            case 31760000: 
            case 31770000: 
            case 31780000: 
            case 31790000: 
            case 32214000: 
            case 32222000: 
            case 32223000: 
            case 32224000: 
            case 32225200: 
            case 32231500: 
            case 32232400: 
            case 32233100: 
            case 32233500: 
            case 32244200: 
            case 32253000: 
            case 32254200: 
            case 32255200: 
            case 32311000: 
            case 32312000: 
            case 32313000: 
            case 32314000: 
            case 32315000: 
            case 32316000: 
            case 32317000: 
            case 32318000: 
            case 32319000: 
            case 32321000: 
            case 32322000: 
            case 32323000: 
            case 32324000: 
            case 32411100: 
            case 32411200: 
            case 32411300: 
            case 32411400: 
            case 32411500: 
            case 32411600: 
            case 32411700: 
            case 32411800: 
            case 32411900: 
            case 32412100: 
            case 32412200: 
            case 32412300: 
            case 32413100: 
            case 32413200: 
            case 32413300: 
            case 32414100: 
            case 32414200: 
            case 32414300: 
            case 32414400: 
            case 32414500: 
            case 32415100: 
            case 32415200: 
            case 32415300: 
            case 32416100: 
            case 32416200: 
            case 32416300: 
            case 32416400: 
            case 32416500: 
            case 32416600: 
            case 32416700: 
            case 32416800: 
            case 32416900: 
            case 32520000: 
            case 32540000: 
            case 32550000: 
            case 32560000: 
            case 32620000: 
            case 32670000: 
            case 221310000: 
            case 221311000: 
            case 243100000: 
            case 317100000: 
            case 322512000: 
            case 324111000: 
            case 324111100: 
            case 324111200: 
            case 324111300: 
            case 324111400: 
            case 324111500: 
            case 324111600: 
            case 324111700: {
                result = true;
            }
        }
        return result;
    }

    public static void ClosePolygon(ArrayList<POINT2> Pixels) {
        try {
            POINT2 pt0 = Pixels.get(0);
            POINT2 pt1 = Pixels.get(Pixels.size() - 1);
            if (pt0.x != pt1.x || pt0.y != pt1.y) {
                Pixels.add(new POINT2(pt0.x, pt0.y));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ClosePolygon", new RendererException("Failed inside ClosePolygon", exc));
        }
    }

    protected static void shiftModifiersLeft(POINT2 p1, POINT2 p2, double shift) {
        try {
            POINT2 pt1 = new POINT2(p1);
            POINT2 pt2 = new POINT2(p2);
            double dist = lineutility.CalcDistanceDouble(pt1, pt2);
            if (pt1.x < pt2.x || pt1.x == pt2.x && pt1.y < pt2.y) {
                pt1 = lineutility.ExtendAlongLineDouble(pt2, pt1, dist + shift);
                pt2 = lineutility.ExtendAlongLineDouble(pt1, pt2, dist - shift);
            } else {
                pt1 = lineutility.ExtendAlongLineDouble(pt2, pt1, dist - shift);
                pt2 = lineutility.ExtendAlongLineDouble(pt1, pt2, dist + shift);
            }
            p1.x = pt1.x;
            p1.y = pt1.y;
            p2.x = pt2.x;
            p2.y = pt2.y;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "shiftModifiersLeft", new RendererException("Failed inside shiftModifiersLeft", exc));
        }
    }

    protected static void ResolveModifierShape(TGLight tg, Shape2 shape) {
        try {
            int shapeStyle = shape.get_Style();
            int lineStyle = tg.get_LineStyle();
            int lineType = tg.get_LineType();
            boolean hasFill = clsUtility.LinesWithFill(lineType);
            int bolMETOC = clsMETOC.IsWeather(tg.get_SymbolId());
            if (bolMETOC > 0) {
                return;
            }
            int fillStyle = 0;
            block1 : switch (tg.get_LineType()) {
                case 22421000: {
                    shape.setFillColor(null);
                    shape.set_Style(tg.get_LineStyle());
                    shape.setLineColor(tg.get_LineColor());
                    break;
                }
                case 22235000: 
                case 23440000: 
                case 23450000: 
                case 23460000: 
                case 24324100: 
                case 24324200: 
                case 24324300: 
                case 24351000: 
                case 24352000: 
                case 24353000: 
                case 24361000: 
                case 24362000: 
                case 24363000: {
                    fillStyle = 3;
                    if (tg.get_UseHatchFill()) {
                        fillStyle = 0;
                    }
                    if (shape.getShapeType() == 0) {
                        shape.set_Style(tg.get_LineStyle());
                        shape.setLineColor(tg.get_LineColor());
                        shape.set_Fillstyle(fillStyle);
                        shape.setFillColor(tg.get_FillColor());
                    }
                    break;
                }
                case 23115000: {
                    if (shape.getShapeType() == 0) {
                        shape.set_Style(tg.get_LineStyle());
                        shape.setLineColor(tg.get_LineColor());
                        shape.set_Fillstyle(0);
                        shape.setFillColor(tg.get_FillColor());
                    }
                    break;
                }
                case 221310000: {
                    fillStyle = 2;
                    if (tg.get_UseHatchFill()) {
                        fillStyle = 0;
                    }
                    if (shape.getShapeType() == 0) {
                        shape.set_Style(tg.get_LineStyle());
                        shape.setLineColor(tg.get_LineColor());
                        shape.set_Fillstyle(fillStyle);
                        shape.setFillColor(tg.get_FillColor());
                    }
                    break;
                }
                case 23200001: {
                    if (shape.getShapeType() == 1) {
                        shape.set_Fillstyle(1);
                        shape.setFillColor(tg.get_LineColor());
                    }
                    if (shape.getShapeType() == 0) {
                        shape.set_Style(1);
                        shape.setLineColor(tg.get_LineColor());
                    }
                    break;
                }
                case 22139000: 
                case 22522100: 
                case 23131200: 
                case 23132000: 
                case 23172000: 
                case 23173000: 
                case 23174000: 
                case 23211000: 
                case 23212000: 
                case 23213000: 
                case 23223000: 
                case 211210000: {
                    if (shape.getShapeType() == 1) {
                        shape.set_Fillstyle(1);
                        shape.setFillColor(tg.get_LineColor());
                    }
                    if (shape.getShapeType() == 0) {
                        shape.set_Style(tg.get_LineStyle());
                        shape.setLineColor(tg.get_LineColor());
                    }
                    break;
                }
                case 21700000: 
                case 21710000: 
                case 22310000: 
                case 22528000: 
                case 23157000: 
                case 23191000: 
                case 23224000: 
                case 24220000: {
                    if (shape.getShapeType() == 0) {
                        shape.set_Style(1);
                        shape.setLineColor(tg.get_LineColor());
                    }
                    break;
                }
                case 22431100: {
                    if (shape.getShapeType() == 0) {
                        shape.set_Style(1);
                        shape.setLineColor(tg.get_LineColor());
                        shape.setFillColor(tg.get_FillColor());
                        shape.set_Fillstyle(tg.get_FillStyle());
                    }
                    break;
                }
                case 22340000: 
                case 22350000: {
                    if (shape.getShapeType() == 0) {
                        shape.setLineColor(tg.get_LineColor());
                        if (shapeStyle != lineStyle && shapeStyle != 1) {
                            shape.set_Style(lineStyle);
                        }
                    }
                    break;
                }
                case 0x222248: 
                case 22330000: 
                case 23192000: 
                case 23225000: 
                case 211200000: {
                    if (shape.getShapeType() == 0) {
                        shape.setLineColor(tg.get_LineColor());
                        if (shapeStyle != lineStyle && shapeStyle != 1) {
                            shape.set_Style(lineStyle);
                        }
                    }
                    break;
                }
                case 22320000: {
                    if (shape.getShapeType() == 0) {
                        shape.setLineColor(tg.get_LineColor());
                        if (shapeStyle != lineStyle && shapeStyle != 2) {
                            shape.set_Style(lineStyle);
                        }
                    }
                    break;
                }
                default: {
                    if (shape.getShapeType() == 1) {
                        shape.set_Fillstyle(tg.get_FillStyle());
                        shape.setFillColor(tg.get_FillColor());
                    }
                    if (shape.getShapeType() == 0) {
                        if (lineType != 22123000) {
                            shape.setLineColor(tg.get_LineColor());
                        }
                        shape.set_Style(lineStyle);
                        if (hasFill || clsUtility.isClosedPolygon(lineType) || clsUtility.IsChange1Area(lineType, null)) {
                            switch (lineType) {
                                case 15000001: 
                                case 15000003: 
                                case 243111000: 
                                case 243112000: {
                                    shape.setFillColor(null);
                                    break;
                                }
                                default: {
                                    shape.set_Fillstyle(tg.get_FillStyle());
                                    shape.setFillColor(tg.get_FillColor());
                                }
                            }
                        }
                        switch (lineType) {
                            case 13000000: 
                            case 14000000: {
                                shape.set_Fillstyle(tg.get_FillStyle());
                                shape.setFillColor(tg.get_FillColor());
                                break block1;
                            }
                            case 13000001: 
                            case 13000002: 
                            case 14000001: 
                            case 14000002: 
                            case 15000003: {
                                shape.setFillColor(null);
                                break block1;
                            }
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ResolveModifierShape", new RendererException("Failed inside ResolveModifierShape", exc));
        }
    }

    public static Color GetOpaqueColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return new Color(r, g, b);
    }

    public static boolean LinesWithFill(int linetype) {
        boolean result = false;
        try {
            switch (linetype) {
                case 10000000: 
                case 22121000: 
                case 22122000: 
                case 22123000: 
                case 22124000: 
                case 22125000: 
                case 22330000: 
                case 22421000: 
                case 22522100: 
                case 22522210: 
                case 22522220: 
                case 22523000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22613000: 
                case 23112000: 
                case 23120000: 
                case 23131100: 
                case 23134000: 
                case 23330000: 
                case 24210000: 
                case 24211000: 
                case 24220000: 
                case 24225000: 
                case 24230000: 
                case 24240000: 
                case 24250000: 
                case 24326100: 
                case 25211000: 
                case 25212000: 
                case 25221000: 
                case 25222000: 
                case 25223000: 
                case 25224000: 
                case 25225000: 
                case 211400000: 
                case 211600000: 
                case 211900000: 
                case 212100000: 
                case 212500000: 
                case 212600000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "LinesWithFill", new RendererException("Failed inside LinesWithFill", exc));
        }
        return result;
    }

    public static void tweakFillColor(TGLight tg) {
        try {
            if (!clsUtility.isSameColor(tg.get_LineColor(), tg.get_FillColor()).booleanValue()) {
                return;
            }
            Color fillColor = tg.get_FillColor();
            int r = fillColor.getRed();
            int g = fillColor.getGreen();
            int b = fillColor.getBlue();
            int alpha = fillColor.getAlpha();
            r = (int)((double)r * 0.9);
            g = (int)((double)g * 0.9);
            b = (int)((double)b * 0.9);
            alpha = (int)((double)alpha * 0.8);
            fillColor = new Color(r, g, b, alpha);
            tg.set_FillColor(fillColor);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "tweakFillColor", new RendererException("Failed inside tweakFillColor", exc));
        }
    }

    public static Boolean isSameColor(Color c1, Color c2) {
        try {
            if (c1 == null || c2 == null) {
                return true;
            }
            int r1 = c1.getRed();
            int r2 = c2.getRed();
            int g1 = c1.getGreen();
            int g2 = c2.getGreen();
            int b1 = c1.getBlue();
            int b2 = c2.getBlue();
            if (Math.abs(r1 - r2) < 5 && Math.abs(g1 - g2) < 5 && Math.abs(b1 - b2) < 5) {
                return true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "isSameColor", new RendererException("Failed inside isSameColor", exc));
        }
        return false;
    }

    public static BasicStroke getLineStroke(float width, int style, int cap, int round) {
        BasicStroke stroke = null;
        try {
            switch (style) {
                case 0: {
                    stroke = new BasicStroke(width, cap, round);
                    break;
                }
                case 1: {
                    float[] dash = new float[]{2.0f * width, 2.0f * width, 2.0f * width, 2.0f * width};
                    stroke = new BasicStroke(width, cap, round, 4.0f, dash, 0.0f);
                    break;
                }
                case 2: {
                    float[] dot = new float[]{0.1f * width, 2.0f * width, 0.1f * width, 2.0f * width, 0.1f * width, 2.0f * width, 0.1f * width, 2.0f * width};
                    stroke = new BasicStroke(width, cap, round, 4.0f, dot, 0.0f);
                    break;
                }
                case 3: {
                    float[] dashdot = new float[]{4.0f * width, 2.0f * width, 0.1f * width, 2.0f * width};
                    stroke = new BasicStroke(width, cap, round, 4.0f, dashdot, 0.0f);
                    break;
                }
                case 4: {
                    float[] dashdotdot = new float[]{2.0f * width, 2.0f * width, 0.1f * width, 2.0f * width, 0.1f * width, 2.0f * width};
                    stroke = new BasicStroke(width, cap, round, 4.0f, dashdotdot, 0.0f);
                    break;
                }
                default: {
                    stroke = new BasicStroke(width, cap, round);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getLineStroke", new RendererException("Failed inside getLineStroke", exc));
        }
        return stroke;
    }

    public static BasicStroke getLineStroke2(float width, int style, int cap, int round) {
        BasicStroke stroke = null;
        try {
            switch (style) {
                case 0: {
                    stroke = new BasicStroke(width, cap, round);
                    break;
                }
                case 1: {
                    float[] dash = new float[]{2.0f * width, 2.0f * width};
                    stroke = new BasicStroke(width, cap, round, 4.0f, dash, 0.0f);
                    break;
                }
                case 2: {
                    float[] dot = new float[]{0.1f * width, 2.0f * width};
                    stroke = new BasicStroke(width, cap, round, 4.0f, dot, 0.0f);
                    break;
                }
                case 3: {
                    float[] dashdot = new float[]{4.0f * width, 2.0f * width, 0.1f * width, 2.0f * width};
                    stroke = new BasicStroke(width, cap, round, 4.0f, dashdot, 0.0f);
                    break;
                }
                case 4: {
                    float[] dashdotdot = new float[]{2.0f * width, 2.0f * width, 0.1f * width, 2.0f * width, 0.1f * width, 2.0f * width};
                    stroke = new BasicStroke(width, cap, round, 4.0f, dashdotdot, 0.0f);
                    break;
                }
                default: {
                    stroke = new BasicStroke(width, cap, round);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getLineStroke", new RendererException("Failed inside getLineStroke", exc));
        }
        return stroke;
    }

    public static void SetShapeProperties(TGLight tg, ArrayList<Shape2> shapes, BufferedImage bi) {
        try {
            if (shapes == null) {
                return;
            }
            int j = 0;
            Shape2 shape = null;
            BasicStroke stroke = null;
            Object dash = null;
            int lineThickness = tg.get_LineThickness();
            int shapeType = -1;
            int lineType = tg.get_LineType();
            boolean hasFill = clsUtility.LinesWithFill(lineType);
            boolean isChange1Area = clsUtility.IsChange1Area(lineType, null);
            boolean isClosedPolygon = clsUtility.isClosedPolygon(lineType);
            if (tg.get_FillColor() == null) {
                switch (tg.get_LineType()) {
                    case 22221000: 
                    case 22222000: 
                    case 22222001: 
                    case 22223000: 
                    case 22224000: 
                    case 22224001: 
                    case 22225000: {
                        shape = shapes.get(shapes.size() - 1);
                        shapes.clear();
                        shapes.add(shape);
                        break;
                    }
                    case 21700000: 
                    case 21710000: 
                    case 22320000: 
                    case 22521100: 
                    case 22521200: 
                    case 22521300: 
                    case 22521410: 
                    case 22521420: {
                        ArrayList<Shape2> tempShapes = new ArrayList<Shape2>();
                        for (j = 0; j < shapes.size(); ++j) {
                            shape = shapes.get(j);
                            if (shape.getShapeType() == 1) continue;
                            tempShapes.add(shape);
                        }
                        shapes = tempShapes;
                        break;
                    }
                }
            }
            for (j = 0; j < shapes.size(); ++j) {
                shape = shapes.get(j);
                if (shape == null || shape.getShape() == null) continue;
                if (shape.getShapeType() == 1) {
                    switch (tg.get_LineType()) {
                        case 32214000: {
                            break;
                        }
                        default: {
                            shape.setFillColor(tg.get_FillColor());
                        }
                    }
                }
                clsUtility.ResolveModifierShape(tg, shape);
                if (lineType == 221311000 && j == 1) {
                    shape.setFillColor(null);
                }
                if (lineType == 15000002 && j == 0) {
                    shape.setLineColor(null);
                }
                shapeType = shape.getShapeType();
                if (lineType == 22123000) {
                    clsUtility.SetLCColor(tg, shape);
                }
                Rectangle2D.Double rect = null;
                Graphics2D grid = null;
                TexturePaint tp = tg.get_TexturePaint();
                if (hasFill || isClosedPolygon || isChange1Area || shapeType == 1) {
                    switch (shape.get_FillStyle()) {
                        case 3: {
                            rect = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
                            grid = bi.createGraphics();
                            grid.setColor(clsUtility.GetOpaqueColor(tg.get_LineColor()));
                            grid.setStroke(new BasicStroke(2.0f));
                            grid.drawLine(0.0, 8.0, 8.0, 0.0);
                            tp = new TexturePaint(bi, rect);
                            shape.setTexturePaint(tp);
                            shape.setFillColor(tg.get_FillColor());
                            grid.dispose();
                            break;
                        }
                        case 2: {
                            rect = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
                            grid = bi.createGraphics();
                            grid.setColor(clsUtility.GetOpaqueColor(tg.get_LineColor()));
                            grid.setStroke(new BasicStroke(2.0f));
                            grid.drawLine(0.0, 0.0, 8.0, 8.0);
                            tp = new TexturePaint(bi, rect);
                            shape.setTexturePaint(tp);
                            shape.setFillColor(tg.get_FillColor());
                            grid.dispose();
                            break;
                        }
                        case 6: {
                            rect = new Rectangle2D.Double(3.0, 3.0, 8.0, 8.0);
                            grid = bi.createGraphics();
                            grid.setColor(tg.get_FillColor());
                            grid.drawLine(3.0, 3.0, 5.0, 3.0);
                            grid.drawLine(5.0, 3.0, 5.0, 5.0);
                            grid.drawLine(5.0, 5.0, 3.0, 5.0);
                            grid.drawLine(3.0, 5.0, 5.0, 3.0);
                            tp = new TexturePaint(bi, rect);
                            shape.setTexturePaint(tp);
                            shape.setFillColor(null);
                            grid.dispose();
                            break;
                        }
                        case 4: {
                            rect = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
                            grid = bi.createGraphics();
                            grid.setColor(clsUtility.GetOpaqueColor(tg.get_LineColor()));
                            grid.setStroke(new BasicStroke(2.0f));
                            grid.drawLine(4.0, 0.0, 4.0, 8.0);
                            tp = new TexturePaint(bi, rect);
                            shape.setTexturePaint(tp);
                            shape.setFillColor(tg.get_FillColor());
                            grid.dispose();
                            break;
                        }
                        case 5: {
                            rect = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
                            grid = bi.createGraphics();
                            grid.setColor(clsUtility.GetOpaqueColor(tg.get_LineColor()));
                            grid.setStroke(new BasicStroke(2.0f));
                            grid.drawLine(0.0, 4.0, 8.0, 4.0);
                            tp = new TexturePaint(bi, rect);
                            shape.setTexturePaint(tp);
                            shape.setFillColor(tg.get_FillColor());
                            grid.dispose();
                            break;
                        }
                        case 7: {
                            rect = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
                            grid = bi.createGraphics();
                            grid.setColor(clsUtility.GetOpaqueColor(tg.get_LineColor()));
                            grid.setStroke(new BasicStroke(2.0f));
                            grid.drawLine(4.0, 2.0, 4.0, 6.0);
                            grid.drawLine(2.0, 4.0, 6.0, 4.0);
                            tp = new TexturePaint(bi, rect);
                            shape.setTexturePaint(tp);
                            shape.setFillColor(tg.get_FillColor());
                            grid.dispose();
                            break;
                        }
                        case 8: {
                            rect = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
                            grid = bi.createGraphics();
                            grid.setColor(clsUtility.GetOpaqueColor(tg.get_LineColor()));
                            grid.setStroke(new BasicStroke(2.0f));
                            grid.drawLine(2.0, 2.0, 8.0, 8.0);
                            grid.drawLine(2.0, 8.0, 8.0, 2.0);
                            tp = new TexturePaint(bi, rect);
                            shape.setTexturePaint(tp);
                            shape.setFillColor(tg.get_FillColor());
                            grid.dispose();
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                }
                if (lineThickness == 0) {
                    lineThickness = 1;
                }
                stroke = clsUtility.getLineStroke(lineThickness, shape.get_Style(), 1, 1);
                if (tg.get_Client().equalsIgnoreCase("ge")) {
                    if (tg.get_LineType() == 22320000 && shape.get_Style() == 2) {
                        shape.set_Style(1);
                    }
                    stroke = clsUtility.getLineStroke2(lineThickness, shape.get_Style(), 1, 1);
                }
                if (shape.getShapeType() == 1) {
                    stroke = new BasicStroke(lineThickness, 1, 0);
                }
                shape.setStroke(stroke);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "SetShapeProperties", new RendererException("Failed inside SetShapeProperties", exc));
        }
    }

    public static boolean IsChange1Area(int lineType, ref<int[]> minPoints) {
        try {
            if (minPoints != null) {
                minPoints.value = new int[1];
            }
            switch (lineType) {
                case 25200101: {
                    if (minPoints != null) {
                        ((int[])minPoints.value)[0] = 1;
                    }
                    return true;
                }
                case 22421000: {
                    if (minPoints != null) {
                        ((int[])minPoints.value)[0] = 1;
                    }
                    return false;
                }
                case 14000001: 
                case 14000002: 
                case 15000002: 
                case 24311000: 
                case 24312000: 
                case 24321300: 
                case 24322300: 
                case 24323300: 
                case 24324300: 
                case 24325300: 
                case 24326200: 
                case 24331300: 
                case 24332300: 
                case 24333300: 
                case 24334300: 
                case 24335300: 
                case 24336300: 
                case 24337300: 
                case 24338300: 
                case 24339300: 
                case 24353000: 
                case 24363000: 
                case 243111000: 
                case 243111001: 
                case 243112000: {
                    if (minPoints != null) {
                        ((int[])minPoints.value)[0] = 1;
                    }
                    return true;
                }
                case 24321200: 
                case 24322200: 
                case 24323200: 
                case 24324200: 
                case 24325200: 
                case 24326101: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: {
                    if (minPoints != null) {
                        ((int[])minPoints.value)[0] = 1;
                    }
                    return true;
                }
            }
            return false;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "IsChange1Area", new RendererException("Failed inside IsChange1Area", exc));
            return false;
        }
    }

    public static void WriteFile(String str) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("Test.txt"));
            bufferedWriter.write(str);
            bufferedWriter.close();
            bufferedWriter = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "WriteFile", new RendererException("Failed inside WriteFile", exc));
        }
    }

    protected static void CalcIntersectPt(POINT2 pt1, double m1, POINT2 pt2, double m2, POINT2 ptIntersect) {
        try {
            if (m1 == m2) {
                return;
            }
            double x1 = pt1.x;
            double y1 = pt1.y;
            double x2 = pt2.x;
            double y2 = pt2.y;
            double dx2 = (y1 - y2 + m1 * x2 - m1 * x1) / (m2 - m1);
            double x3 = x2 + dx2;
            double y3 = y2 + m2 * dx2;
            ptIntersect.x = x3;
            ptIntersect.y = y3;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcIntersectPt", new RendererException("Failed inside CalcIntersectPt", exc));
        }
    }

    protected static int ChannelWidth(double[] pixels, ref<double[]> distanceToChannelPOINT2) {
        int width = 0;
        try {
            int numPOINT2s = pixels.length / 2;
            if (numPOINT2s < 3) {
                return 0;
            }
            POINT2 channelWidthPOINT2 = new POINT2(0.0, 0.0);
            POINT2 lastSegmentPt1 = new POINT2(0.0, 0.0);
            POINT2 lastSegmentPt2 = new POINT2(0.0, 0.0);
            lastSegmentPt1.x = pixels[2 * numPOINT2s - 6];
            lastSegmentPt1.y = pixels[2 * numPOINT2s - 5];
            lastSegmentPt2.x = pixels[2 * numPOINT2s - 4];
            lastSegmentPt2.y = pixels[2 * numPOINT2s - 3];
            channelWidthPOINT2.x = pixels[2 * numPOINT2s - 2];
            channelWidthPOINT2.y = pixels[2 * numPOINT2s - 1];
            ref<double[]> m = new ref<double[]>();
            double m1 = 0.0;
            double distance = 0.0;
            POINT2 ptIntersect = new POINT2(0.0, 0.0);
            boolean bolVertical = lineutility.CalcTrueSlopeDouble2(lastSegmentPt1, lastSegmentPt2, m);
            if (bolVertical && ((double[])m.value)[0] != 0.0) {
                m1 = -1.0 / ((double[])m.value)[0];
                clsUtility.CalcIntersectPt(channelWidthPOINT2, m1, lastSegmentPt2, ((double[])m.value)[0], ptIntersect);
                distance = lineutility.CalcDistanceDouble(channelWidthPOINT2, ptIntersect);
            }
            if (bolVertical && ((double[])m.value)[0] == 0.0) {
                distance = Math.abs(channelWidthPOINT2.y - lastSegmentPt1.y);
            }
            if (!bolVertical) {
                distance = Math.abs(channelWidthPOINT2.x - lastSegmentPt1.x);
                distanceToChannelPOINT2.value = new double[1];
                ((double[])distanceToChannelPOINT2.value)[0] = distance;
                return (int)distance * 4;
            }
            width = (int)distance * 8;
            if (width < 2) {
                width = 2;
            }
            double hypotenuse = lineutility.CalcDistanceDouble(lastSegmentPt2, channelWidthPOINT2);
            distanceToChannelPOINT2.value = new double[1];
            ((double[])distanceToChannelPOINT2.value)[0] = Math.sqrt(hypotenuse * hypotenuse - distance * distance);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ChannelWidth", new RendererException("Failed inside ChannelWidth", exc));
        }
        return width;
    }

    private static boolean InYOrder(POINT2 pt0, POINT2 pt1, POINT2 pt2) {
        try {
            if (pt0.y <= pt1.y && pt1.y <= pt2.y) {
                return true;
            }
            if (pt2.y <= pt1.y && pt1.y <= pt0.y) {
                return true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "InYOrder", new RendererException("Failed inside InYOrder", exc));
        }
        return false;
    }

    private static boolean InXOrder(POINT2 pt0, POINT2 pt1, POINT2 pt2) {
        try {
            if (pt0.x <= pt1.x && pt1.x <= pt2.x) {
                return true;
            }
            if (pt2.x <= pt1.x && pt1.x <= pt0.x) {
                return true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "InXOrder", new RendererException("Failed inside InXOrder", exc));
        }
        return false;
    }

    public static void GetSectorRadiiFromPoints(TGLight tg) {
        try {
            if (tg.get_LineType() == 243111001) {
                return;
            }
            POINT2 ptCenter = tg.LatLongs.get(0);
            POINT2 ptLeftMin = new POINT2();
            POINT2 ptRightMax = new POINT2();
            int k = 0;
            String strLeft = "";
            String strRight = "";
            String strMin = "";
            String strMax = "";
            String temp = "";
            double nLeft = 0.0;
            double nRight = 0.0;
            double nMin = 0.0;
            double nMax = 0.0;
            double dist = 0.0;
            ref<double[]> a12 = new ref<double[]>();
            ref<double[]> a21 = new ref<double[]>();
            int numSectors = 0;
            if (tg.LatLongs.size() > 2) {
                numSectors = (tg.LatLongs.size() - 2) / 2;
                for (k = 0; k < numSectors; ++k) {
                    ptLeftMin = tg.LatLongs.get(2 * k + 2);
                    ptRightMax = tg.LatLongs.get(2 * k + 3);
                    dist = mdlGeodesic.geodesic_distance(ptCenter, ptLeftMin, a12, a21);
                    nLeft = ((double[])a12.value)[0];
                    strLeft = Double.toString(nLeft);
                    nMin = dist;
                    strMin = Double.toString(nMin);
                    dist = mdlGeodesic.geodesic_distance(ptCenter, ptRightMax, a12, a21);
                    nRight = ((double[])a12.value)[0];
                    strRight = Double.toString(nRight);
                    nMax = dist;
                    strMax = Double.toString(nMax);
                    temp = k == 0 ? strLeft + "," + strRight + "," + strMin + "," + strMax : temp + "," + strLeft + "," + strRight + "," + strMin + "," + strMax;
                }
                if (!temp.equals("")) {
                    tg.set_H2(temp);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSectorRadiiFromPoints", new RendererException("Failed inside GetSectorRadiiFromPoints", exc));
        }
    }

    public static double[] GetRadii(TGLight tg, int lineType) {
        double[] radius = null;
        try {
            int n;
            if (lineType == 243111000 && tg.LatLongs.size() > 2) {
                POINT2 ptCenter = tg.LatLongs.get(0);
                POINT2 pt = new POINT2();
                double dist = 0.0;
                ref<double[]> a12 = new ref<double[]>();
                ref<double[]> a21 = new ref<double[]>();
                int rad = 0;
                String temp = "";
                int t = tg.LatLongs.size();
                for (int j = 2; j < t; ++j) {
                    pt = new POINT2(tg.LatLongs.get(j));
                    dist = mdlGeodesic.geodesic_distance(ptCenter, pt, a12, a21);
                    rad = (int)dist;
                    if (rad <= 0) continue;
                    if (j == 2) {
                        temp = Double.toString(rad);
                        continue;
                    }
                    temp = temp + ",";
                    temp = temp + Double.toString(rad);
                }
                tg.set_H2(temp);
            }
            String[] strRadius = null;
            String radii = tg.get_H2();
            if (lineType == 243112000) {
                clsUtility.GetSectorRadiiFromPoints(tg);
                radii = tg.get_H2();
            }
            if ((n = (strRadius = radii.split(",")).length) <= 0) {
                return null;
            }
            radius = new double[n];
            if (lineType == 243111000) {
                for (int k = 0; k < n; ++k) {
                    radius[k] = Double.parseDouble(strRadius[k]);
                }
            } else if (lineType == 243112000) {
                int numSectors = n / 4;
                double[] radius2 = new double[numSectors * 2];
                int l = 0;
                for (int k = 0; k < numSectors; ++k) {
                    radius2[l++] = Double.parseDouble(strRadius[4 * k + 2]);
                    radius2[l++] = Double.parseDouble(strRadius[4 * k + 3]);
                }
                radius = radius2;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetRadii", new RendererException("Failed inside GetRadii", exc));
        }
        return radius;
    }

    protected static void ReorderPixels(double[] pixels) {
        try {
            int j;
            int counter = 0;
            int numPoints = pixels.length / 2;
            double[] tempPixels = new double[pixels.length];
            for (j = 0; j < numPoints - 1; ++j) {
                double x = pixels[pixels.length - 2 * j - 4];
                double y = pixels[pixels.length - 2 * j - 3];
                tempPixels[counter] = x;
                tempPixels[counter + 1] = y;
                counter += 2;
            }
            int intPixelSize = pixels.length;
            tempPixels[counter] = pixels[intPixelSize - 2];
            tempPixels[counter + 1] = pixels[intPixelSize - 1];
            int n = pixels.length;
            for (j = 0; j < n; ++j) {
                pixels[j] = tempPixels[j];
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ReorderPixels", new RendererException("Failed inside ReorderPixels", exc));
        }
    }

    public static void FilterVerticalSegments(TGLight tg) {
        try {
            switch (tg.get_LineType()) {
                case 15000000: 
                case 21700000: 
                case 21710000: 
                case 22123000: 
                case 22123001: 
                case 22320000: 
                case 22521100: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 23111001: 
                case 23134000: 
                case 25223000: 
                case 25224000: 
                case 25225000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117101: 
                case 231117200: 
                case 231117201: 
                case 231117300: 
                case 231117301: {
                    break;
                }
                default: {
                    return;
                }
            }
            POINT2 ptCurrent = null;
            POINT2 ptLast = null;
            int n = tg.Pixels.size();
            for (int j = 1; j < n; ++j) {
                ptLast = new POINT2(tg.Pixels.get(j - 1));
                ptCurrent = new POINT2(tg.Pixels.get(j));
                if (!(Math.abs(ptCurrent.x - ptLast.x) < 1.0)) continue;
                ptCurrent.x += Math.pow(-1.0, j);
                tg.Pixels.set(j, ptCurrent);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "FilterVerticalSegments", new RendererException("Failed inside FilterVerticalSegments", exc));
        }
    }

    public static POINT2 ComputeLastPoint(ArrayList<POINT2> arrLocation) {
        POINT2 locD = new POINT2(0.0, 0.0);
        try {
            POINT2 locA = arrLocation.get(1);
            POINT2 locB = arrLocation.get(0);
            double dblDx = locB.x - locA.x;
            double dblDy = locB.y - locA.y;
            double dblTheta = Math.atan2(-dblDy, dblDx);
            POINT2 locC = new POINT2(0.0, 0.0);
            locC.x = (int)(locA.x + 0.85 * dblDx);
            locC.y = (int)(locA.y + 0.85 * dblDy);
            double dblAngle = dblTheta + 1.5707963267948966;
            if (dblAngle > Math.PI) {
                dblAngle -= Math.PI * 2;
            }
            if (dblAngle < -Math.PI) {
                dblAngle += Math.PI * 2;
            }
            double dblWidth = 30.0;
            locD.x = locC.x + dblWidth * Math.cos(dblAngle);
            locD.y = locC.y - dblWidth * Math.sin(dblAngle);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ComputeLastPoint", new RendererException("Failed inside ComputeLastPoint", exc));
        }
        return locD;
    }

    protected static void GetSegments(double[] pixels, boolean[] segments, double factor) {
        try {
            int j = 0;
            ref<double[]> m1 = new ref<double[]>();
            ref<double[]> m2 = new ref<double[]>();
            long numPoints = 0L;
            boolean bolVertical1 = false;
            boolean bolVertical2 = false;
            POINT2 pt0F = new POINT2(0.0, 0.0);
            POINT2 pt1F = new POINT2(0.0, 0.0);
            POINT2 pt2F = new POINT2(0.0, 0.0);
            segments[0] = true;
            numPoints = pixels.length / 2;
            j = 0;
            while ((long)j < numPoints - 2L) {
                pt0F.x = pixels[2 * j];
                pt0F.y = pixels[2 * j + 1];
                pt1F.x = pixels[2 * j + 2];
                pt1F.y = pixels[2 * j + 3];
                pt2F.x = pixels[2 * j + 4];
                pt2F.y = pixels[2 * j + 5];
                bolVertical1 = lineutility.CalcTrueSlopeDoubleForRoutes(pt0F, pt1F, m1);
                bolVertical2 = lineutility.CalcTrueSlopeDoubleForRoutes(pt1F, pt2F, m2);
                segments[j + 1] = true;
                if (bolVertical1 && bolVertical2 && Math.abs(Math.atan(((double[])m1.value)[0]) - Math.atan(((double[])m2.value)[0])) < 1.0 / factor && !clsUtility.InXOrder(pt0F, pt1F, pt2F)) {
                    segments[j + 1] = false;
                }
                if (!(bolVertical1 && !(Math.abs(((double[])m1.value)[0]) > factor) || bolVertical2 && !(Math.abs(((double[])m2.value)[0]) > factor) || clsUtility.InYOrder(pt0F, pt1F, pt2F))) {
                    segments[j + 1] = false;
                }
                ++j;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSegments", new RendererException("Failed inside GetSegments", exc));
        }
    }

    protected static void SetLCColor(TGLight tg, Shape2 shape) {
        try {
            String affiliation = tg.get_Affiliation();
            if (affiliation != null && affiliation.equals("H")) {
                if (shape.getLineColor() == Color.RED) {
                    shape.setLineColor(tg.get_LineColor());
                } else {
                    shape.setLineColor(Color.RED);
                }
            } else if (shape.getLineColor() != Color.RED) {
                shape.setLineColor(tg.get_LineColor());
            } else {
                shape.setLineColor(Color.RED);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "SetLCColor", new RendererException("Failed inside SetLCColor", exc));
        }
    }

    public static void ReverseUSASLCPointsByQuadrant(TGLight tg) {
        try {
            if (tg.Pixels.size() < 2) {
                return;
            }
            int quadrant = lineutility.GetQuadrantDouble(tg.Pixels.get(0), tg.Pixels.get(1));
            block1 : switch (tg.get_LineType()) {
                case 22123000: 
                case 22123001: {
                    if (tg.get_Affiliation() != null && tg.get_Affiliation().equals("H")) {
                        switch (quadrant) {
                            case 2: 
                            case 3: {
                                break block1;
                            }
                            case 1: 
                            case 4: {
                                int n = tg.Pixels.size();
                                ArrayList pts2 = (ArrayList)tg.Pixels.clone();
                                for (int j = 0; j < n; ++j) {
                                    tg.Pixels.set(j, (POINT2)pts2.get(n - j - 1));
                                }
                                break;
                            }
                        }
                        break;
                    }
                    switch (quadrant) {
                        case 1: 
                        case 4: {
                            break block1;
                        }
                        case 2: 
                        case 3: {
                            int n = tg.Pixels.size();
                            ArrayList pts2 = (ArrayList)tg.Pixels.clone();
                            for (int j = 0; j < n; ++j) {
                                tg.Pixels.set(j, (POINT2)pts2.get(n - j - 1));
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ReverseUSASLCPointsByQuadrant", new RendererException("Failed inside ReverseUSASLCPointsByQuadrant", exc));
        }
    }

    public static Shape2 getHatchShape(TGLight tg, BufferedImage bi) {
        Shape2 shape = null;
        try {
            if (tg.get_UseHatchFill()) {
                return null;
            }
            switch (tg.get_LineType()) {
                case 23115000: {
                    break;
                }
                default: {
                    return null;
                }
            }
            shape = new Shape2(0);
            shape.moveTo(tg.Pixels.get(0));
            int j = 0;
            int n = tg.Pixels.size();
            for (j = 1; j < n; ++j) {
                shape.lineTo(tg.Pixels.get(j));
            }
            shape.setLineColor(new Color(0, 0, 0, 0));
            shape.set_Fillstyle(3);
            Rectangle2D.Double rect = null;
            Graphics2D grid = null;
            TexturePaint tp = tg.get_TexturePaint();
            rect = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
            grid = bi.createGraphics();
            grid.setColor(clsUtility.GetOpaqueColor(tg.get_LineColor()));
            grid.setStroke(new BasicStroke(2.0f));
            grid.drawLine(0.0, 8.0, 8.0, 0.0);
            tp = new TexturePaint(bi, rect);
            shape.setTexturePaint(tp);
            shape.setFillColor(new Color(0, 0, 0, 0));
            grid.dispose();
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetHatchShape", new RendererException("Failed inside GetHatchShape", exc));
        }
        return shape;
    }

    public static synchronized void initializeLinetypes(int rev) {
        try {
            if (linetypes != null || metocs != null) {
                return;
            }
            linetypes = new HashMap<String, Object>();
            linetypes.put("BS_LINE--------", 10000000);
            linetypes.put("BS_AREA--------", 11000000);
            linetypes.put("BS_CROSS-------", 12000000);
            linetypes.put("BS_ELLIPSE-----", 13000000);
            linetypes.put("PBS_ELLIPSE----", 13000001);
            linetypes.put("PBS_CIRCLE-----", 13000002);
            linetypes.put("BS_RECTANGLE---", 14000000);
            linetypes.put("PBS_RECTANGLE--", 14000001);
            linetypes.put("PBS_SQUARE-----", 14000002);
            linetypes.put("BBS_LINE-------", 15000000);
            linetypes.put("BBS_AREA-------", 15000001);
            linetypes.put("BBS_POINT------", 15000002);
            linetypes.put("BBS_RECTANGLE--", 15000003);
            linetypes.put("BS_BBOX--------", 15000004);
            linetypes.put("G*MPOHO---****X", 23200000);
            linetypes.put("G*TPB-----****X", 21100000);
            linetypes.put("G*TPH-----****X", 21200000);
            linetypes.put("G*TPY-----****X", 21300000);
            linetypes.put("G*TPC-----****X", 21400000);
            linetypes.put("G*TPX-----****X", 21500000);
            linetypes.put("G*TPJ-----****X", 21600000);
            linetypes.put("G*TPK-----****X", 21700000);
            linetypes.put("G*TPKF----****X", 21710000);
            linetypes.put("G*TPL-----****X", 21800000);
            linetypes.put("G*TPT-----****X", 211000000);
            linetypes.put("G*TPF-----****X", 211100000);
            linetypes.put("G*TPA-----****X", 211200000);
            linetypes.put("G*TPAS----****X", 211210000);
            linetypes.put("G*TPE-----****X", 211400000);
            linetypes.put("G*TPO-----****X", 211600000);
            linetypes.put("G*TPP-----****X", 211700000);
            linetypes.put("G*TPR-----****X", 211800000);
            linetypes.put("G*TPQ-----****X", 211900000);
            linetypes.put("G*TPM-----****X", 212000000);
            linetypes.put("G*TPS-----****X", 212100000);
            linetypes.put("G*TPUS----****X", 212210000);
            linetypes.put("G*TPUC----****X", 212230000);
            linetypes.put("G*TPUG----****X", 212220000);
            linetypes.put("G*TPZ-----****X", 212300000);
            linetypes.put("G*TPW-----****X", 212400000);
            linetypes.put("G*TPWP----****X", 212410000);
            linetypes.put("G*TPV-----****X", 212500000);
            linetypes.put("G*TP2-----****X", 212600000);
            linetypes.put("G*GPGLB---****X", 22121000);
            linetypes.put("G*GPGLF---****X", 22122000);
            linetypes.put("G*GPGLC---****X", 22123000);
            linetypes.put("G*GPGLP---****X", 22124000);
            linetypes.put("G*GPGLL---****X", 22125000);
            linetypes.put("G*GPGAG---****X", 22131000);
            linetypes.put("G*GPGAA---****X", 22132000);
            linetypes.put("G*GPGAE---****X", 22133000);
            linetypes.put("G*GPGAF---****X", 22134000);
            linetypes.put("G*GPGAD---****X", 22135000);
            linetypes.put("G*GPGAX---****X", 22136000);
            linetypes.put("G*GPGAL---****X", 22137000);
            linetypes.put("G*GPGAP---****X", 22138000);
            linetypes.put("G*GPGAS---****X", 22139000);
            linetypes.put("G*GPGAY---****X", 221310000);
            linetypes.put("G*GPGAZ---****X", 221311000);
            linetypes.put("G*GPALC---****X", 22221000);
            linetypes.put("G*GPALM---****X", 22222000);
            linetypes.put("G*GPALS---****X", 22223000);
            linetypes.put("G*GPALU---****X", 22224000);
            linetypes.put("G*GPALL---****X", 22225000);
            linetypes.put("G*GPAAR---****X", 22231000);
            linetypes.put("G*GPAAF---****X", 22232000);
            linetypes.put("G*GPAAH---****X", 22233000);
            linetypes.put("G*GPAAM---****X", 22234000);
            linetypes.put("G*GPAAML--****X", 22234100);
            linetypes.put("G*GPAAMH--****X", 22234200);
            linetypes.put("G*GPAAW---****X", 22235000);
            linetypes.put("G*GPPD----****X", 22310000);
            linetypes.put("G*GPPA----****X", 22320000);
            linetypes.put("G*GPPF----****X", 22330000);
            linetypes.put("G*GPPM----****X", 22340000);
            linetypes.put("G*GPPY----****X", 22350000);
            linetypes.put("G*GPPC----****X", 0x222248);
            linetypes.put("G*GPDLF---****X", 22421000);
            linetypes.put("G*GPDLP---****X", 22422000);
            linetypes.put("G*GPDAB---****X", 22431000);
            linetypes.put("G*GPDABP--****X", 22431100);
            linetypes.put("G*GPDAE---****X", 22432000);
            linetypes.put("G*GPOLAV--****X", 22521100);
            linetypes.put("G*GPOLAA--****X", 22521200);
            linetypes.put("G*GPOLAR--****X", 22521300);
            linetypes.put("G*GPOLAGM-****X", 22521410);
            linetypes.put("G*GPOLAGS-****X", 22521420);
            linetypes.put("G*GPOLKA--****X", 22522100);
            linetypes.put("G*GPOLKGM-****X", 22522210);
            linetypes.put("G*GPOLKGS-****X", 22522220);
            linetypes.put("G*GPOLF---****X", 22523000);
            linetypes.put("G*GPOLI---****X", 22524000);
            linetypes.put("G*GPOLL---****X", 22525000);
            linetypes.put("G*GPOLT---****X", 22526000);
            linetypes.put("G*GPOLC---****X", 22527000);
            linetypes.put("G*GPOLP---****X", 22528000);
            linetypes.put("G*GPOAA---****X", 22531000);
            linetypes.put("G*GPOAK---****X", 22532000);
            linetypes.put("G*GPOAF---****X", 22533000);
            linetypes.put("G*GPOAS---****X", 22534000);
            linetypes.put("G*GPOAO---****X", 22535000);
            linetypes.put("G*GPOAP---****X", 22536000);
            linetypes.put("G*GPSLA---****X", 22611000);
            linetypes.put("G*GPSLH---****X", 22612000);
            linetypes.put("G*GPSLR---****X", 22613000);
            linetypes.put("G*GPSLB---****X", 22623000);
            linetypes.put("G*GPSAO---****X", 22621000);
            linetypes.put("G*GPSAA---****X", 22622000);
            linetypes.put("G*GPSAE---****X", 22624000);
            linetypes.put("G*GPSAN---****X", 22625000);
            linetypes.put("G*GPSAT---****X", 22626000);
            linetypes.put("G*MPOGB---****X", 23111000);
            linetypes.put("G*MPOGL---****X", 23112000);
            linetypes.put("G*MPOGZ---****X", 23113000);
            linetypes.put("G*MPOGF---****X", 23114000);
            linetypes.put("G*MPOGR---****X", 23115000);
            linetypes.put("G*MPOS----****X", 23120000);
            linetypes.put("G*MPOADU--****X", 23131100);
            linetypes.put("G*MPOADC--****X", 23131200);
            linetypes.put("G*MPOAR---****X", 23132000);
            linetypes.put("G*MPOAW---****X", 23134000);
            linetypes.put("G*MPOMC---****X", 23157000);
            linetypes.put("G*MPOFD---****X", 23162000);
            linetypes.put("G*MPOFG---****X", 23163000);
            linetypes.put("G*MPOFA---****X", 23164000);
            linetypes.put("G*MPOEB---****X", 23171000);
            linetypes.put("G*MPOEF---****X", 23172000);
            linetypes.put("G*MPOET---****X", 23173000);
            linetypes.put("G*MPOED---****X", 23174000);
            linetypes.put("G*MPOU----****X", 23180000);
            linetypes.put("G*MPORP---****X", 23191000);
            linetypes.put("G*MPORS---****X", 23192000);
            linetypes.put("G*MPORA---****X", 23193000);
            linetypes.put("G*MPORC---****X", 23194000);
            linetypes.put("G*MPOT----****X", 231100000);
            linetypes.put("G*MPOWU---****X", 231111000);
            linetypes.put("G*MPOWS---****X", 231112000);
            linetypes.put("G*MPOWD---****X", 231113000);
            linetypes.put("G*MPOWA---****X", 231114000);
            linetypes.put("G*MPOWL---****X", 231115000);
            linetypes.put("G*MPOWH---****X", 231116000);
            linetypes.put("G*MPOWCS--****X", 231117100);
            linetypes.put("G*MPOWCD--****X", 231117200);
            linetypes.put("G*MPOWCT--****X", 231117300);
            linetypes.put("G*MPBDE---****X", 23211000);
            linetypes.put("G*MPBDD---****X", 23212000);
            linetypes.put("G*MPBDI---****X", 23213000);
            linetypes.put("G*MPBCA---****X", 23221000);
            linetypes.put("G*MPBCB---****X", 23222000);
            linetypes.put("G*MPBCF---****X", 23223000);
            linetypes.put("G*MPBCE---****X", 23224000);
            linetypes.put("G*MPBCD---****X", 23225000);
            linetypes.put("G*MPBCL---****X", 23226000);
            linetypes.put("G*MPBCR---****X", 23227000);
            linetypes.put("G*MPSL----****X", 23330000);
            linetypes.put("G*MPSW----****X", 23340000);
            linetypes.put("G*MPSP----****X", 23350000);
            linetypes.put("G*MPNM----****X", 23410000);
            linetypes.put("G*MPNR----****X", 23440000);
            linetypes.put("G*MPNB----****X", 23450000);
            linetypes.put("G*MPNC----****X", 23460000);
            linetypes.put("G*MPNL----****X", 23490000);
            linetypes.put("G*FPLT----****X", 24250000);
            linetypes.put("G*FPLTS---****X", 24211000);
            linetypes.put("G*FPLTF---****X", 24260000);
            linetypes.put("G*FPLCF---****X", 24210000);
            linetypes.put("G*FPLCC---****X", 24220000);
            linetypes.put("G*FPLCN---****X", 24230000);
            linetypes.put("G*FPLCR---****X", 24240000);
            linetypes.put("G*FPAT----****X", 24330000);
            linetypes.put("G*FPATR---****X", 24311000);
            linetypes.put("G*FPATC---****X", 24312000);
            linetypes.put("G*FPATG---****X", 24313000);
            linetypes.put("G*FPATS---****X", 24314000);
            linetypes.put("G*FPATB---****X", 24315000);
            linetypes.put("G*FPACSI--****X", 24321100);
            linetypes.put("G*FPACSR--****X", 24321200);
            linetypes.put("G*FPACSC--****X", 24321300);
            linetypes.put("G*FPACAI--****X", 24322100);
            linetypes.put("G*FPACAR--****X", 24322200);
            linetypes.put("G*FPACAC--****X", 24322300);
            linetypes.put("G*FPACFI--****X", 24323100);
            linetypes.put("G*FPACFR--****X", 24323200);
            linetypes.put("G*FPACFC--****X", 24323300);
            linetypes.put("G*FPACNI--****X", 24324100);
            linetypes.put("G*FPACNR--****X", 24324200);
            linetypes.put("G*FPACNC--****X", 24324300);
            linetypes.put("G*FPACRI--****X", 24325100);
            linetypes.put("G*FPACRR--****X", 24325200);
            linetypes.put("G*FPACRC--****X", 24325300);
            linetypes.put("G*FPACPR--****X", 24326101);
            linetypes.put("G*FPACPC--****X", 24326200);
            linetypes.put("G*FPAZII--****X", 24331100);
            linetypes.put("G*FPAZIR--****X", 24331200);
            linetypes.put("G*FPAZIC--****X", 24331300);
            linetypes.put("G*FPAZXI--****X", 24332100);
            linetypes.put("G*FPAZXR--****X", 24332200);
            linetypes.put("G*FPAZXC--****X", 24332300);
            linetypes.put("G*FPAZSI--****X", 24333100);
            linetypes.put("G*FPAZSR--****X", 24333200);
            linetypes.put("G*FPAZSC--****X", 24333300);
            linetypes.put("G*FPAZCI--****X", 24334100);
            linetypes.put("G*FPAZCR--****X", 24334200);
            linetypes.put("G*FPAZCC--****X", 24334300);
            linetypes.put("G*FPAZDI--****X", 24335100);
            linetypes.put("G*FPAZDR--****X", 24335200);
            linetypes.put("G*FPAZDC--****X", 24335300);
            linetypes.put("G*FPAZFI--****X", 24336100);
            linetypes.put("G*FPAZFR--****X", 24336200);
            linetypes.put("G*FPAZFC--****X", 24336300);
            linetypes.put("G*FPAZZI--****X", 24337100);
            linetypes.put("G*FPAZZR--****X", 24337200);
            linetypes.put("G*FPAZZC--****X", 24337300);
            linetypes.put("G*FPAZBI--****X", 24338100);
            linetypes.put("G*FPAZBR--****X", 24338200);
            linetypes.put("G*FPAZBC--****X", 24338300);
            linetypes.put("G*FPAZVI--****X", 24339100);
            linetypes.put("G*FPAKBI--****X", 24351000);
            linetypes.put("G*FPAKBR--****X", 24352000);
            linetypes.put("G*FPAKBC--****X", 24353000);
            linetypes.put("G*FPAKPI--****X", 24361000);
            linetypes.put("G*FPAKPR--****X", 24362000);
            linetypes.put("G*FPAKPC--****X", 24363000);
            linetypes.put("G*FPAZVR--****X", 24339200);
            linetypes.put("G*FPAZVC--****X", 24339300);
            linetypes.put("G*FPAXC---****X", 243111000);
            linetypes.put("G*FPAXS---****X", 243112000);
            linetypes.put("G*SPLCM---****X", 25211000);
            linetypes.put("G*SPLCH---****X", 25212000);
            linetypes.put("G*SPLRM---****X", 25221000);
            linetypes.put("G*SPLRA---****X", 25222000);
            linetypes.put("G*SPLRO---****X", 25223000);
            linetypes.put("G*SPLRT---****X", 25224000);
            linetypes.put("G*SPLRW---****X", 25225000);
            linetypes.put("G*SPAD----****X", 25310000);
            linetypes.put("G*SPAE----****X", 25320000);
            linetypes.put("G*SPAR----****X", 25330000);
            linetypes.put("G*SPAH----****X", 25340000);
            linetypes.put("G*SPASB---****X", 25351000);
            linetypes.put("G*SPASD---****X", 25352000);
            linetypes.put("G*SPASR---****X", 25353000);
            linetypes.put("G*OPHN----****X", 26220000);
            linetypes.put("G*OPB-----****X", 26400000);
            linetypes.put("G*OPBE----****X", 26410000);
            linetypes.put("G*OPBA----****X", 26420000);
            linetypes.put("G*OPBT----****X", 26430000);
            linetypes.put("G*OPBO----****X", 26440000);
            linetypes.put("GENERIC---****X", 22131001);
            linetypes.put("G*FPLCM---****X", 24225000);
            if (rev == 1) {
                linetypes.put("G*TPUS----****X", 212210001);
                linetypes.put("G*TPUC----****X", 212230001);
                linetypes.put("G*TPUG----****X", 212220001);
                linetypes.put("G*TPZ-----****X", 212300001);
                linetypes.put("G*FPACEI--****X", 24333100);
                linetypes.put("G*FPACEC--****X", 24333300);
                linetypes.put("G*FPACER--****X", 24333200);
                linetypes.put("G*FPACDI--****X", 24335100);
                linetypes.put("G*FPACDC--****X", 24335300);
                linetypes.put("G*FPACDR--****X", 24335200);
                linetypes.put("G*FPACZI--****X", 24337100);
                linetypes.put("G*FPACZC--****X", 24337300);
                linetypes.put("G*FPACZR--****X", 24337200);
                linetypes.put("G*FPACBI--****X", 24338100);
                linetypes.put("G*FPACBC--****X", 24338300);
                linetypes.put("G*FPACBR--****X", 24338200);
                linetypes.put("G*FPACVI--****X", 24339100);
                linetypes.put("G*FPACVC--****X", 24339300);
                linetypes.put("G*FPACVR--****X", 24339200);
                linetypes.put("G*FPACT---****X", 24226000);
            }
            metocs = new HashMap<String, Object>();
            metocs.put("WA-DPFC----L---", 31131000);
            metocs.put("WA-DPFCU---L---", 31131100);
            metocs.put("WA-DPFC-FG-L---", 31131200);
            metocs.put("WA-DPFC-FY-L---", 31131300);
            metocs.put("WA-DPFW----L---", 31132000);
            metocs.put("WA-DPFWU---L---", 31132100);
            metocs.put("WA-DPFW-FG-L---", 31132200);
            metocs.put("WA-DPFW-FY-L---", 31132300);
            metocs.put("WA-DPFO----L---", 31133000);
            metocs.put("WA-DPFOU---L---", 31133100);
            metocs.put("WA-DPFO-FY-L---", 31133200);
            metocs.put("WA-DPFS----L---", 31134000);
            metocs.put("WA-DPFSU---L---", 31134100);
            metocs.put("WA-DPFS-FG-L---", 31134200);
            metocs.put("WA-DPFS-FY-L---", 31134300);
            metocs.put("WA-DPXT----L---", 31141000);
            metocs.put("WA-DPXR----L---", 31142000);
            metocs.put("WA-DPXSQ---L---", 31143000);
            metocs.put("WA-DPXIL---L---", 31144000);
            metocs.put("WA-DPXSH---L---", 31145000);
            metocs.put("WA-DPXITCZ-L---", 31146000);
            metocs.put("WA-DPXCV---L---", 31147000);
            metocs.put("WA-DPXITD--L---", 31148000);
            metocs.put("WA-DWJ-----L---", 31430000);
            metocs.put("WA-DWS-----L---", 31440000);
            metocs.put("WA-DBAIF----A--", 31710000);
            metocs.put("WA-DBAMV----A--", 31720000);
            metocs.put("WA-DBATB----A--", 31730000);
            metocs.put("WA-DBAI-----A--", 31740000);
            metocs.put("WA-DBALPNC--A--", 31750000);
            metocs.put("WA-DBALPC---A--", 31751000);
            metocs.put("WA-DBAFP----A--", 31760000);
            metocs.put("WA-DBAT-----A--", 31770000);
            metocs.put("WA-DBAFG----A--", 31780000);
            metocs.put("WA-DBAD-----A--", 31790000);
            metocs.put("WA-DBAFF----A--", 317100000);
            metocs.put("WA-DIPIB---L---", 31810000);
            metocs.put("WA-DIPCO---L---", 31820000);
            metocs.put("WA-DIPIS---L---", 31830000);
            metocs.put("WA-DIPIT---L---", 31840000);
            metocs.put("WA-DIPID---L---", 31850000);
            metocs.put("WA-DIPTH---L---", 31860000);
            metocs.put("WA-DIPFF---L---", 31870000);
            metocs.put("WO-DHHDB---L---", 32259000);
            metocs.put("WO-DIDID---L---", 32134000);
            metocs.put("WO-DILOV---L---", 32151000);
            metocs.put("WO-DILUC---L---", 32152000);
            metocs.put("WO-DILOR---L---", 32153000);
            metocs.put("WO-DILIEO--L---", 32154000);
            metocs.put("WO-DILIEE--L---", 32155000);
            metocs.put("WO-DILIER--L---", 32156000);
            metocs.put("WO-DIOC----L---", 32161000);
            metocs.put("WO-DIOCS---L---", 32162000);
            metocs.put("WO-DIOL----L---", 32163000);
            metocs.put("WO-DIOLF---L---", 32164000);
            metocs.put("WO-DHDDL---L---", 32212000);
            metocs.put("WO-DHDDC---L---", 32213000);
            metocs.put("WO-DHDDA----A--", 32214000);
            metocs.put("WO-DHCC----L---", 32221000);
            metocs.put("WO-DHCI-----A--", 32222000);
            metocs.put("WO-DHCB-----A--", 32223000);
            metocs.put("WO-DHCW-----A--", 32224000);
            metocs.put("WO-DHCF----L---", 32225100);
            metocs.put("WO-DHCF-----A--", 32225200);
            metocs.put("WO-DHPBA---L---", 32231400);
            metocs.put("WO-DHPBA----A--", 32231500);
            metocs.put("WO-DHPBP---L---", 32231700);
            metocs.put("WOS-HPFF----A--", 32232400);
            metocs.put("WO-DHPMD----A--", 32233100);
            metocs.put("WO-DHPMO---L---", 32233400);
            metocs.put("WO-DHPMO----A--", 32233500);
            metocs.put("WO-DHPMRA--L---", 32233600);
            metocs.put("WO-DHPMRB--L---", 32233700);
            metocs.put("WO-DHPSPA--L---", 32234100);
            metocs.put("WO-DHPSPB--L---", 32234200);
            metocs.put("WO-DHPSPS--L---", 32234300);
            metocs.put("WO-DHABP----A--", 32244200);
            metocs.put("WO-DHALLA--L---", 32246000);
            metocs.put("WO-DHHD-----A--", 32253000);
            metocs.put("WO-DHHDF----A--", 32254200);
            metocs.put("WO-DHHDK----A--", 32255200);
            metocs.put("WOS-HHDR---L---", 322510000);
            metocs.put("WO-DHHDD----A--", 322512000);
            metocs.put("WO-DTCCCFE-L---", 32272000);
            metocs.put("WO-DTCCCFF-L---", 32273000);
            metocs.put("WO-DOBVA----A--", 32311000);
            metocs.put("WO-DOBVB----A--", 32312000);
            metocs.put("WO-DOBVC----A--", 32313000);
            metocs.put("WO-DOBVD----A--", 32314000);
            metocs.put("WO-DOBVE----A--", 32315000);
            metocs.put("WO-DOBVF----A--", 32316000);
            metocs.put("WO-DOBVG----A--", 32317000);
            metocs.put("WO-DOBVH----A--", 32318000);
            metocs.put("WO-DOBVI----A--", 32319000);
            metocs.put("WO-DBSF-----A--", 32321000);
            metocs.put("WO-DBSG-----A--", 32322000);
            metocs.put("WO-DBSM-----A--", 32323000);
            metocs.put("WO-DBST-----A--", 32324000);
            metocs.put("WO-DGMSR----A--", 32411100);
            metocs.put("WO-DGMSC----A--", 32411200);
            metocs.put("WO-DGMSSVS--A--", 32411300);
            metocs.put("WO-DGMSSC---A--", 32411400);
            metocs.put("WO-DGMSSM---A--", 32411500);
            metocs.put("WO-DGMSSF---A--", 32411600);
            metocs.put("WO-DGMSSVF--A--", 32411700);
            metocs.put("WO-DGMSIVF--A--", 32411800);
            metocs.put("WO-DGMSIF---A--", 32411900);
            metocs.put("WO-DGMSIM---A--", 324111000);
            metocs.put("WO-DGMSIC---A--", 324111100);
            metocs.put("WO-DGMSB----A--", 324111200);
            metocs.put("WO-DGMS-CO--A--", 324111300);
            metocs.put("WO-DGMS-PH--A--", 324111400);
            metocs.put("WO-DGMS-SH--A--", 324111500);
            metocs.put("WO-DGML-----A--", 324111600);
            metocs.put("WO-DGMN-----A--", 324111700);
            metocs.put("WO-DGMRS----A--", 32412100);
            metocs.put("WO-DGMRM----A--", 32412200);
            metocs.put("WO-DGMRR----A--", 32412300);
            metocs.put("WO-DGMCL----A--", 32413100);
            metocs.put("WO-DGMCM----A--", 32413200);
            metocs.put("WO-DGMCH----A--", 32413300);
            metocs.put("WO-DGMIBA---A--", 32414100);
            metocs.put("WO-DGMIBB---A--", 32414200);
            metocs.put("WO-DGMIBC---A--", 32414300);
            metocs.put("WO-DGMIBD---A--", 32414400);
            metocs.put("WO-DGMIBE---A--", 32414500);
            metocs.put("WO-DGMBCA---A--", 32415100);
            metocs.put("WO-DGMBCB---A--", 32415200);
            metocs.put("WO-DGMBCC---A--", 32415300);
            metocs.put("WO-DGMBTA---A--", 32416100);
            metocs.put("WO-DGMBTB---A--", 32416200);
            metocs.put("WO-DGMBTC---A--", 32416300);
            metocs.put("WO-DGMBTD---A--", 32416400);
            metocs.put("WO-DGMBTE---A--", 32416500);
            metocs.put("WO-DGMBTF---A--", 32416600);
            metocs.put("WO-DGMBTG---A--", 32416700);
            metocs.put("WO-DGMBTH---A--", 32416800);
            metocs.put("WO-DGMBTI---A--", 32416900);
            metocs.put("WO-DL-ML---L---", 32510000);
            metocs.put("WO-DL-MA----A--", 32520000);
            metocs.put("WO-DL-RA---L---", 32530000);
            metocs.put("WO-DL-SA----A--", 32540000);
            metocs.put("WO-DL-TA----A--", 32550000);
            metocs.put("WO-DL-O-----A--", 32560000);
            metocs.put("WO-DMCA----L---", 32610000);
            metocs.put("WO-DMCC-----A--", 32620000);
            metocs.put("WO-DMCD----L---", 32630000);
            metocs.put("WO-DMOA-----A--", 32670000);
            metocs.put("WO-DMPA----L---", 32680000);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "initializeLinetypes", new RendererException("Failed inside initializeLinetypes", exc));
        }
    }

    public static int GetLinetypeFromString(String str) {
        int result = -1;
        try {
            String strLine = str;
            String strMask = strLine.substring(0, 1) + "*" + strLine.substring(2, 3) + "P" + strLine.substring(4, 10) + "****X";
            if (str.equalsIgnoreCase("GENERIC---****X")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("BS_LINE--------")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("BBS_LINE-------")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("BS_AREA--------")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("BBS_AREA-------")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("BS_CROSS-------")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("BBS_POINT------")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("BS_ELLIPSE-----")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("PBS_ELLIPSE----")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("PBS_CIRCLE-----")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("BS_RECTANGLE---")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("PBS_RECTANGLE--")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("PBS_SQUARE-----")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("BBS_RECTANGLE--")) {
                strMask = str;
            } else if (str.equalsIgnoreCase("BS_BBOX--------")) {
                strMask = str;
            }
            Object objResult = null;
            if (linetypes != null && metocs != null) {
                objResult = linetypes.get(strMask);
                if (objResult != null) {
                    return (Integer)objResult;
                }
                objResult = metocs.get(strLine);
                if (objResult != null) {
                    return (Integer)objResult;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CGetLinetypeFromString2", new RendererException("Failed inside CGetLinetypeFromString2", exc));
        }
        return result;
    }

    public static void setRevC(TGLight tg) {
        try {
            int rev = tg.getSymbologyStandard();
            if (rev == 0) {
                switch (tg.get_LineType()) {
                    case 22222000: {
                        tg.set_LineType(22222001);
                        return;
                    }
                    case 22224000: {
                        tg.set_LineType(22224001);
                        return;
                    }
                }
                return;
            }
            if (rev == 1) {
                switch (tg.get_LineType()) {
                    case 212210000: {
                        if (tg.Pixels.size() != 4) break;
                        tg.set_LineType(212210001);
                        break;
                    }
                    case 212220000: {
                        if (tg.Pixels.size() != 4) break;
                        tg.set_LineType(212220001);
                        break;
                    }
                    case 212230000: {
                        if (tg.Pixels.size() != 4) break;
                        tg.set_LineType(212230001);
                        break;
                    }
                    case 212300000: {
                        if (tg.Pixels.size() != 4) break;
                        tg.set_LineType(212300001);
                        break;
                    }
                    case 24326100: {
                        tg.set_LineType(24326101);
                        break;
                    }
                }
            }
            switch (tg.get_LineType()) {
                case 212210001: {
                    if (tg.Pixels.size() >= 4) break;
                    tg.set_LineType(212210000);
                    break;
                }
                case 212220001: {
                    if (tg.Pixels.size() >= 4) break;
                    tg.set_LineType(212220000);
                    break;
                }
                case 212230001: {
                    if (tg.Pixels.size() >= 4) break;
                    tg.set_LineType(212230000);
                    break;
                }
                case 212300001: {
                    if (tg.Pixels.size() >= 4) break;
                    tg.set_LineType(212300000);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "setRevC", new RendererException("Failed inside setRevC", exc));
        }
    }

    public static boolean isAutoshape(TGLight tg) {
        try {
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 12000000: 
                case 13000000: 
                case 13000001: 
                case 13000002: 
                case 14000000: 
                case 15000002: 
                case 15000003: 
                case 15000004: 
                case 21100000: 
                case 21200000: 
                case 21300000: 
                case 21400000: 
                case 21500000: 
                case 21600000: 
                case 21800000: 
                case 22139000: 
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: 
                case 22310000: 
                case 22422000: 
                case 22524000: 
                case 22533000: 
                case 22534000: 
                case 22611000: 
                case 23157000: 
                case 23163000: 
                case 23171000: 
                case 23172000: 
                case 23173000: 
                case 23174000: 
                case 23191000: 
                case 23192000: 
                case 23193000: 
                case 23194000: 
                case 23211000: 
                case 23212000: 
                case 23213000: 
                case 23221000: 
                case 23222000: 
                case 23223000: 
                case 23224000: 
                case 23225000: 
                case 23226000: 
                case 23227000: 
                case 23340000: 
                case 23410000: 
                case 24211000: 
                case 24250000: 
                case 24260000: 
                case 25211000: 
                case 25212000: 
                case 26400000: 
                case 26410000: 
                case 26420000: 
                case 26430000: 
                case 26440000: 
                case 211000000: 
                case 211100000: 
                case 211200000: 
                case 211210000: 
                case 211400000: 
                case 211600000: 
                case 211700000: 
                case 211800000: 
                case 211900000: 
                case 212000000: 
                case 212100000: 
                case 212210000: 
                case 212210001: 
                case 212220000: 
                case 212220001: 
                case 212230000: 
                case 212230001: 
                case 212300000: 
                case 212300001: 
                case 212400000: 
                case 212410000: 
                case 212500000: 
                case 212600000: 
                case 231100000: {
                    return true;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "isAutoshape", new RendererException("Failed inside isAutoshape", exc));
        }
        return false;
    }

    public static HashMap<Integer, Color> getMSRSegmentColors(TGLight tg) {
        HashMap<Integer, Color> hMap = null;
        try {
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 22121000: 
                case 25221000: 
                case 25222000: {
                    if (tg.get_H() == null || tg.get_H().isEmpty()) {
                        return null;
                    }
                    hMap = new HashMap<Integer, Color>();
                    break;
                }
                default: {
                    return null;
                }
            }
            String[] colorStrs = tg.get_H().split(",");
            int j = 0;
            int numSegs = colorStrs.length;
            String segPlusColor = "";
            String[] seg = null;
            Color color = null;
            int index = -1;
            for (j = 0; j < numSegs; ++j) {
                segPlusColor = colorStrs[j];
                if (!segPlusColor.contains(":")) continue;
                seg = segPlusColor.split(":");
                color = SymbolUtilities.getColorFromHexString(seg[1]);
                index = Integer.parseInt(seg[0]);
                hMap.put(index, color);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getMSRSegmentColors", new RendererException("Failed inside getMSRSegmentColors", exc));
        }
        return hMap;
    }

    public static HashMap getMSRSegmentColorStrings(TGLight tg) {
        HashMap<Integer, String> hMap = null;
        try {
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 22121000: 
                case 25221000: 
                case 25222000: {
                    if (tg.get_H() == null || tg.get_H().isEmpty()) {
                        return null;
                    }
                    hMap = new HashMap<Integer, String>();
                    break;
                }
                default: {
                    return null;
                }
            }
            String[] colorStrs = tg.get_H().split(",");
            int j = 0;
            int numSegs = colorStrs.length;
            String segPlusColor = "";
            String[] seg = null;
            int index = -1;
            for (j = 0; j < numSegs; ++j) {
                segPlusColor = colorStrs[j];
                if (!segPlusColor.contains(":")) continue;
                seg = segPlusColor.split(":");
                index = Integer.parseInt(seg[0]);
                hMap.put(new Integer(index), seg[1]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getMSRSegmentColorStrings", new RendererException("Failed inside getMSRSegmentColorStrings", exc));
        }
        return hMap;
    }

    public static void reviseHModifier(ArrayList<POINT2> originalPixels, TGLight tg) {
        try {
            if (tg.get_H() == null || tg.get_H().isEmpty()) {
                return;
            }
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 22121000: 
                case 25221000: 
                case 25222000: {
                    break;
                }
                default: {
                    return;
                }
            }
            int j = 0;
            int k = 0;
            int n = -1;
            boolean foundPt = false;
            int t = originalPixels.size();
            int u = tg.Pixels.size();
            for (j = 0; j < t; ++j) {
                for (k = 0; k < u; ++k) {
                    if (originalPixels.get((int)j).x != tg.Pixels.get((int)k).x || originalPixels.get((int)j).y != tg.Pixels.get((int)k).y) continue;
                    n = j;
                    foundPt = true;
                    break;
                }
                if (foundPt) break;
            }
            HashMap<Integer, Color> hmap = clsUtility.getMSRSegmentColors(tg);
            HashMap<Integer, Color> hmap2 = new HashMap<Integer, Color>();
            POINT2 segPt0 = null;
            POINT2 segPt1 = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            Color color = null;
            if (n < 1) {
                n = 1;
            }
            block7: for (Integer key : hmap.keySet()) {
                if (key < n - 1) continue;
                if (key + 1 > originalPixels.size() - 1) break;
                color = hmap.get(key);
                segPt0 = originalPixels.get(key);
                segPt1 = originalPixels.get(key + 1);
                u = tg.Pixels.size();
                for (j = 0; j < u - 1; ++j) {
                    pt0 = tg.Pixels.get(j);
                    pt1 = tg.Pixels.get(j + 1);
                    if (segPt0.x == pt0.x && segPt0.y == pt0.y) {
                        hmap2.put(j, color);
                        continue block7;
                    }
                    if (segPt1.x == pt1.x && segPt1.y == pt1.y) {
                        hmap2.put(j, color);
                        continue block7;
                    }
                    if (pt0.x == segPt1.x && pt0.y == segPt1.y || pt1.x == segPt0.x && pt1.y == segPt0.y) continue;
                    double dist0 = lineutility.CalcDistanceToLineDouble(segPt0, segPt1, pt0);
                    double dist1 = lineutility.CalcDistanceToLineDouble(segPt0, segPt1, pt1);
                    Line2D.Double lineOrigPts = new Line2D.Double(segPt0.x, segPt0.y, segPt1.x, segPt1.y);
                    Rectangle2D rectOrigPts = ((Line2D)lineOrigPts).getBounds2D();
                    Line2D.Double lineClipPts = new Line2D.Double(pt0.x, pt0.y, pt1.x, pt1.y);
                    Rectangle2D rectClipPts = ((Line2D)lineClipPts).getBounds2D();
                    if (!(dist0 < 1.0) || !(dist1 < 1.0) || !rectOrigPts.contains(rectClipPts)) continue;
                    hmap2.put(j, color);
                }
            }
            if (hmap2.isEmpty()) {
                tg.set_H(null);
                return;
            }
            String h = "";
            String temp = "";
            for (Integer key : hmap2.keySet()) {
                color = (Color)hmap2.get(key);
                temp = Integer.toHexString(color.toARGB());
                h = h + key.toString() + ":" + temp + ",";
            }
            h = h.substring(0, h.length() - 1);
            tg.set_H(h);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "reviseHModifer", new RendererException("Failed inside reviseHModifier", exc));
        }
    }

    public static void InterpolatePixels(TGLight tg) {
        try {
            if (!tg.get_UseLineInterpolation()) {
                return;
            }
            int linetype = tg.get_LineType();
            double glyphSize = 10.0;
            switch (linetype) {
                case 23131100: 
                case 23131200: {
                    glyphSize = 25.0;
                    break;
                }
                case 23132000: {
                    glyphSize = 50.0;
                    break;
                }
                case 22350000: {
                    glyphSize = 20.0;
                    break;
                }
                case 15000000: 
                case 22122000: 
                case 22123000: 
                case 22134000: 
                case 22624000: 
                case 23111000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23330000: 
                case 23350000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    glyphSize = 30.0;
                    break;
                }
                case 23112000: 
                case 23134000: 
                case 231111000: 
                case 231112000: {
                    glyphSize = 40.0;
                    break;
                }
                case 231113000: {
                    glyphSize = 50.0;
                    break;
                }
                default: {
                    return;
                }
            }
            HashMap<Integer, POINT2> hmapPixels = new HashMap<Integer, POINT2>();
            HashMap<Integer, POINT2> hmapGeo = new HashMap<Integer, POINT2>();
            int j = 0;
            int currentIndex = 0;
            double dist = 0.0;
            double dist2 = 0.0;
            double direction1 = 0.0;
            double direction2 = 0.0;
            double delta = 0.0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            int n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                if (j == 0) {
                    hmapPixels.put(j, tg.Pixels.get(j));
                    hmapGeo.put(j, tg.LatLongs.get(j));
                    currentIndex = 0;
                    continue;
                }
                if (j == tg.Pixels.size() - 1) {
                    hmapPixels.put(j, tg.Pixels.get(j));
                    hmapGeo.put(j, tg.LatLongs.get(j));
                    continue;
                }
                dist = lineutility.CalcDistanceDouble(tg.Pixels.get(currentIndex), tg.Pixels.get(j));
                dist2 = lineutility.CalcDistanceDouble(tg.Pixels.get(j), tg.Pixels.get(j + 1));
                pt0 = tg.Pixels.get(currentIndex);
                pt1 = tg.Pixels.get(j);
                pt2 = tg.Pixels.get(j + 1);
                direction1 = 57.29577951308232 * Math.atan((pt0.y - pt1.y) / (pt0.x - pt1.x));
                direction2 = 57.29577951308232 * Math.atan((pt1.y - pt2.y) / (pt1.x - pt2.x));
                delta = Math.abs(direction1 - direction2);
                if (!(dist > glyphSize) && !(dist2 > glyphSize) && !(delta > 20.0)) continue;
                hmapPixels.put(j, tg.Pixels.get(j));
                hmapGeo.put(j, tg.LatLongs.get(j));
                currentIndex = j;
            }
            ArrayList<POINT2> pixels = new ArrayList<POINT2>();
            ArrayList<POINT2> geo = new ArrayList<POINT2>();
            n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                if (hmapPixels.containsKey(j)) {
                    pixels.add((POINT2)hmapPixels.get(j));
                }
                if (!hmapGeo.containsKey(j)) continue;
                geo.add((POINT2)hmapGeo.get(j));
            }
            block9 : switch (linetype) {
                case 22134000: 
                case 22350000: 
                case 22624000: 
                case 23111000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23350000: {
                    if (pixels.size() != 2) break;
                    n = tg.Pixels.size();
                    for (j = 0; j < n; ++j) {
                        if (hmapPixels.containsKey(j) || hmapGeo.containsKey(j)) continue;
                        pixels.add(j, tg.Pixels.get(j));
                        geo.add(j, tg.LatLongs.get(j));
                        break block9;
                    }
                    break;
                }
            }
            tg.Pixels = pixels;
            tg.LatLongs = geo;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "InterpolatePixels", new RendererException("Failed inside InterpolatePixels", exc));
        }
    }

    protected static Line2D getExtendedLine(TGLight tg, int index, double dist) {
        Line2D.Double line = null;
        try {
            Polygon polygon = new Polygon();
            int j = 0;
            int n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                polygon.addPoint((int)tg.Pixels.get((int)j).x, (int)tg.Pixels.get((int)j).y);
            }
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            if (tg.Pixels.size() > 3) {
                pt0 = tg.Pixels.get(index);
                pt1 = tg.Pixels.get(index + 1);
            } else {
                pt0 = tg.Pixels.get(1);
                pt1 = tg.Pixels.get(2);
            }
            POINT2 ptExtend = null;
            int extend = -1;
            POINT2 midPt = lineutility.MidPointDouble(pt0, pt1, 0);
            double slope = Math.abs(pt1.y - pt0.y) / (pt1.x - pt0.x);
            if (slope <= 1.0) {
                ptExtend = lineutility.ExtendDirectedLine(pt0, pt1, midPt, 2, 2.0);
                extend = polygon.contains(ptExtend.x, ptExtend.y) ? 3 : 2;
            } else {
                ptExtend = lineutility.ExtendDirectedLine(pt0, pt1, midPt, 0, 2.0);
                extend = polygon.contains(ptExtend.x, ptExtend.y) ? 1 : 0;
            }
            POINT2 pt3 = null;
            POINT2 pt4 = null;
            pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, extend, dist);
            pt4 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, extend, dist);
            line = new Line2D.Double(pt3.x, pt3.y, pt4.x, pt4.y);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getExtendedLine", new RendererException("Failed inside getExtendedLine", exc));
        }
        return line;
    }
}

