/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.step.test;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import me.xujichang.step.R;
import me.xujichang.step.center.StepCenter;
import me.xujichang.step.counter.CounterListener;

public class MainActivity
extends AppCompatActivity {
    private Button btnCurrentStep;
    private TextView tvResult;
    private TextView tvTempCount;
    private Button btnOnceStep;
    private TextView tvStepCount;
    private TextView tvStatus;
    private boolean isTemp = false;
    private TextView tvStepTempCount;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_main);
        this.initView();
    }

    private void initView() {
        this.btnCurrentStep = (Button)this.findViewById(R.id.btn_currentStep);
        this.tvResult = (TextView)this.findViewById(R.id.tv_result);
        this.tvTempCount = (TextView)this.findViewById(R.id.tv_temp);
        this.btnOnceStep = (Button)this.findViewById(R.id.btn_once_Step);
        this.tvStatus = (TextView)this.findViewById(R.id.tv_status);
        this.tvStepCount = (TextView)this.findViewById(R.id.tv_step_count);
        this.tvStepTempCount = (TextView)this.findViewById(R.id.tv_step_temp_count);
        this.btnCurrentStep.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MainActivity.this.tvStepCount.setText((CharSequence)String.format("\u4eca\u5929\u8bb0\u6b65\u6570\uff1a%d \u6b65", StepCenter.instance().getStepCount()));
                MainActivity.this.tvStepTempCount.setText((CharSequence)String.format("\u672c\u6b21\u5355\u6b21\u8bb0\u6b65\u6570\uff1a%d \u6b65", StepCenter.instance().getTempStepCount()));
            }
        });
        this.btnOnceStep.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MainActivity.this.isTemp = !MainActivity.this.isTemp;
                MainActivity.this.btnOnceStep.setText((CharSequence)(MainActivity.this.isTemp ? "\u505c\u6b62\u5355\u6b21\u8ba1\u6b65" : "\u5f00\u59cb\u5355\u6b21\u8ba1\u6b65"));
                if (MainActivity.this.isTemp) {
                    StepCenter.instance().startCounter();
                } else {
                    int step = StepCenter.instance().stopCounter();
                    MainActivity.this.tvStepTempCount.setText((CharSequence)String.format("\u672c\u6b21\u5355\u6b21\u8bb0\u6b65\u6570\uff1a%d \u6b65", step));
                }
            }
        });
        StepCenter.instance().registerCounterListener(new CounterListener(){

            @Override
            public void onStepCount(float sum) {
                MainActivity.this.tvResult.setText((CharSequence)String.format("\u7cfb\u7edf\u8ba1\u6b65\u6570\uff1a%d \u6b65", (int)sum));
            }

            @Override
            public void onStepOnce(int step) {
                MainActivity.this.tvStatus.setText((CharSequence)String.format("\u83b7\u53d6\u5230\u4e00\u6b21\u8ba1\u6b65\u6570\uff1a %d", step));
            }

            @Override
            public void onStepTemp(int count) {
                MainActivity.this.tvTempCount.setText((CharSequence)String.format("\u5355\u6b21\u8ba1\u6b65\uff1a%d \u6b65", count));
            }
        });
    }

    private Context getContext() {
        return this;
    }
}

