/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.step.room.dao;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.RxRoom;
import android.database.Cursor;
import io.reactivex.Flowable;
import java.util.concurrent.Callable;
import me.xujichang.step.room.dao.StepDao;
import me.xujichang.step.room.entities.DayCount;
import me.xujichang.step.room.entities.TempCount;

public class StepDao_Impl
implements StepDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfTempCount;
    private final EntityInsertionAdapter __insertionAdapterOfDayCount;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfTempCount;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfDayCount;

    public StepDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTempCount = new EntityInsertionAdapter<TempCount>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `tbl_temp_step`(`startMs`,`stopMs`,`baseSc`,`currentSc`,`endSc`,`flag`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, TempCount value) {
                stmt.bindLong(1, value.getStartMs());
                stmt.bindLong(2, value.getStopMs());
                stmt.bindLong(3, (long)value.getBaseSc());
                stmt.bindLong(4, (long)value.getCurrentSc());
                stmt.bindLong(5, (long)value.getEndSc());
                stmt.bindLong(6, value.getFlag());
            }
        };
        this.__insertionAdapterOfDayCount = new EntityInsertionAdapter<DayCount>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `tbl_day_step`(`dayMs`,`baseSc`,`finishSc`,`currentSc`,`currentDaySc`,`isReboot`,`beforeSdSc`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, DayCount value) {
                stmt.bindLong(1, value.getDayMs());
                stmt.bindLong(2, (long)value.getBaseSc());
                stmt.bindLong(3, (long)value.getFinishSc());
                stmt.bindLong(4, (long)value.getCurrentSc());
                stmt.bindLong(5, (long)value.getCurrentDaySc());
                int _tmp = value.isReboot() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
                stmt.bindLong(7, (long)value.getBeforeSdSc());
            }
        };
        this.__updateAdapterOfTempCount = new EntityDeletionOrUpdateAdapter<TempCount>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `tbl_temp_step` SET `startMs` = ?,`stopMs` = ?,`baseSc` = ?,`currentSc` = ?,`endSc` = ?,`flag` = ? WHERE `flag` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, TempCount value) {
                stmt.bindLong(1, value.getStartMs());
                stmt.bindLong(2, value.getStopMs());
                stmt.bindLong(3, (long)value.getBaseSc());
                stmt.bindLong(4, (long)value.getCurrentSc());
                stmt.bindLong(5, (long)value.getEndSc());
                stmt.bindLong(6, value.getFlag());
                stmt.bindLong(7, value.getFlag());
            }
        };
        this.__updateAdapterOfDayCount = new EntityDeletionOrUpdateAdapter<DayCount>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `tbl_day_step` SET `dayMs` = ?,`baseSc` = ?,`finishSc` = ?,`currentSc` = ?,`currentDaySc` = ?,`isReboot` = ?,`beforeSdSc` = ? WHERE `dayMs` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, DayCount value) {
                stmt.bindLong(1, value.getDayMs());
                stmt.bindLong(2, (long)value.getBaseSc());
                stmt.bindLong(3, (long)value.getFinishSc());
                stmt.bindLong(4, (long)value.getCurrentSc());
                stmt.bindLong(5, (long)value.getCurrentDaySc());
                int _tmp = value.isReboot() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
                stmt.bindLong(7, (long)value.getBeforeSdSc());
                stmt.bindLong(8, value.getDayMs());
            }
        };
    }

    @Override
    public void startTempStep(TempCount count) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfTempCount.insert((Object)count);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void addDayCount(DayCount dayCount) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfDayCount.insert((Object)dayCount);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateTempStep(TempCount count) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfTempCount.handle((Object)count);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateDayCount(DayCount dayCount) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfDayCount.handle((Object)dayCount);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Flowable<TempCount> stopTempStep(String flag) {
        String _sql = "SELECT * FROM tbl_temp_step WHERE flag=?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM tbl_temp_step WHERE flag=?", (int)1);
        int _argIndex = 1;
        if (flag == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, flag);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"tbl_temp_step"}, (Callable)new Callable<TempCount>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TempCount call() throws Exception {
                try (Cursor _cursor = StepDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    TempCount _result;
                    int _cursorIndexOfStartMs = _cursor.getColumnIndexOrThrow("startMs");
                    int _cursorIndexOfStopMs = _cursor.getColumnIndexOrThrow("stopMs");
                    int _cursorIndexOfBaseSc = _cursor.getColumnIndexOrThrow("baseSc");
                    int _cursorIndexOfCurrentSc = _cursor.getColumnIndexOrThrow("currentSc");
                    int _cursorIndexOfEndSc = _cursor.getColumnIndexOrThrow("endSc");
                    int _cursorIndexOfFlag = _cursor.getColumnIndexOrThrow("flag");
                    if (_cursor.moveToFirst()) {
                        _result = new TempCount();
                        long _tmpStartMs = _cursor.getLong(_cursorIndexOfStartMs);
                        _result.setStartMs(_tmpStartMs);
                        long _tmpStopMs = _cursor.getLong(_cursorIndexOfStopMs);
                        _result.setStopMs(_tmpStopMs);
                        int _tmpBaseSc = _cursor.getInt(_cursorIndexOfBaseSc);
                        _result.setBaseSc(_tmpBaseSc);
                        int _tmpCurrentSc = _cursor.getInt(_cursorIndexOfCurrentSc);
                        _result.setCurrentSc(_tmpCurrentSc);
                        int _tmpEndSc = _cursor.getInt(_cursorIndexOfEndSc);
                        _result.setEndSc(_tmpEndSc);
                        long _tmpFlag = _cursor.getLong(_cursorIndexOfFlag);
                        _result.setFlag(_tmpFlag);
                    } else {
                        _result = null;
                    }
                    TempCount tempCount = _result;
                    return tempCount;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentSysTempCount(long dateMs) {
        String _sql = "SELECT currentSc FROM tbl_day_step WHERE dayMs =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT currentSc FROM tbl_day_step WHERE dayMs =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, dateMs);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTempStepCount(long flag) {
        String _sql = "SELECT currentSc FROM tbl_temp_step WHERE flag=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT currentSc FROM tbl_temp_step WHERE flag=?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, flag);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStepCount(long dateMs) {
        String _sql = "SELECT currentDaySc FROM tbl_day_step WHERE dayMs=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT currentDaySc FROM tbl_day_step WHERE dayMs=?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, dateMs);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DayCount getDayCount(long dateMs) {
        String _sql = "SELECT * FROM tbl_day_step WHERE dayMs=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM tbl_day_step WHERE dayMs=?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, dateMs);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            DayCount _result;
            int _cursorIndexOfDayMs = _cursor.getColumnIndexOrThrow("dayMs");
            int _cursorIndexOfBaseSc = _cursor.getColumnIndexOrThrow("baseSc");
            int _cursorIndexOfFinishSc = _cursor.getColumnIndexOrThrow("finishSc");
            int _cursorIndexOfCurrentSc = _cursor.getColumnIndexOrThrow("currentSc");
            int _cursorIndexOfCurrentDaySc = _cursor.getColumnIndexOrThrow("currentDaySc");
            int _cursorIndexOfIsReboot = _cursor.getColumnIndexOrThrow("isReboot");
            int _cursorIndexOfBeforeSdSc = _cursor.getColumnIndexOrThrow("beforeSdSc");
            if (_cursor.moveToFirst()) {
                _result = new DayCount();
                long _tmpDayMs = _cursor.getLong(_cursorIndexOfDayMs);
                _result.setDayMs(_tmpDayMs);
                int _tmpBaseSc = _cursor.getInt(_cursorIndexOfBaseSc);
                _result.setBaseSc(_tmpBaseSc);
                int _tmpFinishSc = _cursor.getInt(_cursorIndexOfFinishSc);
                _result.setFinishSc(_tmpFinishSc);
                int _tmpCurrentSc = _cursor.getInt(_cursorIndexOfCurrentSc);
                _result.setCurrentSc(_tmpCurrentSc);
                int _tmpCurrentDaySc = _cursor.getInt(_cursorIndexOfCurrentDaySc);
                _result.setCurrentDaySc(_tmpCurrentDaySc);
                int _tmp = _cursor.getInt(_cursorIndexOfIsReboot);
                boolean _tmpIsReboot = _tmp != 0;
                _result.setReboot(_tmpIsReboot);
                int _tmpBeforeSdSc = _cursor.getInt(_cursorIndexOfBeforeSdSc);
                _result.setBeforeSdSc(_tmpBeforeSdSc);
            } else {
                _result = null;
            }
            DayCount dayCount = _result;
            return dayCount;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

