/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.step.counter;

import android.app.Application;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import me.xujichang.step.counter.CounterListener;
import me.xujichang.step.counter.ICounter;
import me.xujichang.step.room.dao.StepDao;
import me.xujichang.step.room.database.StepCountDatabase;
import me.xujichang.step.room.entities.DayCount;
import me.xujichang.step.room.entities.TempCount;
import me.xujichang.step.utils.TimeUtil;
import me.xujichang.util.tool.LogTool;

public abstract class BaseCounter
implements SensorEventListener,
ICounter {
    static boolean isTempEnable = false;
    protected TempCount tempCount;
    private Application application;
    private CounterListener counterListener;

    public BaseCounter(Application application) {
        this.application = application;
    }

    @Override
    public void startTempCounter() {
        isTempEnable = true;
        this.initTempCount();
    }

    private void initTempCount() {
        long current = System.currentTimeMillis();
        long dateMs = TimeUtil.formatDayMs();
        int base = this.stepDao().getCurrentSysTempCount(dateMs);
        this.tempCount = new TempCount();
        this.tempCount.setBaseSc(base);
        this.tempCount.setFlag(current);
        this.tempCount.setStartMs(current);
        this.stepDao().startTempStep(this.tempCount);
    }

    private StepDao stepDao() {
        return StepCountDatabase.getInstance((Context)this.application).stepDao();
    }

    @Override
    public int stopTempCounter() {
        isTempEnable = false;
        return this.getTempStepCount();
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    @Override
    public int[] getStepCount() {
        int[] steps = new int[]{this.getAllStepCount(), this.getTempStepCount()};
        return steps;
    }

    @Override
    public int getTempStepCount() {
        if (null == this.tempCount) {
            return 0;
        }
        return this.stepDao().getTempStepCount(this.tempCount.getFlag());
    }

    @Override
    public int getAllStepCount() {
        long dateMs = TimeUtil.formatDayMs();
        return this.stepDao().getStepCount(dateMs);
    }

    @Override
    public void setCounterListener(CounterListener listener) {
        this.counterListener = listener;
    }

    void doOnceStep(int step) {
        LogTool.d((String)"\u53c8\u8d70\u4e86\u4e00\u6b65");
        if (isTempEnable) {
            if (null != this.counterListener) {
                this.counterListener.onStepTemp(step);
            }
            this.tempCount.increaseStep(step);
            this.stepDao().updateTempStep(this.tempCount);
        }
        if (null != this.counterListener) {
            this.counterListener.onStepOnce(step);
        }
    }

    void doCountStep(float sum) {
        LogTool.d((String)("\u603b\u5171\u8d70\u4e86" + sum + "\u6b65"));
        long dateMs = TimeUtil.formatDayMs();
        this.updateDayCount(dateMs, sum);
        if (isTempEnable) {
            this.tempCount.setEndSc((int)sum);
            this.stepDao().updateTempStep(this.tempCount);
        }
        if (null != this.counterListener) {
            this.counterListener.onStepCount(sum);
        }
    }

    private void updateDayCount(long dateMs, float sum) {
        int step = (int)sum;
        DayCount dayCount = this.stepDao().getDayCount(dateMs);
        if (null == dayCount) {
            this.initDayCount(dateMs, step);
        } else {
            dayCount.setCurrentSc(step);
            int currentDayCount = step - dayCount.getBaseSc() + dayCount.getBeforeSdSc();
            dayCount.setCurrentDaySc(currentDayCount);
            this.stepDao().updateDayCount(dayCount);
        }
    }

    private void initDayCount(long dateMs, float sum) {
        int base = (int)sum;
        DayCount dayCount = new DayCount();
        dayCount.setBaseSc(base);
        dayCount.setCurrentSc(base);
        dayCount.setDayMs(dateMs);
        dayCount.setReboot(false);
        this.stepDao().addDayCount(dayCount);
    }

    @Override
    public void onSystemShutDownOrReboot() {
        long dateMs = TimeUtil.formatDayMs();
        DayCount dayCount = this.stepDao().getDayCount(dateMs);
        if (null == dayCount) {
            return;
        }
        if (dayCount.getBaseSc() < 10) {
            return;
        }
        LogTool.d((String)("\u524d \uff1a" + dayCount.toString()));
        int step = dayCount.getCurrentDaySc();
        dayCount.setReboot(true);
        dayCount.setBeforeSdSc(step);
        dayCount.setBaseSc(0);
        this.stepDao().updateDayCount(dayCount);
        LogTool.d((String)("\u540e \uff1a" + dayCount.toString()));
    }
}

