/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.step.counter;

import android.hardware.SensorEvent;
import me.xujichang.step.counter.IDetectorListener;

public class AccDetector {
    private float[] oriValues = new float[3];
    private final int ValueNum = 4;
    private float[] tempValue = new float[4];
    private int tempCount = 0;
    private boolean isDirectionUp = false;
    private int continueUpCount = 0;
    private int continueUpFormerCount = 0;
    private boolean lastStatus = false;
    private float peakOfWave = 0.0f;
    private float valleyOfWave = 0.0f;
    private long timeOfThisPeak = 0L;
    private long timeOfLastPeak = 0L;
    private long timeOfNow = 0L;
    private float gravityNew = 0.0f;
    private float gravityOld = 0.0f;
    private final float InitialValue = 1.3f;
    private float ThreadValue = 2.0f;
    private int TimeInterval = 250;
    private IDetectorListener detectorListener;

    public AccDetector(IDetectorListener stepAccCounter) {
        this.setDetectorListener(stepAccCounter);
    }

    public void onSensorChanged(SensorEvent event) {
        for (int i = 0; i < 3; ++i) {
            this.oriValues[i] = event.values[i];
        }
        this.gravityNew = (float)Math.sqrt(this.oriValues[0] * this.oriValues[0] + this.oriValues[1] * this.oriValues[1] + this.oriValues[2] * this.oriValues[2]);
        this.detectorNewStep(this.gravityNew);
    }

    public void detectorNewStep(float values) {
        if (this.gravityOld == 0.0f) {
            this.gravityOld = values;
        } else if (this.detectorPeak(values, this.gravityOld)) {
            this.timeOfLastPeak = this.timeOfThisPeak;
            this.timeOfNow = System.currentTimeMillis();
            if (this.timeOfNow - this.timeOfLastPeak >= (long)this.TimeInterval && this.peakOfWave - this.valleyOfWave >= this.ThreadValue) {
                this.timeOfThisPeak = this.timeOfNow;
                if (null != this.detectorListener) {
                    this.detectorListener.onOnceStep();
                }
            }
            if (this.timeOfNow - this.timeOfLastPeak >= (long)this.TimeInterval && this.peakOfWave - this.valleyOfWave >= 1.3f) {
                this.timeOfThisPeak = this.timeOfNow;
                this.ThreadValue = this.peakValleyThread(this.peakOfWave - this.valleyOfWave);
            }
        }
        this.gravityOld = values;
    }

    public boolean detectorPeak(float newValue, float oldValue) {
        this.lastStatus = this.isDirectionUp;
        if (newValue >= oldValue) {
            this.isDirectionUp = true;
            ++this.continueUpCount;
        } else {
            this.continueUpFormerCount = this.continueUpCount;
            this.continueUpCount = 0;
            this.isDirectionUp = false;
        }
        if (!this.isDirectionUp && this.lastStatus && (this.continueUpFormerCount >= 2 || oldValue >= 20.0f)) {
            this.peakOfWave = oldValue;
            return true;
        }
        if (!this.lastStatus && this.isDirectionUp) {
            this.valleyOfWave = oldValue;
            return false;
        }
        return false;
    }

    public float peakValleyThread(float value) {
        float tempThread = this.ThreadValue;
        if (this.tempCount < 4) {
            this.tempValue[this.tempCount] = value;
            ++this.tempCount;
        } else {
            tempThread = this.averageValue(this.tempValue, 4);
            for (int i = 1; i < 4; ++i) {
                this.tempValue[i - 1] = this.tempValue[i];
            }
            this.tempValue[3] = value;
        }
        return tempThread;
    }

    public float averageValue(float[] value, int n) {
        float ave = 0.0f;
        for (int i = 0; i < n; ++i) {
            ave += value[i];
        }
        ave = (ave /= 4.0f) >= 8.0f ? 4.3f : (ave >= 7.0f && ave < 8.0f ? 3.3f : (ave >= 4.0f && ave < 7.0f ? 2.3f : (ave >= 3.0f && ave < 4.0f ? 2.0f : 1.7f)));
        return ave;
    }

    public void setDetectorListener(IDetectorListener detectorListener) {
        this.detectorListener = detectorListener;
    }
}

