/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.step.center;

import android.app.Application;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import me.xujichang.step.center.ICenter;
import me.xujichang.step.counter.BaseCounter;
import me.xujichang.step.counter.CounterListener;
import me.xujichang.step.counter.StepAccCounter;
import me.xujichang.step.counter.StepCounter;
import me.xujichang.util.tool.LogTool;

public class StepCenter
implements ICenter {
    private static volatile boolean isSensorOK = false;
    private SensorManager manager;
    private BaseCounter counter;

    public static void saveDayCount() {
        StepCenter.instance().counter.onSystemShutDownOrReboot();
    }

    private StepCenter() {
    }

    public static StepCenter instance() {
        return Holder.instance;
    }

    private void initAccSensor(Application application) {
        LogTool.d((String)"\u4f7f\u7528\u52a0\u901f\u5ea6\u4f20\u611f\u5668...");
        if (null == this.manager) {
            this.manager = StepCenter.getSensorManager(application);
        }
        if (StepCenter.isSensorEnable(application, 1)) {
            Sensor sensor = this.manager.getDefaultSensor(1);
            this.counter = new StepAccCounter(application);
            this.manager.registerListener((SensorEventListener)this.counter, sensor, 0);
        }
    }

    private void initStepSensor(Application application) {
        LogTool.d((String)"\u4f7f\u7528\u8ba1\u6b65\u4f20\u611f\u5668...");
        if (null == this.manager) {
            this.manager = StepCenter.getSensorManager(application);
        }
        Sensor mStepCount = this.manager.getDefaultSensor(19);
        Sensor mStepDoctor = this.manager.getDefaultSensor(18);
        this.counter = new StepCounter(application);
        this.manager.registerListener((SensorEventListener)this.counter, mStepDoctor, 0);
        this.manager.registerListener((SensorEventListener)this.counter, mStepCount, 0);
    }

    private static boolean isSensorEnable(Application application, int type) {
        SensorManager sensorManager = StepCenter.getSensorManager(application);
        return sensorManager.getDefaultSensor(type) != null;
    }

    private static SensorManager getSensorManager(Application application) {
        return (SensorManager)application.getSystemService("sensor");
    }

    public static void cancelListener(Application application) {
        StepCenter.instance().cancelListener();
    }

    private void cancelListener() {
        if (isSensorOK) {
            this.manager.unregisterListener((SensorEventListener)this.counter);
        }
    }

    public static void init(Application application) {
        isSensorOK = Build.VERSION.SDK_INT >= 19 ? StepCenter.isSensorEnable(application, 19) && StepCenter.isSensorEnable(application, 19) : false;
        if (isSensorOK) {
            StepCenter.instance().initStepSensor(application);
        } else {
            StepCenter.instance().initAccSensor(application);
        }
    }

    @Override
    public void startCounter() {
        this.counter.startTempCounter();
    }

    @Override
    public int stopCounter() {
        return this.counter.stopTempCounter();
    }

    @Override
    public int getStepCount() {
        return this.counter.getStepCount()[0];
    }

    @Override
    public int getTempStepCount() {
        return this.counter.getStepCount()[1];
    }

    @Override
    public int getStepCount(long start, long stop) {
        return 0;
    }

    public void registerCounterListener(CounterListener listener) {
        this.counter.setCounterListener(listener);
    }

    private static class Holder {
        static StepCenter instance = new StepCenter();

        private Holder() {
        }
    }
}

