/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.expandable;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemStorage;

public class ExpandableItemStorage
extends ItemStorage {
    @NonNull
    private final Object childItemFactoryListLock = new Object();
    private int childTypeIndex = 0;
    private boolean childItemFactoryLocked;
    @Nullable
    private ArrayList<ItemFactory> childItemFactoryList;
    @Nullable
    private SparseArray<Object> childItemFactoryArray;

    public ExpandableItemStorage(@NonNull AssemblyAdapter adapter) {
        super(adapter);
    }

    public ExpandableItemStorage(@NonNull AssemblyAdapter adapter, @Nullable List dataList) {
        super(adapter, dataList);
    }

    public ExpandableItemStorage(@NonNull AssemblyAdapter adapter, @Nullable Object[] dataArray) {
        super(adapter, dataArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildItemFactory(@NonNull ItemFactory childItemFactory) {
        if (childItemFactory == null || this.childItemFactoryLocked) {
            throw new IllegalStateException("childItemFactory is null or item factory list locked");
        }
        childItemFactory.setAdapter(this.getAdapter());
        childItemFactory.setItemType(this.childTypeIndex++);
        if (this.childItemFactoryArray == null) {
            this.childItemFactoryArray = new SparseArray();
        }
        this.childItemFactoryArray.put(childItemFactory.getItemType(), (Object)childItemFactory);
        Object object = this.childItemFactoryListLock;
        synchronized (object) {
            if (this.childItemFactoryList == null) {
                this.childItemFactoryList = new ArrayList(5);
            }
            this.childItemFactoryList.add(childItemFactory);
        }
    }

    @Nullable
    public List<ItemFactory> getChildItemFactoryList() {
        return this.childItemFactoryList;
    }

    public int getChildItemFactoryCount() {
        return this.childItemFactoryList != null ? this.childItemFactoryList.size() : 0;
    }

    public int getChildTypeCount() {
        this.childItemFactoryLocked = true;
        return this.childTypeIndex > 0 ? this.childTypeIndex : 1;
    }

    @Nullable
    public Object getChildItemFactoryByViewType(int viewType) {
        return this.childItemFactoryArray != null ? this.childItemFactoryArray.get(viewType) : null;
    }
}

