/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemStorage;

public class ItemHolder<DATA> {
    @NonNull
    private ItemStorage itemStorage;
    @NonNull
    private ItemFactory itemFactory;
    @Nullable
    private DATA data;
    private int position;
    private boolean header;
    private boolean enabled = true;

    public ItemHolder(@NonNull ItemStorage itemStorage, @NonNull ItemFactory itemFactory, @Nullable DATA data, boolean header) {
        this.itemStorage = itemStorage;
        this.itemFactory = itemFactory;
        this.data = data;
        this.header = header;
    }

    @Nullable
    public DATA getData() {
        return this.data;
    }

    public void setData(@Nullable DATA data) {
        this.data = data;
        AssemblyAdapter adapter = this.itemFactory.getAdapter();
        if (adapter != null && adapter.isNotifyOnChange()) {
            adapter.notifyDataSetChanged();
        }
    }

    @NonNull
    public ItemFactory getItemFactory() {
        return this.itemFactory;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.enableChanged();
    }

    protected void enableChanged() {
        if (this.header) {
            this.itemStorage.headerEnabledChanged(this);
        } else {
            this.itemStorage.footerEnabledChanged(this);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isHeader() {
        return this.header;
    }
}

