/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.List;

public class ArrayPagerAdapter
extends PagerAdapter {
    @NonNull
    private View[] views;
    private int notifyNumber = 0;
    @Nullable
    private SparseIntArray notifyNumberPool;

    public ArrayPagerAdapter(@NonNull View[] views) {
        this.views = views;
    }

    public ArrayPagerAdapter(@NonNull List<View> views) {
        this(views.toArray(new View[views.size()]));
    }

    @NonNull
    public View[] getViews() {
        return this.views;
    }

    public void setViews(@NonNull View[] views) {
        this.views = views;
        this.notifyDataSetChanged();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
    }

    public int getCount() {
        return this.views != null ? this.views.length : 0;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        View itemView = this.views[position];
        container.addView(itemView);
        return itemView;
    }

    public boolean isEnabledPositionNoneOnNotifyDataSetChanged() {
        return this.notifyNumberPool != null;
    }

    public void setEnabledPositionNoneOnNotifyDataSetChanged(boolean enabled) {
        if (enabled) {
            this.notifyNumberPool = new SparseIntArray();
            this.notifyNumber = 0;
        } else {
            this.notifyNumberPool = null;
        }
    }

    public void notifyDataSetChanged() {
        if (this.notifyNumberPool != null) {
            ++this.notifyNumber;
        }
        super.notifyDataSetChanged();
    }

    public int getItemPosition(@NonNull Object object) {
        if (this.notifyNumberPool != null && this.notifyNumberPool.get(object.hashCode()) != this.notifyNumber) {
            this.notifyNumberPool.put(object.hashCode(), this.notifyNumber);
            return -2;
        }
        return super.getItemPosition(object);
    }
}

