/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import java.util.List;
import me.panpf.adapter.pager.AssemblyPagerAdapter;
import me.panpf.adapter.pager.AssemblyPagerItemFactory;
import me.panpf.adapter.pager.PagerItemHolder;

public class PagerItemActor {
    @NonNull
    private AssemblyPagerAdapter adapter;

    public PagerItemActor(@NonNull AssemblyPagerAdapter adapter) {
        this.adapter = adapter;
    }

    public int getItemCount() {
        return this.adapter.getHeaderItemCount() + this.adapter.getDataCount() + this.adapter.getFooterItemCount();
    }

    @NonNull
    public View getItem(@NonNull ViewGroup container, int position) {
        int headerItemCount = this.adapter.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        List<PagerItemHolder> headerItemList = this.adapter.getHeaderItemList();
        if (headerItemList != null && position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            PagerItemHolder itemHolder = headerItemList.get(positionInHeaderList);
            View itemView = itemHolder.getItemFactory().dispatchCreateView(container.getContext(), container, position, itemHolder.getData());
            container.addView(itemView);
            return itemView;
        }
        int dataCount = this.adapter.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        List<AssemblyPagerItemFactory> itemFactoryList = this.adapter.getItemFactoryList();
        if (itemFactoryList != null && position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.adapter.getData(positionInDataList);
            int size = itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                AssemblyPagerItemFactory itemFactory = itemFactoryList.get(w);
                if (!itemFactory.match(dataObject)) continue;
                View itemView = itemFactory.dispatchCreateView(container.getContext(), container, position, dataObject);
                container.addView(itemView);
                return itemView;
            }
            throw new IllegalStateException(String.format("Didn't find suitable AssemblyPagerItemFactory. position=%d, dataObject=%s", position, dataObject != null ? dataObject.getClass().getName() : null));
        }
        int footerItemCount = this.adapter.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        List<PagerItemHolder> footerItemList = this.adapter.getFooterItemList();
        if (footerItemList != null && position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            PagerItemHolder itemHolder = footerItemList.get(positionInFooterList);
            View itemView = itemHolder.getItemFactory().dispatchCreateView(container.getContext(), container, position, itemHolder.getData());
            container.addView(itemView);
            return itemView;
        }
        throw new IllegalArgumentException("Illegal position: " + position);
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.adapter.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.adapter.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.adapter.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        throw new IllegalArgumentException("illegal position: " + position);
    }
}

