/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.assemblyadapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import me.panpf.assemblyadapter.AssemblyGroupItem;
import me.panpf.assemblyadapter.AssemblyGroupItemFactory;
import me.panpf.assemblyadapter.OnGroupLoadMoreListener;

public abstract class AssemblyLoadMoreGroupItemFactory
extends AssemblyGroupItemFactory<AssemblyLoadMoreGroupItem> {
    private boolean paused;
    private boolean end;
    private OnGroupLoadMoreListener eventListener;
    private AssemblyLoadMoreGroupItem loadMoreItem;

    public AssemblyLoadMoreGroupItemFactory(OnGroupLoadMoreListener eventListener) {
        this.eventListener = eventListener;
    }

    public void loadMoreFinished(boolean end) {
        this.paused = false;
        this.end = end;
        if (this.loadMoreItem != null) {
            if (end) {
                this.loadMoreItem.showEnd();
            } else {
                this.loadMoreItem.showLoading();
            }
        }
    }

    public void loadMoreFailed() {
        this.paused = false;
        if (this.loadMoreItem != null) {
            this.loadMoreItem.showErrorRetry();
        }
    }

    @Override
    public boolean isTarget(Object data) {
        return true;
    }

    public abstract class AssemblyLoadMoreGroupItem<T>
    extends AssemblyGroupItem<T> {
        public AssemblyLoadMoreGroupItem(int itemLayoutId, ViewGroup parent) {
            super(itemLayoutId, parent);
            AssemblyLoadMoreGroupItemFactory.this.loadMoreItem = this;
        }

        public AssemblyLoadMoreGroupItem(View convertView) {
            super(convertView);
            AssemblyLoadMoreGroupItemFactory.this.loadMoreItem = this;
        }

        public abstract View getErrorRetryView();

        public abstract void showLoading();

        public abstract void showErrorRetry();

        public abstract void showEnd();

        @Override
        public void onConfigViews(Context context) {
            View errorView = this.getErrorRetryView();
            if (errorView != null) {
                errorView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (AssemblyLoadMoreGroupItemFactory.this.eventListener != null) {
                            AssemblyLoadMoreGroupItemFactory.this.paused = false;
                            AssemblyLoadMoreGroupItem.this.setData(AssemblyLoadMoreGroupItem.this.getPosition(), AssemblyLoadMoreGroupItem.this.isExpanded(), AssemblyLoadMoreGroupItem.this.getData());
                        }
                    }
                });
            }
        }

        @Override
        protected void onSetData(int position, T t) {
            if (AssemblyLoadMoreGroupItemFactory.this.end) {
                this.showEnd();
            } else {
                this.showLoading();
                if (AssemblyLoadMoreGroupItemFactory.this.eventListener != null && !AssemblyLoadMoreGroupItemFactory.this.paused) {
                    AssemblyLoadMoreGroupItemFactory.this.paused = true;
                    AssemblyLoadMoreGroupItemFactory.this.eventListener.onLoadMore(AssemblyLoadMoreGroupItemFactory.this.getAdapter());
                }
            }
        }
    }
}

