/*
 * Decompiled with CFR 0.152.
 */
package me.doubledutch.lazyjson.compressor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import me.doubledutch.lazyjson.compressor.DictionaryCache;

public class Segment {
    public static final byte VOID = -1;
    public static final byte BYTE = 0;
    public static final byte SHORT = 1;
    public static final byte INT = 2;
    public static final byte LONG = 3;
    public static final byte DOUBLE = 5;
    public static final byte BOOLEAN = 6;
    public static final byte STRING = 7;
    public static final byte NULL = 8;
    protected String pre;
    protected byte type;

    public Segment(String pre) {
        this.pre = pre;
        this.type = (byte)-1;
    }

    public Segment(String pre, byte type) {
        this.pre = pre;
        this.type = type;
    }

    protected static Segment fromDataInput(DataInput din) throws IOException {
        byte type = din.readByte();
        String pre = null;
        int val = 0;
        int read = din.readUnsignedByte();
        while (read == 255) {
            val += read;
            read = din.readUnsignedByte();
        }
        if ((val += read) > 0) {
            byte[] raw = new byte[val];
            din.readFully(raw);
            pre = new String(raw, StandardCharsets.UTF_8);
        }
        return new Segment(pre, type);
    }

    protected void toDataOutput(DataOutput dout) throws IOException {
        dout.writeByte(this.type);
        if (this.pre == null) {
            dout.writeByte(0);
        } else {
            byte[] encoded = this.pre.getBytes(StandardCharsets.UTF_8);
            int length = encoded.length;
            if (length == 0) {
                System.out.println("found 0");
            }
            while (length > 0) {
                if (length > 255) {
                    dout.writeByte(255);
                    length -= 255;
                    continue;
                }
                dout.writeByte(length);
                length = 0;
            }
            dout.write(encoded);
        }
    }

    public String read(ByteBuffer buf, DictionaryCache dict) {
        StringBuilder out = new StringBuilder();
        if (this.pre != null) {
            out.append(this.pre);
        }
        if (this.type == -1) {
            return out.toString();
        }
        if (this.type == 8) {
            out.append("null");
            return out.toString();
        }
        if (this.type == 0) {
            out.append(buf.get());
            return out.toString();
        }
        if (this.type == 1) {
            out.append(buf.getShort());
            return out.toString();
        }
        if (this.type == 2) {
            out.append(buf.getInt());
            return out.toString();
        }
        if (this.type == 3) {
            out.append(buf.getLong());
            return out.toString();
        }
        if (this.type == 5) {
            out.append(buf.getDouble());
            return out.toString();
        }
        if (this.type == 6) {
            out.append(buf.get() == 0 ? "false" : "true");
            return out.toString();
        }
        if (this.type == 7) {
            short pos = buf.getShort();
            if (pos > -1) {
                out.append("\"");
                out.append(dict.get(pos));
                out.append("\"");
            } else {
                int size = 0;
                int val = buf.get() & 0xFF;
                while (val == 255) {
                    size += val;
                    val = buf.get() & 0xFF;
                }
                byte[] data = new byte[size += val];
                buf.get(data);
                out.append("\"");
                out.append(new String(data, StandardCharsets.UTF_8));
                out.append("\"");
            }
            return out.toString();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment s = (Segment)obj;
        if (s.type != this.type) {
            return false;
        }
        return !(this.pre == null ? s.pre != null : !this.pre.equals(s.pre));
    }
}

