/*
 * Decompiled with CFR 0.152.
 */
package me.doubledutch.lazyjson;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import me.doubledutch.lazyjson.LazyArray;
import me.doubledutch.lazyjson.LazyElement;
import me.doubledutch.lazyjson.LazyException;
import me.doubledutch.lazyjson.LazyNode;
import me.doubledutch.lazyjson.LazyParser;
import me.doubledutch.lazyjson.LazyType;

public class LazyObject
extends LazyElement {
    public static final Object NULL = new Object();

    public LazyObject(String raw) throws LazyException {
        LazyParser parser = new LazyParser(raw);
        parser.tokenize();
        if (parser.root.type != 0) {
            throw new LazyException("JSON Object must start with {", 0);
        }
        this.root = parser.root;
    }

    public LazyObject() throws LazyException {
        LazyParser parser = new LazyParser("{}");
        parser.tokenize();
        this.root = parser.root;
    }

    protected LazyObject(LazyNode root) {
        super(root);
    }

    @Override
    public LazyType getType() {
        return LazyType.OBJECT;
    }

    public LazyType getType(String key) throws LazyException {
        LazyNode token = this.getFieldToken(key);
        switch (token.type) {
            case 0: {
                return LazyType.OBJECT;
            }
            case 1: {
                return LazyType.ARRAY;
            }
            case 4: {
                return LazyType.BOOLEAN;
            }
            case 5: {
                return LazyType.BOOLEAN;
            }
            case 6: {
                return LazyType.NULL;
            }
            case 7: {
                return LazyType.STRING;
            }
            case 8: {
                return LazyType.STRING;
            }
            case 9: {
                return LazyType.INTEGER;
            }
            case 10: {
                return LazyType.FLOAT;
            }
        }
        return null;
    }

    public Object opt(String key) throws LazyException {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token != null) {
            switch (token.type) {
                case 0: {
                    LazyObject obj = new LazyObject(token);
                    obj.parent = this;
                    return obj;
                }
                case 1: {
                    LazyArray arr = new LazyArray(token);
                    arr.parent = this;
                    return arr;
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return false;
                }
                case 6: {
                    return NULL;
                }
                case 7: {
                    return token.getStringValue();
                }
                case 8: {
                    return token.getStringValue();
                }
                case 9: {
                    return token.getLongValue();
                }
                case 10: {
                    return token.getDoubleValue();
                }
            }
        }
        return null;
    }

    public Object get(String key) throws LazyException {
        LazyNode token = this.getFieldToken(key);
        if (token != null) {
            switch (token.type) {
                case 0: {
                    LazyObject obj = new LazyObject(token);
                    obj.parent = this;
                    return obj;
                }
                case 1: {
                    LazyArray arr = new LazyArray(token);
                    arr.parent = this;
                    return arr;
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return false;
                }
                case 6: {
                    return NULL;
                }
                case 7: {
                    return token.getStringValue();
                }
                case 8: {
                    return token.getStringValue();
                }
                case 9: {
                    return token.getLongValue();
                }
                case 10: {
                    return token.getDoubleValue();
                }
            }
        }
        return null;
    }

    public Object remove(String key) throws LazyException {
        Object obj = this.opt(key);
        LazyNode token = this.getOptionalField(key);
        if (token != null) {
            LazyNode pointer = this.root.child;
            if (pointer == token) {
                this.root.child = token.next;
                if (this.root.lastChild == pointer) {
                    this.root.lastChild = null;
                }
            } else {
                while (pointer != null) {
                    if (pointer.next == token) {
                        pointer.next = token.next;
                    }
                    pointer = pointer.next;
                }
            }
            this.root.dirty = true;
        }
        return obj;
    }

    @Override
    protected String serializeElementToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        LazyNode pointer = this.root.child;
        boolean first = true;
        while (pointer != null) {
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append("\"");
            buf.append(pointer.getStringValue());
            buf.append("\":");
            if (pointer.child.type == 0) {
                buf.append(new LazyObject(pointer.child).toString());
            } else if (pointer.child.type == 1) {
                buf.append(new LazyArray(pointer.child).toString());
            } else if (pointer.child.type == 7 || pointer.child.type == 8) {
                buf.append("\"");
                buf.append(pointer.child.getRawStringValue());
                buf.append("\"");
            } else if (pointer.child.type == 4) {
                buf.append("true");
            } else if (pointer.child.type == 5) {
                buf.append("false");
            } else if (pointer.child.type == 6) {
                buf.append("null");
            } else {
                buf.append(pointer.child.getStringValue());
            }
            pointer = pointer.next;
        }
        buf.append("}");
        return buf.toString();
    }

    private void attachField(String key, LazyNode child) throws LazyException {
        StringBuilder dirtyBuf = this.root.getDirtyBuf();
        LazyNode token = this.getOptionalField(key);
        if (token == null) {
            token = LazyNode.cField(dirtyBuf.length());
            token.dirty = true;
            token.dirtyBuf = dirtyBuf;
            dirtyBuf.append(key);
            token.endIndex = dirtyBuf.length();
            if (this.root.child == null) {
                this.root.child = token;
                this.root.lastChild = token;
            } else {
                this.root.lastChild.next = token;
                this.root.lastChild = token;
            }
        }
        token.child = child;
        token.lastChild = child;
    }

    public LazyObject put(String key, String value) throws LazyException {
        if (value == null) {
            this.remove(key);
            return this;
        }
        LazyNode child = null;
        child = LazyObject.shouldQuoteString(value) ? this.appendAndSetDirtyString((byte)8, LazyObject.quoteString(value)) : this.appendAndSetDirtyString((byte)7, value);
        this.attachField(key, child);
        return this;
    }

    public LazyObject put(String key, int value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)9, Integer.toString(value));
        this.attachField(key, child);
        return this;
    }

    public LazyObject put(String key, long value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)9, Long.toString(value));
        this.attachField(key, child);
        return this;
    }

    public LazyObject put(String key, float value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)10, Float.toString(value));
        this.attachField(key, child);
        return this;
    }

    public LazyObject put(String key, double value) throws LazyException {
        LazyNode child = this.appendAndSetDirtyString((byte)10, Double.toString(value));
        this.attachField(key, child);
        return this;
    }

    public LazyObject put(String key, boolean value) throws LazyException {
        LazyNode child = null;
        child = value ? LazyNode.cValueTrue(-1) : LazyNode.cValueFalse(-1);
        child.dirty = true;
        this.attachField(key, child);
        return this;
    }

    public LazyObject put(String key, LazyObject value) throws LazyException {
        this.attachField(key, value.root);
        return this;
    }

    public LazyObject put(String key, LazyArray value) throws LazyException {
        this.attachField(key, value.root);
        return this;
    }

    public LazyObject put(String key, Object value) throws LazyException {
        if (value == NULL) {
            LazyNode child = LazyNode.cValueNull(-1);
            child.dirty = true;
            this.attachField(key, child);
            return this;
        }
        if (value == null) {
            // empty if block
        }
        if (value instanceof Integer) {
            return this.put(key, (Integer)value);
        }
        if (value instanceof Long) {
            return this.put(key, (Long)value);
        }
        if (value instanceof Float) {
            return this.put(key, ((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.put(key, (Double)value);
        }
        if (value instanceof Boolean) {
            return this.put(key, (Boolean)value);
        }
        if (value instanceof String) {
            return this.put(key, (String)value);
        }
        if (value instanceof LazyObject) {
            return this.put(key, (LazyObject)value);
        }
        if (value instanceof LazyArray) {
            return this.put(key, (LazyArray)value);
        }
        throw new LazyException("Unsupported object type");
    }

    public String getString(String key) throws LazyException {
        LazyNode token = this.getFieldToken(key);
        return token.getStringValue();
    }

    public String optString(String key) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return null;
        }
        if (token.type == 6) {
            return null;
        }
        return token.getStringValue();
    }

    public String optString(String key, String defaultValue) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return defaultValue;
        }
        if (token.type == 6) {
            return defaultValue;
        }
        return token.getStringValue();
    }

    public int getInt(String key) throws LazyException {
        LazyNode token = this.getFieldToken(key);
        return token.getIntValue();
    }

    public int optInt(String key) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return 0;
        }
        if (token.type == 6) {
            return 0;
        }
        return token.getIntValue();
    }

    public int optInt(String key, int defaultValue) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return defaultValue;
        }
        if (token.type == 6) {
            return defaultValue;
        }
        return token.getIntValue();
    }

    public long getLong(String key) throws LazyException {
        LazyNode token = this.getFieldToken(key);
        return token.getLongValue();
    }

    public long optLong(String key) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return 0L;
        }
        if (token.type == 6) {
            return 0L;
        }
        return token.getLongValue();
    }

    public long optLong(String key, long defaultValue) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return defaultValue;
        }
        if (token.type == 6) {
            return defaultValue;
        }
        return token.getLongValue();
    }

    public double getDouble(String key) throws LazyException {
        LazyNode token = this.getFieldToken(key);
        return token.getDoubleValue();
    }

    public double optDouble(String key) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return 0.0;
        }
        if (token.type == 6) {
            return 0.0;
        }
        return token.getDoubleValue();
    }

    public double optDouble(String key, double defaultValue) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return defaultValue;
        }
        if (token.type == 6) {
            return defaultValue;
        }
        return token.getDoubleValue();
    }

    public boolean isNull(String key) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return true;
        }
        return token.type == 6;
    }

    public boolean getBoolean(String key) {
        LazyNode token = this.getFieldToken(key);
        if (token.type == 7 || token.type == 8) {
            String str = token.getStringValue().toLowerCase().trim();
            if (str.equals("true")) {
                return true;
            }
            if (str.equals("false")) {
                return false;
            }
            throw new LazyException("Requested value is not a boolean", token);
        }
        if (token.type == 4) {
            return true;
        }
        if (token.type == 5) {
            return false;
        }
        throw new LazyException("Requested value is not a boolean", token);
    }

    public boolean optBoolean(String key) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return false;
        }
        if (token.type == 7 || token.type == 8) {
            String str = token.getStringValue().toLowerCase().trim();
            if (str.equals("true")) {
                return true;
            }
            if (str.equals("false")) {
                return false;
            }
            throw new LazyException("Requested value is not a boolean", token);
        }
        return token.type == 4;
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return defaultValue;
        }
        if (token.type == 6) {
            return defaultValue;
        }
        if (token.type == 7 || token.type == 8) {
            String str = token.getStringValue().toLowerCase().trim();
            if (str.equals("true")) {
                return true;
            }
            if (str.equals("false")) {
                return false;
            }
            throw new LazyException("Requested value is not a boolean", token);
        }
        return token.type == 4;
    }

    public LazyObject getJSONObject(String key) throws LazyException {
        LazyNode token = this.getFieldToken(key);
        if (token.type != 0) {
            throw new LazyException("Requested value is not an object", token);
        }
        LazyObject obj = new LazyObject(token);
        obj.parent = this;
        return obj;
    }

    public LazyObject optJSONObject(String key) throws LazyException {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return null;
        }
        if (token.type == 6) {
            return null;
        }
        if (token.type != 0) {
            return null;
        }
        LazyObject obj = new LazyObject(token);
        obj.parent = this;
        return obj;
    }

    public LazyArray getJSONArray(String key) throws LazyException {
        LazyNode token = this.getFieldToken(key);
        if (token.type != 1) {
            throw new LazyException("Requested value is not an array", token);
        }
        LazyArray arr = new LazyArray(token);
        arr.parent = this;
        return arr;
    }

    public LazyArray optJSONArray(String key) throws LazyException {
        LazyNode token = this.getOptionalFieldToken(key);
        if (token == null) {
            return null;
        }
        if (token.type == 6) {
            return null;
        }
        if (token.type != 1) {
            return null;
        }
        LazyArray arr = new LazyArray(token);
        arr.parent = this;
        return arr;
    }

    public Iterator<String> keys() {
        return this.root.getStringIterator();
    }

    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        Iterator<String> keys = this.keys();
        while (keys.hasNext()) {
            set.add(keys.next());
        }
        return set;
    }

    public static String[] getNames(LazyObject obj) {
        Set<String> keys = obj.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public int hashCode() {
        int code = 1;
        for (String key : this.keySet()) {
            LazyType t1 = this.getType(key);
            switch (t1) {
                case STRING: {
                    code += this.getString(key).hashCode();
                    break;
                }
                case INTEGER: {
                    long l = this.getLong(key);
                    code += (int)(l ^ l >>> 32);
                    break;
                }
                case FLOAT: {
                    double d = this.getDouble(key);
                    long l = Double.doubleToLongBits(d);
                    code += (int)(l ^ l >>> 32);
                    break;
                }
                case BOOLEAN: {
                    if (!this.getBoolean(key)) break;
                    ++code;
                    break;
                }
                case OBJECT: {
                    code += 37 * this.getJSONObject(key).hashCode();
                    break;
                }
                case ARRAY: {
                    code += 37 * this.getJSONArray(key).hashCode();
                }
            }
        }
        return code;
    }

    private boolean keyMatch(String key, LazyNode token) {
        if (token.type == 3) {
            String field = token.getStringValue();
            return field.equals(key);
        }
        int length = key.length();
        if (token.endIndex - token.startIndex != length) {
            return false;
        }
        if (token.dirty) {
            for (int i = 0; i < length; ++i) {
                char c = key.charAt(i);
                if (c == token.dirtyBuf.charAt(token.startIndex + i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                char c = key.charAt(i);
                if (c == token.cbuf[token.startIndex + i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean has(String key) {
        LazyNode child = this.root.child;
        while (child != null) {
            if (this.keyMatch(key, child)) {
                return true;
            }
            child = child.next;
        }
        return false;
    }

    private LazyNode getFieldToken(String key) throws LazyException {
        LazyNode child = this.root.child;
        while (child != null) {
            if (this.keyMatch(key, child)) {
                return child.child;
            }
            child = child.next;
        }
        throw new LazyException("Unknown field '" + key + "'");
    }

    private LazyNode getOptionalFieldToken(String key) {
        LazyNode child = this.root.child;
        while (child != null) {
            if (this.keyMatch(key, child)) {
                return child.child;
            }
            child = child.next;
        }
        return null;
    }

    private LazyNode getOptionalField(String key) {
        LazyNode child = this.root.child;
        while (child != null) {
            if (this.keyMatch(key, child)) {
                return child;
            }
            child = child.next;
        }
        return null;
    }

    public String toString(int pad) {
        return this.root.toString(pad);
    }
}

