/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.srl.extra;

import androidx.annotation.NonNull;
import me.dkzwm.widget.srl.extra.AbsClassicRefreshView;

public class LastUpdateTimeUpdater
implements Runnable {
    private AbsClassicRefreshView mRefreshView;
    private ITimeUpdater mUpdater;
    private boolean mRunning = false;

    LastUpdateTimeUpdater(AbsClassicRefreshView refreshView) {
        this.mRefreshView = refreshView;
        this.mUpdater = refreshView;
    }

    void setTimeUpdater(@NonNull ITimeUpdater updater) {
        this.mUpdater = updater;
    }

    public void start() {
        this.mRunning = true;
        if (this.mRefreshView != null) {
            this.mRefreshView.post(this);
        }
    }

    public void stop() {
        this.mRunning = false;
        if (this.mRefreshView != null) {
            this.mRefreshView.removeCallbacks(this);
        }
    }

    @Override
    public void run() {
        if (this.mUpdater != null && this.mRefreshView != null) {
            if (this.mUpdater.canUpdate()) {
                this.mUpdater.updateTime(this.mRefreshView);
            }
            this.mRefreshView.removeCallbacks(this);
            if (this.mRunning) {
                this.mRefreshView.postDelayed(this, 1000L);
            }
        }
    }

    public static interface ITimeUpdater {
        public boolean canUpdate();

        public void updateTime(AbsClassicRefreshView var1);
    }
}

