/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.content.Context;
import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class SwipeLayout
extends FrameLayout {
    private ViewDragHelper mDragHelper;
    private View mBackView;
    private View mFrontView;
    private int mHeight;
    private int mWidth;
    private int mRange;
    private boolean enableSwipe = true;
    ViewDragHelper.Callback mCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            return true;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            if (child == SwipeLayout.this.mFrontView) {
                if (left > 0) {
                    return 0;
                }
                if (left < -SwipeLayout.this.mRange) {
                    return -SwipeLayout.this.mRange;
                }
            } else if (child == SwipeLayout.this.mBackView) {
                if (left > SwipeLayout.this.mWidth) {
                    return SwipeLayout.this.mWidth;
                }
                if (left < SwipeLayout.this.mWidth - SwipeLayout.this.mRange) {
                    return SwipeLayout.this.mWidth - SwipeLayout.this.mRange;
                }
            }
            return left;
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if (changedView == SwipeLayout.this.mFrontView) {
                SwipeLayout.this.mBackView.offsetLeftAndRight(dx);
            } else if (changedView == SwipeLayout.this.mBackView) {
                SwipeLayout.this.mFrontView.offsetLeftAndRight(dx);
            }
            SwipeLayout.this.invalidate();
            SwipeLayout.this.dispatchSwipeEvent();
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            if (xvel == 0.0f && (float)SwipeLayout.this.mFrontView.getLeft() < (float)(-SwipeLayout.this.mRange) / 2.0f) {
                SwipeLayout.this.open();
            } else if (xvel < 0.0f) {
                SwipeLayout.this.open();
            } else {
                SwipeLayout.this.close();
            }
        }
    };
    float x = 0.0f;
    float y = 0.0f;
    private Status status = Status.Close;
    private OnSwipeLayoutListener swipeLayoutListener;
    public OnClickAction mOnClickAction;

    public SwipeLayout(Context context) {
        this(context, null);
    }

    public SwipeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)this.mCallback);
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean isSmooth) {
        int finalLeft = 0;
        if (isSmooth) {
            if (this.mDragHelper.smoothSlideViewTo(this.mFrontView, finalLeft, 0)) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        } else {
            this.layoutContent(false);
        }
    }

    public void open() {
        this.open(true);
    }

    public void open(boolean isSmooth) {
        int finalLeft = -this.mRange;
        if (isSmooth) {
            if (this.mDragHelper.smoothSlideViewTo(this.mFrontView, finalLeft, 0)) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        } else {
            this.layoutContent(true);
        }
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.layoutContent(false);
    }

    private void layoutContent(boolean isOpen) {
        Rect frontRect = this.computeFrontViewRect(isOpen);
        this.mFrontView.layout(frontRect.left, frontRect.top, frontRect.right, frontRect.bottom);
        Rect backRect = this.computeBackViewRect(frontRect);
        this.mBackView.layout(backRect.left, backRect.top, backRect.right, backRect.bottom);
        this.bringChildToFront(this.mFrontView);
    }

    private Rect computeBackViewRect(Rect frontRect) {
        int left = frontRect.right;
        return new Rect(left, 0, left + this.mRange, 0 + this.mHeight);
    }

    private Rect computeFrontViewRect(boolean isOpen) {
        int left = 0;
        if (isOpen) {
            left = -this.mRange;
        }
        return new Rect(left, 0, left + this.mWidth, 0 + this.mHeight);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mBackView = this.getChildAt(0);
        this.mFrontView = this.getChildAt(1);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mHeight = this.mFrontView.getMeasuredHeight();
        this.mWidth = this.mFrontView.getMeasuredWidth();
        this.mRange = this.mBackView.getMeasuredWidth();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.enableSwipe) {
            return this.mDragHelper.shouldInterceptTouchEvent(ev);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        block5: {
            try {
                if (this.enableSwipe) {
                    this.mDragHelper.processTouchEvent(event);
                    if (event.getAction() == 0) {
                        this.x = event.getX();
                        this.y = event.getY();
                    }
                    if (this.status != Status.Draging && this.status != Status.Open && event.getY() == this.y && event.getX() == this.x && event.getAction() == 1 && this.mOnClickAction != null) {
                        this.mOnClickAction.onClick((View)this);
                    }
                    break block5;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void setEnableSwipe(boolean enableSwipe) {
        this.enableSwipe = enableSwipe;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public OnSwipeLayoutListener getSwipeLayoutListener() {
        return this.swipeLayoutListener;
    }

    public void setSwipeLayoutListener(OnSwipeLayoutListener swipeLayoutListener) {
        this.swipeLayoutListener = swipeLayoutListener;
    }

    protected void dispatchSwipeEvent() {
        if (this.swipeLayoutListener != null) {
            this.swipeLayoutListener.onDraging(this);
        }
        Status preStatus = this.status;
        this.status = this.updateStatus();
        if (preStatus != this.status && this.swipeLayoutListener != null) {
            if (this.status == Status.Close) {
                this.swipeLayoutListener.onClose(this);
            } else if (this.status == Status.Open) {
                this.swipeLayoutListener.onOpen(this);
            } else if (this.status == Status.Draging) {
                if (preStatus == Status.Close) {
                    this.swipeLayoutListener.onStartOpen(this);
                } else if (preStatus == Status.Open) {
                    this.swipeLayoutListener.onStartClose(this);
                }
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.enableSwipe && ev.getAction() == 0) {
            this.mOnClickAction.onClick((View)this);
            return true;
        }
        return super.dispatchTouchEvent(ev);
    }

    public void setOnClickAction(OnClickAction mOnClickAction) {
        this.mOnClickAction = mOnClickAction;
    }

    private Status updateStatus() {
        int left = this.mFrontView.getLeft();
        if (left == 0) {
            return Status.Close;
        }
        if (left == -this.mRange) {
            return Status.Open;
        }
        return Status.Draging;
    }

    public static interface OnClickAction {
        public void onClick(View var1);
    }

    public static interface OnSwipeLayoutListener {
        public void onClose(SwipeLayout var1);

        public void onOpen(SwipeLayout var1);

        public void onDraging(SwipeLayout var1);

        public void onStartClose(SwipeLayout var1);

        public void onStartOpen(SwipeLayout var1);
    }

    public static enum Status {
        Close,
        Open,
        Draging;

    }
}

