/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import me.czmc.library.utils.DisplayUtil;
import me.czmc.library.widget.R;

public class RoundProgressBarWidthCounter
extends ProgressBar {
    private int mRadius = DisplayUtil.dip2px(this.getContext(), 30.0f);
    private int mMaxPaintWidth;
    private int mReachedHeight = DisplayUtil.dip2px(this.getContext(), 5.0f);
    private int mUnReachedHeight = DisplayUtil.dip2px(this.getContext(), 2.0f);
    private float mTextSize = DisplayUtil.sp2px(this.getContext(), 16.0f);
    private int mTextColor = Color.parseColor((String)"#8194AA");
    private int mReachedColor = Color.parseColor((String)"#8194AA");
    private int mUnReachedColor = Color.parseColor((String)"#B2BECB");
    private boolean mTextVisible;
    private Paint mPaint = new Paint();

    public RoundProgressBarWidthCounter(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundProgressBarWidthCounter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public void init(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.RoundProgressBarWithCounter);
        this.mRadius = (int)ta.getDimension(R.styleable.RoundProgressBarWithCounter_roundRadius, (float)this.mRadius);
        ta.recycle();
        ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.HorizontalProgressBarWithCounter);
        this.mReachedColor = ta.getColor(R.styleable.HorizontalProgressBarWithCounter_reachedColor, this.mReachedColor);
        this.mUnReachedColor = ta.getColor(R.styleable.HorizontalProgressBarWithCounter_unReachedColor, this.mUnReachedColor);
        this.mReachedHeight = (int)ta.getDimension(R.styleable.HorizontalProgressBarWithCounter_reachedHeight, (float)this.mReachedHeight);
        this.mUnReachedHeight = (int)ta.getDimension(R.styleable.HorizontalProgressBarWithCounter_unReachedHeight, (float)this.mUnReachedHeight);
        this.mTextColor = ta.getColor(R.styleable.HorizontalProgressBarWithCounter_textColor, this.mTextColor);
        this.mTextSize = ta.getDimension(R.styleable.HorizontalProgressBarWithCounter_textSize, this.mTextSize);
        this.mTextVisible = ta.getBoolean(R.styleable.HorizontalProgressBarWithCounter_textVisible, true);
        ta.recycle();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setTextSize(this.mTextSize);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mMaxPaintWidth = Math.max(this.mReachedHeight, this.mUnReachedHeight);
        int expect = this.mRadius * 2 + this.mMaxPaintWidth + this.getPaddingLeft() + this.getPaddingRight();
        int width = RoundProgressBarWidthCounter.resolveSize((int)expect, (int)widthMeasureSpec);
        int height = RoundProgressBarWidthCounter.resolveSize((int)expect, (int)heightMeasureSpec);
        int realWidth = Math.min(width, height);
        this.mRadius = (realWidth - this.getPaddingLeft() - this.getPaddingRight() - this.mMaxPaintWidth) / 2;
        this.setMeasuredDimension(realWidth, realWidth);
    }

    protected synchronized void onDraw(Canvas canvas) {
        String text = this.getProgress() + "%";
        float textWidth = this.mPaint.measureText(text);
        float textHeight = (this.mPaint.descent() + this.mPaint.ascent()) / 2.0f;
        canvas.save();
        canvas.translate((float)(this.getPaddingLeft() + this.mMaxPaintWidth / 2), (float)(this.getPaddingTop() + this.mMaxPaintWidth / 2));
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mUnReachedColor);
        this.mPaint.setStrokeWidth((float)this.mUnReachedHeight);
        canvas.drawCircle((float)this.mRadius, (float)this.mRadius, (float)this.mRadius, this.mPaint);
        this.mPaint.setColor(this.mReachedColor);
        this.mPaint.setStrokeWidth((float)this.mReachedHeight);
        float sweepAngle = (float)this.getProgress() * 1.0f / (float)this.getMax() * 360.0f;
        canvas.drawArc(new RectF(0.0f, 0.0f, (float)(this.mRadius * 2), (float)(this.mRadius * 2)), 0.0f, sweepAngle, false, this.mPaint);
        if (this.mTextVisible) {
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawText(text, (float)this.mRadius - textWidth / 2.0f, (float)this.mRadius - textHeight, this.mPaint);
        }
        canvas.restore();
    }
}

