/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.util.Iterator;
import java.util.LinkedList;

public class AutoLineLayout
extends ViewGroup {
    private boolean adjustChildWidthWithParent;

    public AutoLineLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AutoLineLayout(Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.measure(widthMeasureSpec, heightMeasureSpec, widthMode, widthSize, heightMode, heightSize);
    }

    private void measure(int widthMeasureSpec, int heightMeasureSpec, int widthMode, int widthSize, int heightMode, int heightSize) {
        int availableWidth = widthSize - this.getPaddingLeft() - this.getPaddingRight();
        int parentViewHeight = 0;
        int rowWidth = 0;
        int rowHeight = 0;
        LinkedList<View> rowViews = new LinkedList<View>();
        boolean widthSizeUnspecified = widthMode == 0;
        for (int position = 0; position < this.getChildCount(); ++position) {
            View childView = this.getChildAt(position);
            if (childView.getVisibility() == 8) continue;
            this.measureChildWithMargins(childView, widthMeasureSpec, 0, heightMeasureSpec, 0);
            LayoutParams lp = (LayoutParams)childView.getLayoutParams();
            int childViewWidth = lp.leftMargin + childView.getMeasuredWidth() + lp.rightMargin;
            int childViewHeight = lp.topMargin + childView.getMeasuredHeight() + lp.bottomMargin;
            if (widthSizeUnspecified) {
                rowWidth += childViewWidth;
                if (childViewHeight <= parentViewHeight) continue;
                parentViewHeight = childViewHeight;
                continue;
            }
            if (rowWidth + childViewWidth > availableWidth) {
                if (this.adjustChildWidthWithParent) {
                    this.adjustChildWidthWithParent(rowViews, availableWidth, widthMeasureSpec, heightMeasureSpec);
                }
                rowViews.clear();
                rowWidth = 0;
                parentViewHeight += rowHeight;
                rowHeight = 0;
            }
            rowViews.add(childView);
            rowWidth += childViewWidth;
            if (childViewHeight <= rowHeight) continue;
            rowHeight = childViewHeight;
        }
        if (!widthSizeUnspecified && !rowViews.isEmpty()) {
            if (this.adjustChildWidthWithParent) {
                this.adjustChildWidthWithParent(rowViews, availableWidth, widthMeasureSpec, heightMeasureSpec);
            }
            rowViews.clear();
            parentViewHeight += rowHeight;
        }
        int finalWidth = 0;
        int finalHeight = 0;
        switch (widthMode) {
            case -2147483648: 
            case 0x40000000: {
                finalWidth = widthSize;
                break;
            }
            case 0: {
                finalWidth = rowWidth + this.getPaddingLeft() + this.getPaddingRight();
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                finalHeight = heightSize;
                break;
            }
            case -2147483648: 
            case 0: {
                finalHeight = parentViewHeight + this.getPaddingTop() + this.getPaddingBottom();
            }
        }
        this.setMeasuredDimension(finalWidth, finalHeight);
    }

    private void adjustChildWidthWithParent(LinkedList<View> views, int parentViewWidth, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        boolean end;
        for (View view : views) {
            if (!(view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            parentViewWidth -= lp.leftMargin + lp.rightMargin;
        }
        int averageWidth = parentViewWidth / views.size();
        int bigTabCount = views.size();
        do {
            Iterator iterator = views.iterator();
            while (iterator.hasNext()) {
                View view = (View)iterator.next();
                if (view.getMeasuredWidth() <= averageWidth) continue;
                parentViewWidth -= view.getMeasuredWidth();
                --bigTabCount;
                iterator.remove();
            }
            averageWidth = parentViewWidth / bigTabCount;
            end = true;
            for (View view : views) {
                if (view.getMeasuredWidth() <= averageWidth) continue;
                end = false;
            }
        } while (!end);
        for (View view : views) {
            if (view.getMeasuredWidth() >= averageWidth) continue;
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            layoutParams.width = averageWidth;
            view.setLayoutParams(layoutParams);
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                this.measureChildWithMargins(view, parentWidthMeasureSpec, 0, parentHeightMeasureSpec, 0);
                continue;
            }
            this.measureChild(view, parentWidthMeasureSpec, parentHeightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int viewWidth = r - l;
        int leftOffset = this.getPaddingLeft();
        int topOffset = this.getPaddingTop();
        int rowMaxHeight = 0;
        int count = this.getChildCount();
        for (int w = 0; w < count; ++w) {
            View childView = this.getChildAt(w);
            LayoutParams lp = (LayoutParams)childView.getLayoutParams();
            int occupyWidth = lp.leftMargin + childView.getMeasuredWidth() + lp.rightMargin;
            if (leftOffset + occupyWidth + this.getPaddingRight() > viewWidth) {
                leftOffset = this.getPaddingLeft();
                topOffset += rowMaxHeight;
                rowMaxHeight = 0;
            }
            int left = leftOffset + lp.leftMargin;
            int top = topOffset + lp.topMargin;
            int right = leftOffset + lp.leftMargin + childView.getMeasuredWidth();
            int bottom = topOffset + lp.topMargin + childView.getMeasuredHeight();
            childView.layout(left, top, right, bottom);
            leftOffset += occupyWidth;
            int occupyHeight = lp.topMargin + childView.getMeasuredHeight() + lp.bottomMargin;
            if (occupyHeight <= rowMaxHeight) continue;
            rowMaxHeight = occupyHeight;
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public void setAdjustChildWidthWithParent(boolean adjustChildWidthWithParent) {
        this.adjustChildWidthWithParent = adjustChildWidthWithParent;
        this.requestLayout();
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
        }
    }
}

