/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.adapter.custom;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.List;
import me.czmc.library.adapter.custom.ViewHolder;

public abstract class CommonAdapter<T>
extends BaseAdapter {
    protected Context mContext;
    protected List<T> mDatas;
    protected LayoutInflater mInflater;
    protected int mlayoutId;

    public CommonAdapter(Context context, List<T> datas, int layoutId) {
        this.mContext = context;
        this.mDatas = datas;
        this.mlayoutId = layoutId;
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public CommonAdapter(Context context, int layoutId) {
        this.mContext = context;
        this.mDatas = new ArrayList<T>();
        this.mlayoutId = layoutId;
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public int getCount() {
        return this.mDatas.size();
    }

    public T getItem(int position) {
        return this.mDatas.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = ViewHolder.get(this.mContext, convertView, parent, this.mlayoutId, position);
        this.convert(holder, this.getItem(position), position);
        return holder.getConvertView();
    }

    public abstract void convert(ViewHolder var1, T var2, int var3);

    public void setData(List<T> list) {
        if (list != null && list.size() > 0) {
            this.mDatas.clear();
            this.mDatas.addAll(list);
            this.notifyDataSetChanged();
        }
    }

    public void clearAll() {
        if (this.mDatas != null) {
            this.mDatas.clear();
        }
    }
}

