/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Build;
import android.support.annotation.IntRange;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import me.czmc.library.utils.DisplayUtil;
import me.czmc.library.widget.R;

public class HorizontalSelector
extends HorizontalScrollView
implements View.OnClickListener {
    public final String TAG = "HorizontalWheelView";
    private LinearLayout views;
    private int initialX = 0;
    private float textSize = 15.0f;
    private int itemWidth;
    private int displayItemCount = 5;
    private ArrayList<String> items = new ArrayList();
    private int offset = 4;
    private int selectedIndex = 0;
    private int mScreenWidth;
    private int textColorFocus = Color.parseColor((String)"#ff0000");
    private int textColorNormal = Color.parseColor((String)"#000000");
    private float previousX;
    private boolean isUserScroll = false;
    private Runnable scrollerTask = new ScrollerTask();
    private OnSelectedCallBack callback;
    private Paint mIndicatorPaint;
    private int mIndicatorWidth = 50;

    public HorizontalSelector(Context context) {
        super(context);
        this.init(null);
    }

    public HorizontalSelector(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public HorizontalSelector(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray ta = this.getResources().obtainAttributes(attrs, R.styleable.HorizomtalSelector);
        this.textColorFocus = ta.getColor(R.styleable.HorizomtalSelector_textColorFocus, this.textColorFocus);
        this.textColorNormal = ta.getColor(R.styleable.HorizomtalSelector_textColorNormal, this.textColorNormal);
        this.textSize = DisplayUtil.px2sp(this.getContext(), ta.getDimension(R.styleable.HorizomtalSelector_itemTextSize, this.textSize));
        this.displayItemCount = ta.getInt(R.styleable.HorizomtalSelector_displayItemCount, this.displayItemCount);
        this.mIndicatorWidth = (int)ta.getDimension(R.styleable.HorizomtalSelector_indicatorSize, (float)this.mIndicatorWidth);
        ta.recycle();
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        this.mScreenWidth = wm.getDefaultDisplay().getWidth();
        this.setFadingEdgeLength(0);
        if (Build.VERSION.SDK_INT >= 9) {
            this.setOverScrollMode(2);
        }
        this.setHorizontalScrollBarEnabled(false);
        this.views = new LinearLayout(this.getContext());
        this.views.setOrientation(0);
        this.addView((View)this.views);
        this.mIndicatorPaint = new Paint();
        this.mIndicatorPaint.setColor(this.textColorFocus);
        this.mIndicatorPaint.setStrokeWidth(10.0f);
    }

    private void _setItems(List<String> list) {
        int i;
        this.items.clear();
        this.items.addAll(list);
        for (i = 0; i < this.offset; ++i) {
            this.items.add("");
        }
        for (i = 0; i < this.displayItemCount - this.offset - 1; ++i) {
            this.items.add(0, "");
        }
        this.initData();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        int x = (this.displayItemCount - this.offset - 1) * this.itemWidth + this.itemWidth / 2 + this.getScrollX();
        canvas.drawLine((float)(x - this.mIndicatorWidth / 2), (float)this.getMeasuredHeight(), (float)(x + this.mIndicatorWidth / 2), (float)this.getMeasuredHeight(), this.mIndicatorPaint);
        canvas.restore();
    }

    public void setItems(List<String> list, int index) {
        this._setItems(list);
        this.setSelectedIndex(index);
    }

    private void initData() {
        this.views.removeAllViews();
        int i = 0;
        for (String item : this.items) {
            this.views.addView((View)this.createView(item, i));
            ++i;
        }
        this.refreshItemView(this.itemWidth * this.selectedIndex);
    }

    private TextView createView(String item, int position) {
        TextView tv = new TextView(this.getContext());
        tv.setSingleLine(true);
        tv.setEllipsize(TextUtils.TruncateAt.END);
        tv.setText((CharSequence)item);
        tv.setId(position);
        tv.setClickable(true);
        tv.setTextSize(this.textSize);
        tv.setGravity(17);
        tv.setOnClickListener((View.OnClickListener)this);
        int padding = DisplayUtil.dip2px(this.getContext(), 6.0f);
        tv.setPadding(padding, padding, padding, padding);
        this.itemWidth = this.mScreenWidth / this.displayItemCount;
        this.views.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.itemWidth * this.displayItemCount, -2));
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.getLayoutParams();
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.itemWidth * this.displayItemCount, lp.height));
        tv.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.itemWidth, -2));
        return tv;
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.refreshItemView(l);
    }

    private void refreshItemView(int x) {
        int position = x / this.itemWidth;
        int remainder = x % this.itemWidth;
        int divided = x / this.itemWidth;
        if (remainder == 0) {
            position = divided + this.displayItemCount - this.offset - 1;
        } else if (remainder > this.itemWidth / 2) {
            position = divided + this.displayItemCount - this.offset;
        }
        int childSize = this.views.getChildCount();
        for (int i = 0; i < childSize; ++i) {
            TextView itemView = (TextView)this.views.getChildAt(i);
            if (null == itemView) {
                return;
            }
            if (position == i) {
                itemView.setTextColor(this.textColorFocus);
                continue;
            }
            itemView.setTextColor(this.textColorNormal);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.previousX = ev.getX();
                break;
            }
            case 1: {
                Log.i((String)"HorizontalWheelView", (String)String.format("items=%s, offset=%s", this.items.size(), this.offset));
                Log.i((String)"HorizontalWheelView", (String)("selectedIndex=" + this.selectedIndex));
                float delta = ev.getX() - this.previousX;
                Log.i((String)"HorizontalWheelView", (String)("delta=" + delta));
                if (this.selectedIndex == this.displayItemCount - this.offset - 1 && delta < 0.0f) {
                    this.setSelectedIndex(this.items.size() - 1);
                    break;
                }
                if (this.selectedIndex == this.items.size() - 1 && delta > 0.0f) {
                    this.setSelectedIndex(0);
                    break;
                }
                this.isUserScroll = true;
                this.startScrollerTask();
            }
        }
        return super.onTouchEvent(ev);
    }

    private void startScrollerTask() {
        this.initialX = this.getScrollX();
        this.postDelayed(this.scrollerTask, 30L);
    }

    private void setSelectedIndex(final @IntRange(from=0L) int index) {
        this.isUserScroll = false;
        this.post(new Runnable(){

            @Override
            public void run() {
                HorizontalSelector.this.smoothScrollTo(index * HorizontalSelector.this.itemWidth, 0);
                HorizontalSelector.this.selectedIndex = index;
                HorizontalSelector.this.callBack();
            }
        });
    }

    public void onClick(View v) {
        this.setSelectedIndex(v.getId());
    }

    public void callBack() {
        if (null != this.callback) {
            this.callback.onSelected(this.isUserScroll, this.displayItemCount - this.offset - 1 + this.selectedIndex, this.items.get(this.displayItemCount - this.offset - 1 + this.selectedIndex));
        }
    }

    public void setOnSelectedCallBack(OnSelectedCallBack callback) {
        this.callback = callback;
    }

    public static interface OnSelectedCallBack {
        public void onSelected(boolean var1, int var2, String var3);
    }

    private class ScrollerTask
    implements Runnable {
        private ScrollerTask() {
        }

        @Override
        public void run() {
            if (HorizontalSelector.this.itemWidth == 0) {
                Log.i((String)"HorizontalWheelView", (String)"itemHeight is zero");
                return;
            }
            int newX = HorizontalSelector.this.getScrollX();
            if (HorizontalSelector.this.initialX - newX == 0) {
                final int remainder = HorizontalSelector.this.initialX % HorizontalSelector.this.itemWidth;
                final int divided = HorizontalSelector.this.initialX / HorizontalSelector.this.itemWidth;
                Log.i((String)"HorizontalWheelView", (String)("initialX: " + HorizontalSelector.this.initialX + ", remainder: " + remainder + ", divided: " + divided));
                if (remainder == 0) {
                    HorizontalSelector.this.selectedIndex = divided + HorizontalSelector.this.displayItemCount - HorizontalSelector.this.offset - 1;
                    HorizontalSelector.this.callBack();
                } else if (remainder > HorizontalSelector.this.itemWidth / 2) {
                    HorizontalSelector.this.post(new Runnable(){

                        @Override
                        public void run() {
                            HorizontalSelector.this.smoothScrollTo(HorizontalSelector.this.initialX - remainder + HorizontalSelector.this.itemWidth, 0);
                            HorizontalSelector.this.selectedIndex = divided + 1;
                            HorizontalSelector.this.callBack();
                        }
                    });
                } else {
                    HorizontalSelector.this.post(new Runnable(){

                        @Override
                        public void run() {
                            HorizontalSelector.this.smoothScrollTo(HorizontalSelector.this.initialX - remainder, 0);
                            HorizontalSelector.this.selectedIndex = divided;
                            HorizontalSelector.this.callBack();
                        }
                    });
                }
            } else {
                HorizontalSelector.this.startScrollerTask();
            }
        }
    }
}

