/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ProgressBar;
import me.czmc.library.utils.DisplayUtil;
import me.czmc.library.widget.R;

public class HorizontalProgressBarWithCounter
extends ProgressBar {
    public final String TAG = "HProgressBar";
    private int mRealWidth;
    private Paint mPaint;
    private int mReachedHeight = DisplayUtil.dip2px(this.getContext(), 5.0f);
    private int mUnReachedHeight = DisplayUtil.dip2px(this.getContext(), 2.0f);
    private float mTextSize = DisplayUtil.sp2px(this.getContext(), 16.0f);
    private int mTextColor = Color.parseColor((String)"#8194AA");
    private int mTextOffset = 5;
    private int mReachedColor = Color.parseColor((String)"#8194AA");
    private int mUnReachedColor = Color.parseColor((String)"#B2BECB");
    private boolean mTextVisible;

    public HorizontalProgressBarWithCounter(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HorizontalProgressBarWithCounter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public void init(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.HorizontalProgressBarWithCounter);
        this.mReachedColor = ta.getColor(R.styleable.HorizontalProgressBarWithCounter_reachedColor, this.mReachedColor);
        this.mUnReachedColor = ta.getColor(R.styleable.HorizontalProgressBarWithCounter_unReachedColor, this.mUnReachedColor);
        this.mReachedHeight = (int)ta.getDimension(R.styleable.HorizontalProgressBarWithCounter_reachedHeight, (float)this.mReachedHeight);
        this.mUnReachedHeight = (int)ta.getDimension(R.styleable.HorizontalProgressBarWithCounter_unReachedHeight, (float)this.mUnReachedHeight);
        this.mTextColor = ta.getColor(R.styleable.HorizontalProgressBarWithCounter_textColor, this.mTextColor);
        this.mTextSize = (int)ta.getDimension(R.styleable.HorizontalProgressBarWithCounter_textSize, this.mTextSize);
        this.mTextOffset = (int)ta.getDimension(R.styleable.HorizontalProgressBarWithCounter_textOffset, 5.0f);
        this.mTextVisible = ta.getBoolean(R.styleable.HorizontalProgressBarWithCounter_textVisible, true);
        ta.recycle();
        this.mPaint = new Paint();
        this.mPaint.setTextSize(this.mTextSize);
        this.mPaint.setColor(this.mTextColor);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = this.measureHeight(heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        this.mRealWidth = this.getMeasuredWidth() - this.getPaddingRight() - this.getPaddingLeft();
    }

    private int measureHeight(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            float textHeight = this.mPaint.descent() - this.mPaint.ascent();
            result = (int)((float)(this.getPaddingTop() + this.getPaddingBottom()) + Math.max((float)Math.max(this.mReachedHeight, this.mUnReachedHeight), Math.abs(textHeight)));
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    protected synchronized void onDraw(Canvas canvas) {
        float endX;
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)(this.getHeight() / 2));
        boolean isFinish = false;
        float radio = (float)this.getProgress() * 1.0f / (float)this.getMax();
        float progressPosX = radio * (float)this.mRealWidth;
        String progressStr = this.getProgress() + "%";
        float textWidth = 0.0f;
        float textHeight = 0.0f;
        if (this.mTextVisible) {
            textWidth = this.mPaint.measureText(progressStr);
            textHeight = (this.mPaint.descent() + this.mPaint.ascent()) / 2.0f;
        } else {
            this.mTextOffset = 0;
        }
        if (progressPosX + textWidth > (float)this.mRealWidth) {
            progressPosX = this.mRealWidth - (int)textWidth;
            isFinish = true;
        }
        if ((endX = progressPosX - (float)(this.mTextOffset / 2)) > 0.0f) {
            this.mPaint.setColor(this.mReachedColor);
            this.mPaint.setStrokeWidth((float)this.mReachedHeight);
            canvas.drawLine(0.0f, 0.0f, endX, 0.0f, this.mPaint);
        }
        if (this.mTextVisible) {
            this.mPaint.setColor(this.mTextColor);
            this.mPaint.setAntiAlias(true);
            canvas.drawText(progressStr, progressPosX, -textHeight, this.mPaint);
        }
        if (!isFinish) {
            float start = progressPosX + (float)(this.mTextOffset / 2) + textWidth;
            this.mPaint.setColor(this.mUnReachedColor);
            this.mPaint.setStrokeWidth((float)this.mUnReachedHeight);
            canvas.drawLine(start, 0.0f, (float)this.mRealWidth, 0.0f, this.mPaint);
            canvas.restore();
        }
    }
}

