/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.content.Context;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import java.lang.reflect.Field;

public class FloattingButton
extends ImageView
implements View.OnLongClickListener {
    private WindowManager mWindowManager;
    private float x;
    private float y;
    private float mTouchStartX;
    private float mTouchStartY;
    private int statusHeight = 0;
    private WindowManager.LayoutParams mLayout;

    public FloattingButton(Context context) {
        super(context);
        this.init(0, 0);
    }

    public FloattingButton(Context context, int x, int y) {
        super(context);
        this.init(x, y);
    }

    private void init(int x, int y) {
        this.setClickable(true);
        this.setOnLongClickListener(this);
        this.mWindowManager = (WindowManager)this.getContext().getSystemService("window");
        this.mLayout = new WindowManager.LayoutParams();
        this.mLayout.type = 2;
        this.mLayout.flags = 8;
        this.mLayout.format = 1;
        this.mLayout.gravity = 51;
        this.mLayout.x = x;
        this.x = this.mLayout.x;
        this.mLayout.y = y;
        this.y = this.mLayout.y;
        this.mLayout.width = -2;
        this.mLayout.height = -2;
        this.mWindowManager.addView((View)this, (ViewGroup.LayoutParams)this.mLayout);
        this.getStatusHeight();
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.x = event.getRawX();
        this.y = event.getRawY() - (float)this.statusHeight;
        Log.i((String)"startP", (String)("startX:" + this.mTouchStartX + "====startY:" + this.mTouchStartY));
        switch (event.getAction()) {
            case 0: {
                this.mTouchStartX = event.getX();
                this.mTouchStartY = event.getY();
                Log.i((String)"startP", (String)("startX:" + this.mTouchStartX + "====startY:" + this.mTouchStartY));
                break;
            }
            case 2: {
                this.mLayout.x = (int)(this.x - this.mTouchStartX);
                this.mLayout.y = (int)(this.y - this.mTouchStartY);
                this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mLayout);
                break;
            }
            case 1: {
                this.mLayout.x = (int)(this.x - this.mTouchStartX);
                this.mLayout.y = (int)(this.y - this.mTouchStartY);
                this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mLayout);
                this.mTouchStartY = 0.0f;
                this.mTouchStartX = 0.0f;
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public void onDestroy() {
        this.mWindowManager.removeViewImmediate((View)this);
    }

    public void getStatusHeight() {
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object obj = c.newInstance();
            Field field = c.getField("status_bar_height");
            this.statusHeight = this.getResources().getDimensionPixelSize(Integer.parseInt(field.get(obj).toString()));
            Log.i((String)"FloattingButton", (String)("statusHeight:" + this.statusHeight));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public boolean onLongClick(View v) {
        return true;
    }
}

