/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import me.czmc.library.adapter.recyclerview.ViewHolder;

public abstract class CommonAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    private int mLayoutId;
    protected Context mContext;
    protected List<T> mDatas = new ArrayList<T>();
    private OnItemClickListener mOnItemClickListener;

    public CommonAdapter(Context context, List<T> datas, int layout) {
        this.mContext = context;
        this.mDatas = datas;
        this.mLayoutId = layout;
    }

    public CommonAdapter(Context context, int layoutId) {
        this.mContext = context;
        this.mLayoutId = layoutId;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewHolder holder = ViewHolder.createViewHolder(this.mContext, parent, this.mLayoutId);
        this.setListener(parent, holder, viewType);
        return holder;
    }

    public abstract void convert(ViewHolder var1, T var2, int var3);

    protected boolean isEnabled(int viewType) {
        return true;
    }

    protected void setListener(ViewGroup parent, final ViewHolder viewHolder, int viewType) {
        if (!this.isEnabled(viewType)) {
            return;
        }
        viewHolder.getConvertView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CommonAdapter.this.mOnItemClickListener != null) {
                    int position = viewHolder.getAdapterPosition();
                    CommonAdapter.this.mOnItemClickListener.onItemClick(v, viewHolder, CommonAdapter.this.mDatas.get(position), position);
                }
            }
        });
        viewHolder.getConvertView().setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (CommonAdapter.this.mOnItemClickListener != null) {
                    int position = viewHolder.getAdapterPosition();
                    return CommonAdapter.this.mOnItemClickListener.onItemLongClick(v, viewHolder, CommonAdapter.this.mDatas.get(position), position);
                }
                return false;
            }
        });
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        this.convert(holder, this.mDatas.get(position), position);
    }

    public int getItemCount() {
        int itemCount = this.mDatas.size();
        return itemCount;
    }

    public List<T> getDatas() {
        return this.mDatas;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setData(List<T> list) {
        if (list != null && list.size() > 0) {
            this.mDatas.clear();
            this.mDatas.addAll(list);
            this.notifyDataSetChanged();
        }
    }

    public void clearAll() {
        if (this.mDatas != null) {
            this.mDatas.clear();
        }
    }

    public static interface OnItemClickListener<T> {
        public void onItemClick(View var1, RecyclerView.ViewHolder var2, T var3, int var4);

        public boolean onItemLongClick(View var1, RecyclerView.ViewHolder var2, T var3, int var4);
    }
}

