/*
 * Decompiled with CFR 0.152.
 */
package me.czmc.library.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;

public class SwitchView
extends View {
    private final Paint paint = new Paint();
    private final Path sPath = new Path();
    private final Path bPath = new Path();
    private final RectF bRectF = new RectF();
    private float sAnim;
    private float bAnim;
    private RadialGradient shadowGradient;
    private final AccelerateInterpolator aInterpolator = new AccelerateInterpolator(2.0f);
    public static final int STATE_SWITCH_ON = 4;
    public static final int STATE_SWITCH_ON2 = 3;
    public static final int STATE_SWITCH_OFF2 = 2;
    public static final int STATE_SWITCH_OFF = 1;
    private int state;
    private int lastState = this.state = 1;
    private boolean isOpened = false;
    private int mWidth;
    private int mHeight;
    private float sWidth;
    private float sHeight;
    private float sLeft;
    private float sTop;
    private float sRight;
    private float sBottom;
    private float sCenterX;
    private float sCenterY;
    private float sScale;
    private float bOffset;
    private float bRadius;
    private float bStrokeWidth;
    private float bWidth;
    private float bLeft;
    private float bTop;
    private float bRight;
    private float bBottom;
    private float bOnLeftX;
    private float bOn2LeftX;
    private float bOff2LeftX;
    private float bOffLeftX;
    private float shadowHeight;
    private OnStateChangedListener listener = new OnStateChangedListener(){

        @Override
        public void toggleToOn(View view) {
            SwitchView.this.toggleSwitch(4);
        }

        @Override
        public void toggleToOff(View view) {
            SwitchView.this.toggleSwitch(1);
        }
    };

    public SwitchView(Context context) {
        this(context, null);
    }

    @TargetApi(value=11)
    public SwitchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayerType(1, null);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = (int)((float)widthSize * 0.65f);
        this.setMeasuredDimension(widthSize, heightSize);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.sTop = 0.0f;
        this.sLeft = 0.0f;
        this.sRight = this.mWidth;
        this.sBottom = (float)this.mHeight * 0.91f;
        this.sWidth = this.sRight - this.sLeft;
        this.sHeight = this.sBottom - this.sTop;
        this.sCenterX = (this.sRight + this.sLeft) / 2.0f;
        this.sCenterY = (this.sBottom + this.sTop) / 2.0f;
        this.shadowHeight = (float)this.mHeight - this.sBottom;
        this.bTop = 0.0f;
        this.bLeft = 0.0f;
        this.bRight = this.bBottom = this.sBottom;
        this.bWidth = this.bRight - this.bLeft;
        float halfHeightOfS = (this.sBottom - this.sTop) / 2.0f;
        this.bRadius = halfHeightOfS * 0.95f;
        this.bOffset = this.bRadius * 0.2f;
        this.bStrokeWidth = (halfHeightOfS - this.bRadius) * 2.0f;
        this.bOnLeftX = this.sWidth - this.bWidth;
        this.bOn2LeftX = this.bOnLeftX - this.bOffset;
        this.bOffLeftX = 0.0f;
        this.bOff2LeftX = 0.0f;
        this.sScale = 1.0f - this.bStrokeWidth / this.sHeight;
        RectF sRectF = new RectF(this.sLeft, this.sTop, this.sBottom, this.sBottom);
        this.sPath.arcTo(sRectF, 90.0f, 180.0f);
        sRectF.left = this.sRight - this.sBottom;
        sRectF.right = this.sRight;
        this.sPath.arcTo(sRectF, 270.0f, 180.0f);
        this.sPath.close();
        this.bRectF.left = this.bLeft;
        this.bRectF.right = this.bRight;
        this.bRectF.top = this.bTop + this.bStrokeWidth / 2.0f;
        this.bRectF.bottom = this.bBottom - this.bStrokeWidth / 2.0f;
        this.shadowGradient = new RadialGradient(this.bWidth / 2.0f, this.bWidth / 2.0f, this.bWidth / 2.0f, -16777216, 0, Shader.TileMode.CLAMP);
    }

    private void calcBPath(float percent) {
        this.bPath.reset();
        this.bRectF.left = this.bLeft + this.bStrokeWidth / 2.0f;
        this.bRectF.right = this.bRight - this.bStrokeWidth / 2.0f;
        this.bPath.arcTo(this.bRectF, 90.0f, 180.0f);
        this.bRectF.left = this.bLeft + percent * this.bOffset + this.bStrokeWidth / 2.0f;
        this.bRectF.right = this.bRight + percent * this.bOffset - this.bStrokeWidth / 2.0f;
        this.bPath.arcTo(this.bRectF, 270.0f, 180.0f);
        this.bPath.close();
    }

    private float calcBTranslate(float percent) {
        float result = 0.0f;
        int wich = this.state - this.lastState;
        switch (wich) {
            case 1: {
                if (this.state == 2) {
                    result = this.bOff2LeftX - (this.bOff2LeftX - this.bOffLeftX) * percent;
                    break;
                }
                if (this.state != 4) break;
                result = this.bOnLeftX - (this.bOnLeftX - this.bOn2LeftX) * percent;
                break;
            }
            case 2: {
                if (this.state == 4) {
                    result = this.bOnLeftX - (this.bOnLeftX - this.bOff2LeftX) * percent;
                    break;
                }
                if (this.state != 4) break;
                result = this.bOn2LeftX - (this.bOn2LeftX - this.bOffLeftX) * percent;
                break;
            }
            case 3: {
                result = this.bOnLeftX - (this.bOnLeftX - this.bOffLeftX) * percent;
                break;
            }
            case -1: {
                if (this.state == 3) {
                    result = this.bOn2LeftX + (this.bOnLeftX - this.bOn2LeftX) * percent;
                    break;
                }
                if (this.state != 1) break;
                result = this.bOffLeftX + (this.bOff2LeftX - this.bOffLeftX) * percent;
                break;
            }
            case -2: {
                if (this.state == 1) {
                    result = this.bOffLeftX + (this.bOn2LeftX - this.bOffLeftX) * percent;
                    break;
                }
                if (this.state != 2) break;
                result = this.bOff2LeftX + (this.bOnLeftX - this.bOff2LeftX) * percent;
                break;
            }
            case -3: {
                result = this.bOffLeftX + (this.bOnLeftX - this.bOffLeftX) * percent;
            }
        }
        return result - this.bOffLeftX;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.paint.setAntiAlias(true);
        boolean isOn = this.state == 4 || this.state == 3;
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(isOn ? Color.parseColor((String)"#FB334F") : -1842205);
        canvas.drawPath(this.sPath, this.paint);
        this.sAnim = this.sAnim - 0.1f > 0.0f ? this.sAnim - 0.1f : 0.0f;
        this.bAnim = this.bAnim - 0.1f > 0.0f ? this.bAnim - 0.1f : 0.0f;
        float dsAnim = this.aInterpolator.getInterpolation(this.sAnim);
        float dbAnim = this.aInterpolator.getInterpolation(this.bAnim);
        float scale = this.sScale * (isOn ? dsAnim : 1.0f - dsAnim);
        float scaleOffset = (this.bOnLeftX + this.bRadius - this.sCenterX) * (isOn ? 1.0f - dsAnim : dsAnim);
        canvas.save();
        canvas.scale(scale, scale, this.sCenterX + scaleOffset, this.sCenterY);
        this.paint.setColor(-1);
        canvas.drawPath(this.sPath, this.paint);
        canvas.restore();
        canvas.save();
        canvas.translate(this.calcBTranslate(dbAnim), this.shadowHeight);
        boolean isState2 = this.state == 3 || this.state == 2;
        this.calcBPath(isState2 ? 1.0f - dbAnim : dbAnim);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(-13421773);
        this.paint.setShader((Shader)this.shadowGradient);
        canvas.drawPath(this.bPath, this.paint);
        this.paint.setShader(null);
        canvas.translate(0.0f, -this.shadowHeight);
        canvas.scale(0.98f, 0.98f, this.bWidth / 2.0f, this.bWidth / 2.0f);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(-1);
        canvas.drawPath(this.bPath, this.paint);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.bStrokeWidth * 0.5f);
        this.paint.setColor(isOn ? Color.parseColor((String)"#FB334F") : -4210753);
        canvas.drawPath(this.bPath, this.paint);
        canvas.restore();
        this.paint.reset();
        if (this.sAnim > 0.0f || this.bAnim > 0.0f) {
            this.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if ((this.state == 4 || this.state == 1) && this.sAnim * this.bAnim == 0.0f) {
            switch (event.getAction()) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.lastState = this.state;
                    if (this.state == 1) {
                        this.refreshState(2);
                    } else if (this.state == 4) {
                        this.refreshState(3);
                    }
                    this.bAnim = 1.0f;
                    this.invalidate();
                    if (this.state == 2) {
                        this.listener.toggleToOn(this);
                        break;
                    }
                    if (this.state != 3) break;
                    this.listener.toggleToOff(this);
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private void refreshState(int newState) {
        if (!this.isOpened && newState == 4) {
            this.isOpened = true;
        } else if (this.isOpened && newState == 1) {
            this.isOpened = false;
        }
        this.lastState = this.state;
        this.state = newState;
        this.postInvalidate();
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public void setOpened(boolean isOpened) {
        this.refreshState(isOpened ? 4 : 1);
    }

    public void toggleSwitch(final boolean isOpened) {
        this.isOpened = isOpened;
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                SwitchView.this.toggleSwitch(isOpened ? 4 : 1);
            }
        }, 300L);
    }

    private synchronized void toggleSwitch(int wich) {
        if (wich == 4 || wich == 1) {
            if (wich == 4 && (this.lastState == 1 || this.lastState == 2) || wich == 1 && (this.lastState == 4 || this.lastState == 3)) {
                this.sAnim = 1.0f;
            }
            this.bAnim = 1.0f;
            this.refreshState(wich);
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("empty listener");
        }
        this.listener = listener;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.isOpened = this.isOpened;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.isOpened = ss.isOpened;
        this.state = this.isOpened ? 4 : 1;
    }

    static final class SavedState
    extends View.BaseSavedState {
        private boolean isOpened;

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.isOpened = 1 == in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.isOpened ? 1 : 0);
        }
    }

    public static interface OnStateChangedListener {
        public void toggleToOn(View var1);

        public void toggleToOff(View var1);
    }
}

