/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.mrjar;

import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;

public abstract class MultiReleaseExtension {
    private final JavaPluginExtension javaPluginExtension;
    private final TaskContainer tasks;
    private final SourceSetContainer sourceSets;
    private final DependencyHandler dependencies;
    private final ObjectFactory objects;
    private final ConfigurationContainer configurations;
    private final JavaToolchainService javaToolchains;
    private final PluginManager pluginManager;
    private final ExtensionContainer extensions;

    @Inject
    public MultiReleaseExtension(JavaPluginExtension javaPluginExtension, SourceSetContainer sourceSets, ConfigurationContainer configurations, JavaToolchainService javaToolchains, TaskContainer tasks, DependencyHandler dependencies, ObjectFactory objectFactory, PluginManager pluginManager, ExtensionContainer extensions) {
        this.javaPluginExtension = javaPluginExtension;
        this.sourceSets = sourceSets;
        this.configurations = configurations;
        this.javaToolchains = javaToolchains;
        this.tasks = tasks;
        this.dependencies = dependencies;
        this.objects = objectFactory;
        this.pluginManager = pluginManager;
        this.extensions = extensions;
    }

    public void targetVersions(String mainSourceDirectory, String testSourceDirectory, int defaultVersion, int ... versions) {
        this.defaultLanguageVersion(defaultVersion);
        for (int version : versions) {
            this.addLanguageVersion(version, mainSourceDirectory, testSourceDirectory);
        }
    }

    public void targetVersions(int defaultVersion, int ... versions) {
        this.targetVersions("src/main/", "src/test/", defaultVersion, versions);
    }

    public void targetVersions(String sourceDirectory, int defaultVersion, int ... versions) {
        this.targetVersions(sourceDirectory + "main/", sourceDirectory + "test/", defaultVersion, versions);
    }

    private void addLanguageVersion(int version, String mainSourceDirectory, String testSourceDirectory) {
        String javaX = "java" + version;
        SourceSet langSourceSet = (SourceSet)this.sourceSets.create(javaX, srcSet -> srcSet.getJava().srcDir((Object)(mainSourceDirectory + javaX)));
        SourceSet testSourceSet = (SourceSet)this.sourceSets.create(javaX + "Test", srcSet -> srcSet.getJava().srcDir((Object)(testSourceDirectory + javaX)));
        SourceSet sharedSourceSet = (SourceSet)this.sourceSets.findByName("main");
        SourceSet sharedTestSourceSet = (SourceSet)this.sourceSets.findByName("test");
        ConfigurableFileCollection mainClasses = this.objects.fileCollection().from(new Object[]{((SourceSet)this.sourceSets.getByName("main")).getOutput().getClassesDirs()});
        this.dependencies.add(javaX + "Implementation", (Object)mainClasses);
        Provider targetCompiler = this.javaToolchains.compilerFor(spec -> spec.getLanguageVersion().convention((Object)JavaLanguageVersion.of((int)version)));
        this.tasks.named(langSourceSet.getCompileJavaTaskName(), JavaCompile.class, task -> task.getJavaCompiler().convention(targetCompiler));
        this.tasks.named(testSourceSet.getCompileJavaTaskName(), JavaCompile.class, task -> task.getJavaCompiler().convention(targetCompiler));
        Provider targetLauncher = this.javaToolchains.launcherFor(spec -> spec.getLanguageVersion().convention((Object)JavaLanguageVersion.of((int)version)));
        Configuration testImplementation = this.configurations.getByName(testSourceSet.getImplementationConfigurationName());
        testImplementation.extendsFrom(new Configuration[]{this.configurations.getByName(sharedTestSourceSet.getImplementationConfigurationName())});
        Configuration testCompileOnly = this.configurations.getByName(testSourceSet.getCompileOnlyConfigurationName());
        testCompileOnly.extendsFrom(new Configuration[]{this.configurations.getByName(sharedTestSourceSet.getCompileOnlyConfigurationName())});
        testCompileOnly.getDependencies().add((Object)this.dependencies.create((Object)langSourceSet.getOutput().getClassesDirs()));
        testCompileOnly.getDependencies().add((Object)this.dependencies.create((Object)sharedSourceSet.getOutput().getClassesDirs()));
        Configuration testRuntimeClasspath = this.configurations.getByName(testSourceSet.getRuntimeClasspathConfigurationName());
        testRuntimeClasspath.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)this.objects.named(LibraryElements.class, "jar"));
        TaskProvider testTask = this.tasks.register("java" + version + "Test", Test.class, test -> {
            test.setGroup("verification");
            test.getJavaLauncher().convention(targetLauncher);
            ConfigurableFileCollection testClassesDirs = this.objects.fileCollection();
            testClassesDirs.from(new Object[]{testSourceSet.getOutput()});
            testClassesDirs.from(new Object[]{sharedTestSourceSet.getOutput()});
            test.setTestClassesDirs((FileCollection)testClassesDirs);
            ConfigurableFileCollection classpath = this.objects.fileCollection();
            classpath.from(new Object[]{this.tasks.named("jar")});
            classpath.from(new Object[]{testSourceSet.getOutput()});
            classpath.from(new Object[]{sharedTestSourceSet.getRuntimeClasspath()});
            test.setClasspath((FileCollection)classpath);
        });
        this.tasks.named("check", task -> task.dependsOn(new Object[]{testTask}));
        this.configureMrJar(version, langSourceSet);
        this.pluginManager.withPlugin("application", plugin -> {
            JavaApplication javaApp = (JavaApplication)this.extensions.getByType(JavaApplication.class);
            this.tasks.register("java" + version + "Run", JavaExec.class, run -> {
                run.setGroup("application");
                run.getJavaLauncher().convention(targetLauncher);
                run.getMainClass().convention((Provider)javaApp.getMainClass());
                run.setClasspath(langSourceSet.getRuntimeClasspath());
            });
        });
    }

    private void configureMrJar(int version, SourceSet languageSourceSet) {
        this.tasks.named("jar", Jar.class, jar -> {
            jar.into((Object)("META-INF/versions/" + version), s -> s.from(new Object[]{languageSourceSet.getOutput()}));
            Attributes attributes = jar.getManifest().getAttributes();
            attributes.put((Object)"Multi-Release", (Object)"true");
        });
    }

    private void defaultLanguageVersion(int version) {
        this.javaPluginExtension.getToolchain().getLanguageVersion().convention((Object)JavaLanguageVersion.of((int)version));
    }
}

