/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.igp.internal;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import me.champeau.gradle.igp.Authentication;
import me.champeau.gradle.igp.GitIncludeExtension;
import me.champeau.gradle.igp.IncludedGitRepo;
import me.champeau.gradle.igp.internal.CheckoutMetadata;
import me.champeau.gradle.igp.internal.DefaultAuthentication;
import me.champeau.gradle.igp.internal.DefaultIncludedGitRepo;
import me.champeau.gradle.igp.internal.ProviderUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.transport.ssh.jsch.JschConfigSessionFactory;
import org.eclipse.jgit.transport.ssh.jsch.OpenSshConfig;
import org.eclipse.jgit.util.FS;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.initialization.Settings;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultIncludeGitExtension
implements GitIncludeExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIncludeGitExtension.class);
    public static final String LOCAL_GIT_PREFIX = "local.git.";
    public static final String AUTO_GIT_DIRS = "auto.include.git.dirs";
    private final Settings settings;
    private Map<String, CheckoutMetadata> checkoutMetadata;
    private Action<? super Authentication> defaultAuth = a -> {};

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public DefaultIncludeGitExtension(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void include(String name, Action<? super IncludedGitRepo> spec) {
        this.getCheckoutsDirectory().finalizeValue();
        ProviderFactory providers = this.getProviders();
        this.readCheckoutMetadata();
        DefaultIncludedGitRepo repo = (DefaultIncludedGitRepo)this.getObjects().newInstance(DefaultIncludedGitRepo.class, new Object[]{name});
        repo.getCheckoutDirectory().convention(this.getCheckoutsDirectory().map(dir -> dir.dir(name)));
        spec.execute((Object)repo);
        DefaultAuthentication auth = repo.getAuth().orElseGet(() -> {
            DefaultAuthentication result = (DefaultAuthentication)this.getObjects().newInstance(DefaultAuthentication.class, new Object[0]);
            this.defaultAuth.execute((Object)result);
            return result;
        });
        File repoDir = ((Directory)repo.getCheckoutDirectory().get()).getAsFile();
        String localRepoProperty = LOCAL_GIT_PREFIX + repo.getName();
        Provider autoGitDirs = ProviderUtils.forUseAtConfigurationTime(providers.gradleProperty(AUTO_GIT_DIRS));
        Map<Object, Object> autoDirs = Collections.emptyMap();
        if (autoGitDirs.isPresent()) {
            autoDirs = Arrays.stream(((String)autoGitDirs.get()).split("[,;](\\s)?")).map(File::new).flatMap(dir -> {
                File[] dirEntries = dir.listFiles();
                return dirEntries == null ? Stream.empty() : Arrays.stream(dirEntries).filter(File::isDirectory);
            }).collect(Collectors.groupingBy(File::getName));
        }
        Map finalAutoDirs = autoDirs;
        Provider localRepo = ProviderUtils.forUseAtConfigurationTime(providers.gradleProperty(localRepoProperty)).orElse(ProviderUtils.forUseAtConfigurationTime(providers.systemProperty(localRepoProperty))).orElse(providers.provider(() -> {
            List files = (List)finalAutoDirs.get(repo.getName());
            if (files == null) {
                return null;
            }
            if (files.size() == 1) {
                return ((File)files.get(0)).toString();
            }
            throw new GradleException("More than one directory named " + repo.getName() + " exists in auto Git repositories: " + files);
        }));
        if (localRepo.isPresent()) {
            LOGGER.info("Using local repository for {} instead of cloning", (Object)repo.getName());
            repoDir = new File((String)localRepo.get());
        } else {
            this.cloneOrUpdate(repoDir, repo, auth);
        }
        repo.configure(this.settings, repoDir);
    }

    @Override
    public void defaultAuthentication(Action<? super Authentication> config) {
        this.defaultAuth = config;
    }

    private void readCheckoutMetadata() {
        block10: {
            if (this.checkoutMetadata == null) {
                this.checkoutMetadata = new HashMap<String, CheckoutMetadata>();
                File metadataFile = ((RegularFile)this.getCheckoutsDirectory().file("checkouts.bin").get()).getAsFile();
                if (metadataFile.exists()) {
                    try (DataInputStream dis = new DataInputStream(new FileInputStream(metadataFile));){
                        int size = dis.readInt();
                        for (int i2 = 0; i2 < size; ++i2) {
                            String uri = dis.readUTF();
                            String ref = dis.readUTF();
                            String branch = dis.readUTF();
                            long lastUpdate = dis.readLong();
                            this.checkoutMetadata.put(uri, new CheckoutMetadata(uri, ref, branch, lastUpdate));
                        }
                        break block10;
                    }
                    catch (IOException e) {
                        throw new GradleException("Unable to read checkout metadata", (Throwable)e);
                    }
                }
                this.checkoutMetadata = new HashMap<String, CheckoutMetadata>();
            }
        }
    }

    public void writeCheckoutMetadata() {
        if (this.checkoutMetadata == null) {
            return;
        }
        File metadataFile = ((RegularFile)this.getCheckoutsDirectory().file("checkouts.bin").get()).getAsFile();
        File parentFile = metadataFile.getParentFile();
        parentFile.mkdirs();
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(metadataFile));){
            int size = this.checkoutMetadata.size();
            dos.writeInt(size);
            this.checkoutMetadata.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
                CheckoutMetadata value = (CheckoutMetadata)e.getValue();
                try {
                    dos.writeUTF(value.getUri());
                    dos.writeUTF(value.getRef());
                    dos.writeUTF(value.getBranch());
                    dos.writeLong(value.getLastUpdate());
                }
                catch (IOException ex) {
                    throw new GradleException("Unable to write checkout metadata", (Throwable)ex);
                }
            });
        }
        catch (IOException e2) {
            throw new GradleException("Unable to write checkout metadata", (Throwable)e2);
        }
    }

    private void cloneOrUpdate(File repoDir, IncludedGitRepo repo, DefaultAuthentication auth) {
        String uri = (String)repo.getUri().get();
        String rev = (String)repo.getCommit().getOrElse((Object)"");
        String branchOrTag = (String)repo.getTag().orElse(repo.getBranch()).orElse((Object)"").get();
        CheckoutMetadata current = new CheckoutMetadata(uri, rev, branchOrTag, System.currentTimeMillis());
        if (repoDir.exists() && new File(repoDir, ".git").exists()) {
            this.updateRepository(repoDir, uri, rev, branchOrTag, current, auth);
        } else {
            this.cloneRepository(repoDir, uri, rev, branchOrTag, current, auth);
        }
    }

    <C extends GitCommand<?>, R, TC extends TransportCommand<C, R>> TC applyAuth(TC command, DefaultAuthentication authentication) {
        authentication.getBasicAuth().ifPresent(auth -> command.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider((String)auth.getUsername().get(), (String)auth.getPassword().get())));
        authentication.getSshWithPassword().ifPresent(auth -> {
            JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory((Authentication.WithPassword)auth){
                final /* synthetic */ Authentication.WithPassword val$auth;
                {
                    this.val$auth = withPassword;
                }

                protected void configure(OpenSshConfig.Host host, Session session) {
                    session.setPassword((String)this.val$auth.getPassword().get());
                }
            };
            command.setTransportConfigCallback(arg_0 -> DefaultIncludeGitExtension.lambda$applyAuth$7((SshSessionFactory)sshSessionFactory, arg_0));
        });
        authentication.getSshWithPublicKey().ifPresent(keyConfig -> {
            JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory((Authentication.KeyConfiguration)keyConfig){
                final /* synthetic */ Authentication.KeyConfiguration val$keyConfig;
                {
                    this.val$keyConfig = keyConfiguration;
                }

                protected JSch createDefaultJSch(FS fs) throws JSchException {
                    JSch defaultJSch = super.createDefaultJSch(fs);
                    if (this.val$keyConfig.getPrivateKey().isPresent()) {
                        defaultJSch.addIdentity(((RegularFile)this.val$keyConfig.getPrivateKey().get()).getAsFile().getAbsolutePath());
                    }
                    return defaultJSch;
                }
            };
            command.setTransportConfigCallback(arg_0 -> DefaultIncludeGitExtension.lambda$applyAuth$9((SshSessionFactory)sshSessionFactory, arg_0));
        });
        return command;
    }

    private void cloneRepository(File repoDir, String uri, String rev, String branchOrTag, CheckoutMetadata current, DefaultAuthentication auth) {
        block11: {
            LOGGER.info("Checking out {} ref {} in {}", new Object[]{uri, rev, repoDir});
            try {
                this.applyAuth(Git.cloneRepository().setURI(uri).setBranch(branchOrTag).setDirectory(repoDir), auth).call();
                if (rev.isEmpty()) break block11;
                try (Git git = Git.open((File)repoDir);){
                    git.checkout().setName(rev).call();
                }
            }
            catch (IOException | GitAPIException e) {
                throw new GradleException("Unable to clone repository contents: " + e.getMessage(), e);
            }
            finally {
                this.checkoutMetadata.put(uri, current);
            }
        }
    }

    private void updateRepository(File repoDir, String uri, String rev, String branchOrTag, CheckoutMetadata current, DefaultAuthentication auth) {
        block18: {
            if (this.checkoutMetadata.containsKey(uri)) {
                boolean upToDate;
                CheckoutMetadata old = this.checkoutMetadata.get(uri);
                boolean sameRef = Objects.equals(current.getRef(), old.getRef());
                boolean sameBranch = current.getBranch().equals(old.getBranch());
                boolean bl = upToDate = current.getLastUpdate() - old.getLastUpdate() < (Long)this.getRefreshIntervalMillis().get();
                if (sameRef && sameBranch && upToDate) {
                    return;
                }
            }
            try (Git git = Git.open((File)repoDir);){
                String fullBranch = git.getRepository().getFullBranch();
                if (fullBranch.startsWith("refs/heads/")) {
                    LOGGER.info("Pulling from {}", (Object)uri);
                    this.applyAuth(git.pull(), auth).call();
                }
                LOGGER.info("Checking out ref {} of {}", (Object)rev, (Object)uri);
                if (!rev.isEmpty()) {
                    git.checkout().setName(rev).call();
                    break block18;
                }
                Ref resolve = git.getRepository().findRef(branchOrTag);
                if (resolve == null) {
                    List refs = git.getRepository().getRefDatabase().getRefs();
                    for (Ref ref : refs) {
                        if (!ref.getName().endsWith(branchOrTag)) continue;
                        resolve = ref;
                        break;
                    }
                }
                if (resolve != null) {
                    git.checkout().setName(resolve.getName()).call();
                    break block18;
                }
                throw new GradleException("Branch or tag " + branchOrTag + " not found");
            }
            catch (IOException | GitAPIException e) {
                throw new GradleException("Unable to update repository contents: " + e.getMessage(), e);
            }
            finally {
                this.checkoutMetadata.put(uri, current);
            }
        }
    }

    private static /* synthetic */ void lambda$applyAuth$9(SshSessionFactory sshSessionFactory, Transport transport) {
        SshTransport sshTransport = (SshTransport)transport;
        sshTransport.setSshSessionFactory(sshSessionFactory);
    }

    private static /* synthetic */ void lambda$applyAuth$7(SshSessionFactory sshSessionFactory, Transport transport) {
        SshTransport sshTransport = (SshTransport)transport;
        sshTransport.setSshSessionFactory(sshSessionFactory);
    }
}

