/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.igp;

import java.io.File;
import javax.inject.Inject;
import me.champeau.gradle.igp.GitIncludeExtension;
import me.champeau.gradle.igp.internal.DefaultIncludeGitExtension;
import me.champeau.gradle.igp.internal.ProviderUtils;
import org.gradle.api.Plugin;
import org.gradle.api.initialization.Settings;
import org.gradle.api.provider.ProviderFactory;

public abstract class IncludeGitPlugin
implements Plugin<Settings> {
    public static final long DEFAULT_INTERVAL = 86400000L;
    public static final String REFRESH_GIT_REPOSITORIES_PROPERTY = "refresh.git.repositories";

    @Inject
    protected abstract ProviderFactory getProviders();

    public void apply(Settings settings) {
        GitIncludeExtension gitRepositories = (GitIncludeExtension)settings.getExtensions().create(GitIncludeExtension.class, "gitRepositories", DefaultIncludeGitExtension.class, new Object[]{settings});
        gitRepositories.getCheckoutsDirectory().set(new File(settings.getSettingsDir(), "checkouts"));
        gitRepositories.getRefreshIntervalMillis().convention(ProviderUtils.forUseAtConfigurationTime(this.getProviders().systemProperty(REFRESH_GIT_REPOSITORIES_PROPERTY)).map(s -> s.isEmpty() ? 0L : Long.parseLong(s)).orElse((Object)86400000L));
        settings.getGradle().settingsEvaluated(s -> ((DefaultIncludeGitExtension)gitRepositories).writeCheckoutMetadata());
    }
}

