/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.CountlyStore;
import ly.count.android.sdk.Event;
import org.json.JSONArray;

public class EventQueue {
    private final CountlyStore countlyStore_;

    EventQueue(CountlyStore countlyStore) {
        this.countlyStore_ = countlyStore;
    }

    int size() {
        return this.countlyStore_.events().length;
    }

    String events() {
        List<Event> events = this.countlyStore_.eventsList();
        JSONArray eventArray = new JSONArray();
        for (Event e : events) {
            eventArray.put((Object)e.toJSON());
        }
        String result = eventArray.toString();
        this.countlyStore_.removeEvents(events);
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    void recordEvent(String key, Map<String, String> segmentation, int count, double sum, double dur) {
        long timestamp = Countly.currentTimestampMs();
        int hour = Countly.currentHour();
        int dow = Countly.currentDayOfWeek();
        this.countlyStore_.addEvent(key, segmentation, timestamp, hour, dow, count, sum, dur);
    }

    void recordEvent(Event event) {
        event.hour = Countly.currentHour();
        event.dow = Countly.currentDayOfWeek();
        this.countlyStore_.addEvent(event);
    }

    CountlyStore getCountlyStore() {
        return this.countlyStore_;
    }
}

