/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RatingBar;
import java.util.HashMap;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.CountlyStore;
import ly.count.android.sdk.DeviceInfo;
import ly.count.android.sdk.R;
import org.json.JSONException;
import org.json.JSONObject;

public class CountlyStarRating {
    public static void showStarRating(Context context, RatingCallback callback) {
        StarRatingPreferences srp = CountlyStarRating.loadStarRatingPreferences(context);
        CountlyStarRating.showStarRatingCustom(context, srp.dialogTextTitle, srp.dialogTextMessage, srp.dialogTextDismiss, callback);
    }

    public static void showStarRatingCustom(final Context context, String title, String message, String cancelText, final RatingCallback callback) {
        if (!(context instanceof Activity)) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.e((String)"Countly", (String)"Can't show star rating dialog, the provided context is not based off a activity");
            }
            return;
        }
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View dialogLayout = inflater.inflate(R.layout.star_rating_layout, null);
        RatingBar ratingBar = (RatingBar)dialogLayout.findViewById(R.id.ratingBar);
        AlertDialog.Builder builder = new AlertDialog.Builder(context).setTitle((CharSequence)title).setMessage((CharSequence)message).setView(dialogLayout).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                if (callback != null) {
                    callback.onDismiss();
                }
            }
        }).setPositiveButton((CharSequence)cancelText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (callback != null) {
                    callback.onDismiss();
                }
            }
        });
        final AlertDialog dialog = builder.show();
        ratingBar.setOnRatingBarChangeListener(new RatingBar.OnRatingBarChangeListener(){

            public void onRatingChanged(RatingBar ratingBar, float v, boolean b) {
                int rating = (int)v;
                HashMap<String, String> segm = new HashMap<String, String>();
                segm.put("platform", "android");
                segm.put("app_version", DeviceInfo.getAppVersion(context));
                segm.put("rating", "" + rating);
                Countly.sharedInstance().recordEvent("[CLY]_star_rating", segm, 1);
                dialog.dismiss();
                if (callback != null) {
                    callback.onRate(rating);
                }
            }
        });
    }

    public static void setStarRatingInitConfig(Context context, int limit, String starRatingTextTitle, String starRatingTextMessage, String starRatingTextDismiss) {
        StarRatingPreferences srp = CountlyStarRating.loadStarRatingPreferences(context);
        if (limit >= 0) {
            srp.sessionLimit = limit;
        }
        if (starRatingTextTitle != null) {
            srp.dialogTextTitle = starRatingTextTitle;
        }
        if (starRatingTextMessage != null) {
            srp.dialogTextMessage = starRatingTextMessage;
        }
        if (starRatingTextDismiss != null) {
            srp.dialogTextDismiss = starRatingTextDismiss;
        }
        CountlyStarRating.saveStarRatingPreferences(context, srp);
    }

    private static StarRatingPreferences loadStarRatingPreferences(Context context) {
        StarRatingPreferences srp;
        CountlyStore cs = new CountlyStore(context);
        String srpString = cs.getStarRatingPreferences();
        if (!srpString.equals("")) {
            JSONObject srJSON = null;
            try {
                srJSON = new JSONObject(srpString);
                srp = StarRatingPreferences.fromJSON(srJSON);
            }
            catch (JSONException e) {
                e.printStackTrace();
                srp = new StarRatingPreferences();
            }
        } else {
            srp = new StarRatingPreferences();
        }
        return srp;
    }

    private static void saveStarRatingPreferences(Context context, StarRatingPreferences srp) {
        CountlyStore cs = new CountlyStore(context);
        cs.setStarRatingPreferences(srp.toJSON().toString());
    }

    public static void setShowDialogAutomatically(Context context, boolean shouldShow) {
        StarRatingPreferences srp = CountlyStarRating.loadStarRatingPreferences(context);
        srp.automaticRatingShouldBeShown = shouldShow;
        CountlyStarRating.saveStarRatingPreferences(context, srp);
    }

    public static void setStarRatingDisableAskingForEachAppVersion(Context context, boolean disableAsking) {
        StarRatingPreferences srp = CountlyStarRating.loadStarRatingPreferences(context);
        srp.disabledAutomaticForNewVersions = disableAsking;
        CountlyStarRating.saveStarRatingPreferences(context, srp);
    }

    public static void registerAppSession(Context context, RatingCallback starRatingCallback) {
        StarRatingPreferences srp = CountlyStarRating.loadStarRatingPreferences(context);
        String currentAppVersion = DeviceInfo.getAppVersion(context);
        if (currentAppVersion != null && !currentAppVersion.equals(srp.appVersion) && !srp.disabledAutomaticForNewVersions) {
            srp.appVersion = currentAppVersion;
            srp.isShownForCurrentVersion = false;
            srp.sessionAmount = 0;
        }
        ++srp.sessionAmount;
        if (!(srp.sessionAmount < srp.sessionLimit || srp.isShownForCurrentVersion || !srp.automaticRatingShouldBeShown || srp.disabledAutomaticForNewVersions && srp.automaticHasBeenShown)) {
            CountlyStarRating.showStarRating(context, starRatingCallback);
            srp.isShownForCurrentVersion = true;
            srp.automaticHasBeenShown = true;
        }
        CountlyStarRating.saveStarRatingPreferences(context, srp);
    }

    static class StarRatingPreferences {
        String appVersion = "";
        int sessionLimit = 5;
        int sessionAmount = 0;
        boolean isShownForCurrentVersion = false;
        boolean automaticRatingShouldBeShown = false;
        boolean disabledAutomaticForNewVersions = false;
        boolean automaticHasBeenShown = false;
        String dialogTextTitle = "App rating";
        String dialogTextMessage = "Please rate this app";
        String dialogTextDismiss = "Cancel";
        private static String KEY_APP_VERSION = "sr_app_version";
        private static String KEY_SESSION_LIMIT = "sr_session_limit";
        private static String KEY_SESSION_AMOUNT = "sr_session_amount";
        private static String KEY_IS_SHOWN_FOR_CURRENT = "sr_is_shown";
        private static String KEY_AUTOMATIC_RATING_IS_SHOWN = "sr_is_automatic_shown";
        private static String KEY_DISABLE_AUTOMATIC_NEW_VERSIONS = "sr_is_disable_automatic_new";
        private static String KEY_AUTOMATIC_HAS_BEEN_SHOWN = "sr_automatic_has_been_shown";
        private static String KEY_DIALOG_TEXT_TITLE = "sr_text_title";
        private static String KEY_DIALOG_TEXT_MESSAGE = "sr_text_message";
        private static String KEY_DIALOG_TEXT_DISMISS = "sr_text_dismiss";

        StarRatingPreferences() {
        }

        JSONObject toJSON() {
            JSONObject json;
            block2: {
                json = new JSONObject();
                try {
                    json.put(KEY_APP_VERSION, (Object)this.appVersion);
                    json.put(KEY_SESSION_LIMIT, this.sessionLimit);
                    json.put(KEY_SESSION_AMOUNT, this.sessionAmount);
                    json.put(KEY_IS_SHOWN_FOR_CURRENT, this.isShownForCurrentVersion);
                    json.put(KEY_AUTOMATIC_RATING_IS_SHOWN, this.automaticRatingShouldBeShown);
                    json.put(KEY_DISABLE_AUTOMATIC_NEW_VERSIONS, this.disabledAutomaticForNewVersions);
                    json.put(KEY_AUTOMATIC_HAS_BEEN_SHOWN, this.automaticHasBeenShown);
                    json.put(KEY_DIALOG_TEXT_TITLE, (Object)this.dialogTextTitle);
                    json.put(KEY_DIALOG_TEXT_MESSAGE, (Object)this.dialogTextMessage);
                    json.put(KEY_DIALOG_TEXT_DISMISS, (Object)this.dialogTextDismiss);
                }
                catch (JSONException e) {
                    if (!Countly.sharedInstance().isLoggingEnabled()) break block2;
                    Log.w((String)"Countly", (String)"Got exception converting an StarRatingPreferences to JSON", (Throwable)e);
                }
            }
            return json;
        }

        static StarRatingPreferences fromJSON(JSONObject json) {
            StarRatingPreferences srp;
            block6: {
                srp = new StarRatingPreferences();
                if (json != null) {
                    try {
                        srp.appVersion = json.getString(KEY_APP_VERSION);
                        srp.sessionLimit = json.optInt(KEY_SESSION_LIMIT, 5);
                        srp.sessionAmount = json.optInt(KEY_SESSION_AMOUNT, 0);
                        srp.isShownForCurrentVersion = json.optBoolean(KEY_IS_SHOWN_FOR_CURRENT, false);
                        srp.automaticRatingShouldBeShown = json.optBoolean(KEY_AUTOMATIC_RATING_IS_SHOWN, true);
                        srp.disabledAutomaticForNewVersions = json.optBoolean(KEY_DISABLE_AUTOMATIC_NEW_VERSIONS, false);
                        srp.automaticHasBeenShown = json.optBoolean(KEY_AUTOMATIC_HAS_BEEN_SHOWN, false);
                        if (!json.isNull(KEY_DIALOG_TEXT_TITLE)) {
                            srp.dialogTextTitle = json.getString(KEY_DIALOG_TEXT_TITLE);
                        }
                        if (!json.isNull(KEY_DIALOG_TEXT_MESSAGE)) {
                            srp.dialogTextMessage = json.getString(KEY_DIALOG_TEXT_MESSAGE);
                        }
                        if (!json.isNull(KEY_DIALOG_TEXT_DISMISS)) {
                            srp.dialogTextDismiss = json.getString(KEY_DIALOG_TEXT_DISMISS);
                        }
                    }
                    catch (JSONException e) {
                        if (!Countly.sharedInstance().isLoggingEnabled()) break block6;
                        Log.w((String)"Countly", (String)"Got exception converting JSON to a StarRatingPreferences", (Throwable)e);
                    }
                }
            }
            return srp;
        }
    }

    public static interface RatingCallback {
        public void onRate(int var1);

        public void onDismiss();
    }
}

