/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ly.count.android.sdk.AdvertisingIdAdapter;
import ly.count.android.sdk.ConnectionProcessor;
import ly.count.android.sdk.ConnectionQueue;
import ly.count.android.sdk.CountlyStarRating;
import ly.count.android.sdk.CountlyStore;
import ly.count.android.sdk.CrashDetails;
import ly.count.android.sdk.DeviceId;
import ly.count.android.sdk.DeviceInfo;
import ly.count.android.sdk.Event;
import ly.count.android.sdk.EventQueue;
import ly.count.android.sdk.MessagingAdapter;
import ly.count.android.sdk.OpenUDIDAdapter;
import ly.count.android.sdk.ReferrerReceiver;
import ly.count.android.sdk.UserData;

public class Countly {
    public static final String COUNTLY_SDK_VERSION_STRING = "17.09";
    public static final String COUNTLY_SDK_NAME = "java-native-android";
    public static final String DEFAULT_APP_VERSION = "1.0";
    public static final String TAG = "Countly";
    private static int EVENT_QUEUE_SIZE_THRESHOLD = 10;
    private static final long TIMER_DELAY_IN_SECONDS = 60L;
    protected static List<String> publicKeyPinCertificates;
    protected static List<String> certificatePinCertificates;
    protected static final Map<String, Event> timedEvents;
    private ConnectionQueue connectionQueue_;
    private ScheduledExecutorService timerService_;
    private EventQueue eventQueue_;
    private long prevSessionDurationStartTime_;
    private int activityCount_;
    private boolean disableUpdateSessionRequests_;
    private boolean enableLogging_;
    private CountlyMessagingMode messagingMode_;
    private Context context_;
    public static UserData userData;
    private String lastView = null;
    private int lastViewStart = 0;
    private boolean firstView = true;
    private boolean autoViewTracker = false;
    private boolean isHttpPostForced = false;
    private String optionalParameterCountryCode = null;
    private String optionalParameterCity = null;
    private String optionalParameterLocation = null;
    private boolean shouldIgnoreCrawlers = true;
    private boolean deviceIsAppCrawler = false;
    private List<String> appCrawlerNames = new ArrayList<String>(Arrays.asList("Calypso AppCrawler"));
    private CountlyStarRating.RatingCallback starRatingCallback_;
    private boolean calledAtLeastOnceOnStart = false;
    private boolean appLaunchDeepLink = true;
    private static TimeUniquesEnsurer timeGenerator;

    public static Countly sharedInstance() {
        return SingletonHolder.instance;
    }

    Countly() {
        this.connectionQueue_ = new ConnectionQueue();
        userData = new UserData(this.connectionQueue_);
        this.timerService_ = Executors.newSingleThreadScheduledExecutor();
        this.timerService_.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Countly.this.onTimer();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public Countly init(Context context, String serverURL, String appKey) {
        return this.init(context, serverURL, appKey, null, OpenUDIDAdapter.isOpenUDIDAvailable() ? DeviceId.Type.OPEN_UDID : DeviceId.Type.ADVERTISING_ID);
    }

    public Countly init(Context context, String serverURL, String appKey, String deviceID) {
        return this.init(context, serverURL, appKey, deviceID, null);
    }

    public synchronized Countly init(Context context, String serverURL, String appKey, String deviceID, DeviceId.Type idMode) {
        return this.init(context, serverURL, appKey, deviceID, idMode, -1, null, null, null, null);
    }

    public synchronized Countly init(Context context, String serverURL, String appKey, String deviceID, DeviceId.Type idMode, int starRatingLimit, CountlyStarRating.RatingCallback starRatingCallback, String starRatingTextTitle, String starRatingTextMessage, String starRatingTextDismiss) {
        if (context == null) {
            throw new IllegalArgumentException("valid context is required");
        }
        if (!Countly.isValidURL(serverURL)) {
            throw new IllegalArgumentException("valid serverURL is required");
        }
        if (serverURL.charAt(serverURL.length() - 1) == '/') {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.i((String)TAG, (String)"Removing trailing '/' from provided server url");
            }
            serverURL = serverURL.substring(0, serverURL.length() - 1);
        }
        if (appKey == null || appKey.length() == 0) {
            throw new IllegalArgumentException("valid appKey is required");
        }
        if (deviceID != null && deviceID.length() == 0) {
            throw new IllegalArgumentException("valid deviceID is required");
        }
        if (deviceID == null && idMode == null) {
            if (OpenUDIDAdapter.isOpenUDIDAvailable()) {
                idMode = DeviceId.Type.OPEN_UDID;
            } else if (AdvertisingIdAdapter.isAdvertisingIdAvailable()) {
                idMode = DeviceId.Type.ADVERTISING_ID;
            }
        }
        if (deviceID == null && idMode == DeviceId.Type.OPEN_UDID && !OpenUDIDAdapter.isOpenUDIDAvailable()) {
            throw new IllegalArgumentException("valid deviceID is required because OpenUDID is not available");
        }
        if (deviceID == null && idMode == DeviceId.Type.ADVERTISING_ID && !AdvertisingIdAdapter.isAdvertisingIdAvailable()) {
            throw new IllegalArgumentException("valid deviceID is required because Advertising ID is not available (you need to include Google Play services 4.0+ into your project)");
        }
        if (!(this.eventQueue_ == null || this.connectionQueue_.getServerURL().equals(serverURL) && this.connectionQueue_.getAppKey().equals(appKey) && DeviceId.deviceIDEqualsNullSafe(deviceID, idMode, this.connectionQueue_.getDeviceId()))) {
            throw new IllegalStateException("Countly cannot be reinitialized with different values");
        }
        if (MessagingAdapter.isMessagingAvailable()) {
            MessagingAdapter.storeConfiguration(context, serverURL, appKey, deviceID, idMode);
        }
        this.starRatingCallback_ = starRatingCallback;
        CountlyStarRating.setStarRatingInitConfig(context, starRatingLimit, starRatingTextTitle, starRatingTextMessage, starRatingTextDismiss);
        this.checkIfDeviceIsAppCrawler();
        if (this.eventQueue_ == null) {
            CountlyStore countlyStore = new CountlyStore(context);
            DeviceId deviceIdInstance = deviceID != null ? new DeviceId(countlyStore, deviceID) : new DeviceId(countlyStore, idMode);
            deviceIdInstance.init(context, countlyStore, true);
            this.connectionQueue_.setServerURL(serverURL);
            this.connectionQueue_.setAppKey(appKey);
            this.connectionQueue_.setCountlyStore(countlyStore);
            this.connectionQueue_.setDeviceId(deviceIdInstance);
            this.eventQueue_ = new EventQueue(countlyStore);
            CountlyStarRating.registerAppSession(context, this.starRatingCallback_);
        }
        this.context_ = context;
        this.connectionQueue_.setContext(context);
        return this;
    }

    public synchronized boolean isInitialized() {
        return this.eventQueue_ != null;
    }

    public Countly initMessaging(Activity activity, Class<? extends Activity> activityClass, String projectID, CountlyMessagingMode mode) {
        return this.initMessaging(activity, activityClass, projectID, null, mode, false);
    }

    public Countly initMessaging(Activity activity, Class<? extends Activity> activityClass, String projectID, CountlyMessagingMode mode, boolean disableUI) {
        return this.initMessaging(activity, activityClass, projectID, null, mode, disableUI);
    }

    public synchronized Countly initMessaging(Activity activity, Class<? extends Activity> activityClass, String projectID, String[] buttonNames, CountlyMessagingMode mode) {
        return this.initMessaging(activity, activityClass, projectID, null, mode, false);
    }

    public synchronized Countly initMessaging(Activity activity, Class<? extends Activity> activityClass, String projectID, String[] buttonNames, CountlyMessagingMode mode, boolean disableUI) {
        if (mode != null && !MessagingAdapter.isMessagingAvailable()) {
            throw new IllegalStateException("you need to include countly-messaging-sdk-android library instead of countly-sdk-android if you want to use Countly Messaging");
        }
        this.messagingMode_ = mode;
        if (!MessagingAdapter.init(activity, activityClass, projectID, buttonNames, disableUI)) {
            throw new IllegalStateException("couldn't initialize Countly Messaging");
        }
        if (MessagingAdapter.isMessagingAvailable()) {
            MessagingAdapter.storeConfiguration(this.connectionQueue_.getContext(), this.connectionQueue_.getServerURL(), this.connectionQueue_.getAppKey(), this.connectionQueue_.getDeviceId().getId(), this.connectionQueue_.getDeviceId().getType());
        }
        return this;
    }

    public synchronized void halt() {
        this.eventQueue_ = null;
        CountlyStore countlyStore = this.connectionQueue_.getCountlyStore();
        if (countlyStore != null) {
            countlyStore.clear();
        }
        this.connectionQueue_.setContext(null);
        this.connectionQueue_.setServerURL(null);
        this.connectionQueue_.setAppKey(null);
        this.connectionQueue_.setCountlyStore(null);
        this.prevSessionDurationStartTime_ = 0L;
        this.activityCount_ = 0;
    }

    public synchronized void onStart(Activity activity) {
        this.appLaunchDeepLink = false;
        if (this.eventQueue_ == null) {
            throw new IllegalStateException("init must be called before onStart");
        }
        ++this.activityCount_;
        if (this.activityCount_ == 1) {
            this.onStartHelper();
        }
        String referrer = ReferrerReceiver.getReferrer(this.context_);
        if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.d((String)TAG, (String)("Checking referrer: " + referrer));
        }
        if (referrer != null) {
            this.connectionQueue_.sendReferrerData(referrer);
            ReferrerReceiver.deleteReferrer(this.context_);
        }
        CrashDetails.inForeground();
        if (this.autoViewTracker) {
            this.recordView(activity.getClass().getName());
        }
        this.calledAtLeastOnceOnStart = true;
    }

    void onStartHelper() {
        this.prevSessionDurationStartTime_ = System.nanoTime();
        this.connectionQueue_.beginSession();
    }

    public synchronized void onStop() {
        if (this.eventQueue_ == null) {
            throw new IllegalStateException("init must be called before onStop");
        }
        if (this.activityCount_ == 0) {
            throw new IllegalStateException("must call onStart before onStop");
        }
        --this.activityCount_;
        if (this.activityCount_ == 0) {
            this.onStopHelper();
        }
        CrashDetails.inBackground();
        this.reportViewDuration();
    }

    void onStopHelper() {
        this.connectionQueue_.endSession(this.roundedSecondsSinceLastSessionDurationUpdate());
        this.prevSessionDurationStartTime_ = 0L;
        if (this.eventQueue_.size() > 0) {
            this.connectionQueue_.recordEvents(this.eventQueue_.events());
        }
    }

    public void onRegistrationId(String registrationId) {
        this.connectionQueue_.tokenSession(registrationId, this.messagingMode_);
    }

    public void onRegistrationId(String registrationId, CountlyMessagingMode mode) {
        this.connectionQueue_.tokenSession(registrationId, mode);
    }

    public void changeDeviceId(DeviceId.Type type, String deviceId) {
        if (this.eventQueue_ == null) {
            throw new IllegalStateException("init must be called before changeDeviceId");
        }
        if (this.activityCount_ == 0) {
            throw new IllegalStateException("must call onStart before changeDeviceId");
        }
        if (type == null) {
            throw new IllegalStateException("type cannot be null");
        }
        this.connectionQueue_.endSession(this.roundedSecondsSinceLastSessionDurationUpdate(), this.connectionQueue_.getDeviceId().getId());
        this.connectionQueue_.getDeviceId().changeToId(this.context_, this.connectionQueue_.getCountlyStore(), type, deviceId);
        this.connectionQueue_.beginSession();
    }

    public void changeDeviceId(String deviceId) {
        if (this.eventQueue_ == null) {
            throw new IllegalStateException("init must be called before changeDeviceId");
        }
        if (this.activityCount_ == 0) {
            throw new IllegalStateException("must call onStart before changeDeviceId");
        }
        if (deviceId == null || "".equals(deviceId)) {
            throw new IllegalStateException("deviceId cannot be null or empty");
        }
        this.connectionQueue_.changeDeviceId(deviceId, this.roundedSecondsSinceLastSessionDurationUpdate());
    }

    public void recordEvent(String key) {
        this.recordEvent(key, null, 1, 0.0);
    }

    public void recordEvent(String key, int count) {
        this.recordEvent(key, null, count, 0.0);
    }

    public void recordEvent(String key, int count, double sum) {
        this.recordEvent(key, null, count, sum);
    }

    public void recordEvent(String key, Map<String, String> segmentation, int count) {
        this.recordEvent(key, segmentation, count, 0.0);
    }

    public synchronized void recordEvent(String key, Map<String, String> segmentation, int count, double sum) {
        this.recordEvent(key, segmentation, count, sum, 0.0);
    }

    public synchronized void recordEvent(String key, Map<String, String> segmentation, int count, double sum, double dur) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Countly.sharedInstance().init must be called before recordEvent");
        }
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Valid Countly event key is required");
        }
        if (count < 1) {
            throw new IllegalArgumentException("Countly event count should be greater than zero");
        }
        if (segmentation != null) {
            for (String k : segmentation.keySet()) {
                if (k == null || k.length() == 0) {
                    throw new IllegalArgumentException("Countly event segmentation key cannot be null or empty");
                }
                if (segmentation.get(k) != null && segmentation.get(k).length() != 0) continue;
                throw new IllegalArgumentException("Countly event segmentation value cannot be null or empty");
            }
        }
        this.eventQueue_.recordEvent(key, segmentation, count, sum, dur);
        this.sendEventsIfNeeded();
    }

    public synchronized Countly setViewTracking(boolean enable) {
        this.autoViewTracker = enable;
        return this;
    }

    public synchronized boolean isViewTrackingEnabled() {
        return this.autoViewTracker;
    }

    public synchronized Countly recordView(String viewName) {
        this.reportViewDuration();
        this.lastView = viewName;
        this.lastViewStart = Countly.currentTimestamp();
        HashMap<String, String> segments = new HashMap<String, String>();
        segments.put("name", viewName);
        segments.put("visit", "1");
        segments.put("segment", "Android");
        if (this.firstView) {
            this.firstView = false;
            segments.put("start", "1");
        }
        this.recordEvent("[CLY]_view", segments, 1);
        return this;
    }

    public synchronized Countly setUserData(Map<String, String> data) {
        return this.setUserData(data, null);
    }

    public synchronized Countly setUserData(Map<String, String> data, Map<String, String> customdata) {
        UserData.setData(data);
        if (customdata != null) {
            UserData.setCustomData(customdata);
        }
        this.connectionQueue_.sendUserData();
        UserData.clear();
        return this;
    }

    public synchronized Countly setCustomUserData(Map<String, String> customdata) {
        if (customdata != null) {
            UserData.setCustomData(customdata);
        }
        this.connectionQueue_.sendUserData();
        UserData.clear();
        return this;
    }

    public synchronized Countly setLocation(double lat, double lon) {
        this.connectionQueue_.getCountlyStore().setLocation(lat, lon);
        if (this.disableUpdateSessionRequests_) {
            this.connectionQueue_.updateSession(this.roundedSecondsSinceLastSessionDurationUpdate());
        }
        return this;
    }

    public synchronized Countly setCustomCrashSegments(Map<String, String> segments) {
        if (segments != null) {
            CrashDetails.setCustomSegments(segments);
        }
        return this;
    }

    public synchronized Countly addCrashLog(String record) {
        CrashDetails.addLog(record);
        return this;
    }

    public synchronized Countly logException(Exception exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        this.connectionQueue_.sendCrashReport(sw.toString(), true);
        return this;
    }

    public synchronized Countly enableCrashReporting() {
        final Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                Countly.sharedInstance().connectionQueue_.sendCrashReport(sw.toString(), false);
                if (oldHandler != null) {
                    oldHandler.uncaughtException(t, e);
                }
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(handler);
        return this;
    }

    public synchronized boolean startEvent(String key) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Countly.sharedInstance().init must be called before recordEvent");
        }
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Valid Countly event key is required");
        }
        if (timedEvents.containsKey(key)) {
            return false;
        }
        timedEvents.put(key, new Event(key));
        return true;
    }

    public synchronized boolean endEvent(String key) {
        return this.endEvent(key, null, 1, 0.0);
    }

    public synchronized boolean endEvent(String key, Map<String, String> segmentation, int count, double sum) {
        Event event = timedEvents.remove(key);
        if (event != null) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("Countly.sharedInstance().init must be called before recordEvent");
            }
            if (key == null || key.length() == 0) {
                throw new IllegalArgumentException("Valid Countly event key is required");
            }
            if (count < 1) {
                throw new IllegalArgumentException("Countly event count should be greater than zero");
            }
            if (segmentation != null) {
                for (String k : segmentation.keySet()) {
                    if (k == null || k.length() == 0) {
                        throw new IllegalArgumentException("Countly event segmentation key cannot be null or empty");
                    }
                    if (segmentation.get(k) != null && segmentation.get(k).length() != 0) continue;
                    throw new IllegalArgumentException("Countly event segmentation value cannot be null or empty");
                }
            }
            long currentTimestamp = Countly.currentTimestampMs();
            event.segmentation = segmentation;
            event.dur = (double)(currentTimestamp - event.timestamp) / 1000.0;
            event.count = count;
            event.sum = sum;
            this.eventQueue_.recordEvent(event);
            this.sendEventsIfNeeded();
            return true;
        }
        return false;
    }

    public synchronized Countly setDisableUpdateSessionRequests(boolean disable) {
        this.disableUpdateSessionRequests_ = disable;
        return this;
    }

    public synchronized Countly setLoggingEnabled(boolean enableLogging) {
        this.enableLogging_ = enableLogging;
        return this;
    }

    public synchronized boolean isLoggingEnabled() {
        return this.enableLogging_;
    }

    public synchronized Countly enableParameterTamperingProtection(String salt) {
        ConnectionProcessor.salt = salt;
        return this;
    }

    public synchronized boolean hasBeenCalledOnStart() {
        return this.calledAtLeastOnceOnStart;
    }

    public synchronized Countly setEventQueueSizeToSend(int size) {
        EVENT_QUEUE_SIZE_THRESHOLD = size;
        return this;
    }

    public static void onCreate(Activity activity) {
        Uri data;
        Intent intent;
        Intent launchIntent = activity.getPackageManager().getLaunchIntentForPackage(activity.getPackageName());
        if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.d((String)TAG, (String)("Activity created: " + activity.getClass().getName() + " ( main is " + launchIntent.getComponent().getClassName() + ")"));
        }
        if ((intent = activity.getIntent()) != null && (data = intent.getData()) != null) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.d((String)TAG, (String)("Data in activity created intent: " + data + " (appLaunchDeepLink " + Countly.sharedInstance().appLaunchDeepLink + ") "));
            }
            if (Countly.sharedInstance().appLaunchDeepLink) {
                DeviceInfo.deepLink = data.toString();
            }
        }
    }

    void reportViewDuration() {
        if (this.lastView != null && this.lastViewStart <= 0 && Countly.sharedInstance().isLoggingEnabled()) {
            Log.e((String)TAG, (String)("Last view start value is not normal: [" + this.lastViewStart + "]"));
        }
        if (this.lastView != null && this.lastViewStart > 0) {
            HashMap<String, String> segments = new HashMap<String, String>();
            segments.put("name", this.lastView);
            segments.put("dur", String.valueOf(Countly.currentTimestamp() - this.lastViewStart));
            segments.put("segment", "Android");
            this.recordEvent("[CLY]_view", segments, 1);
            this.lastView = null;
            this.lastViewStart = 0;
        }
    }

    void sendEventsIfNeeded() {
        if (this.eventQueue_.size() >= EVENT_QUEUE_SIZE_THRESHOLD) {
            this.connectionQueue_.recordEvents(this.eventQueue_.events());
        }
    }

    synchronized void onTimer() {
        boolean hasActiveSession;
        boolean bl = hasActiveSession = this.activityCount_ > 0;
        if (hasActiveSession) {
            if (!this.disableUpdateSessionRequests_) {
                this.connectionQueue_.updateSession(this.roundedSecondsSinceLastSessionDurationUpdate());
            }
            if (this.eventQueue_.size() > 0) {
                this.connectionQueue_.recordEvents(this.eventQueue_.events());
            }
        }
    }

    int roundedSecondsSinceLastSessionDurationUpdate() {
        long currentTimestampInNanoseconds = System.nanoTime();
        long unsentSessionLengthInNanoseconds = currentTimestampInNanoseconds - this.prevSessionDurationStartTime_;
        this.prevSessionDurationStartTime_ = currentTimestampInNanoseconds;
        return (int)Math.round((double)unsentSessionLengthInNanoseconds / 1.0E9);
    }

    static int currentTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    static synchronized long currentTimestampMs() {
        return timeGenerator.uniqueTimestamp();
    }

    static int currentHour() {
        return Calendar.getInstance().get(11);
    }

    static int currentDayOfWeek() {
        int day = Calendar.getInstance().get(7);
        switch (day) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 0;
    }

    static boolean isValidURL(String urlStr) {
        boolean validURL = false;
        if (urlStr != null && urlStr.length() > 0) {
            try {
                new URL(urlStr);
                validURL = true;
            }
            catch (MalformedURLException e) {
                validURL = false;
            }
        }
        return validURL;
    }

    public static Countly enablePublicKeyPinning(List<String> certificates) {
        publicKeyPinCertificates = certificates;
        return Countly.sharedInstance();
    }

    public static Countly enableCertificatePinning(List<String> certificates) {
        certificatePinCertificates = certificates;
        return Countly.sharedInstance();
    }

    public void showStarRating(Activity activity, CountlyStarRating.RatingCallback callback) {
        CountlyStarRating.showStarRating((Context)activity, callback);
    }

    public void setStarRatingDialogTexts(String starRatingTextTitle, String starRatingTextMessage, String starRatingTextDismiss) {
        if (this.context_ == null && Countly.sharedInstance().isLoggingEnabled()) {
            Log.e((String)TAG, (String)"Can't call this function before init has been called");
            return;
        }
        CountlyStarRating.setStarRatingInitConfig(this.context_, -1, starRatingTextTitle, starRatingTextMessage, starRatingTextDismiss);
    }

    public void setIfStarRatingShownAutomatically(boolean IsShownAutomatically) {
        if (this.context_ == null && Countly.sharedInstance().isLoggingEnabled()) {
            Log.e((String)TAG, (String)"Can't call this function before init has been called");
            return;
        }
        CountlyStarRating.setShowDialogAutomatically(this.context_, IsShownAutomatically);
    }

    public void setStarRatingDisableAskingForEachAppVersion(boolean disableAsking) {
        if (this.context_ == null && Countly.sharedInstance().isLoggingEnabled()) {
            Log.e((String)TAG, (String)"Can't call this function before init has been called");
            return;
        }
        CountlyStarRating.setShowDialogAutomatically(this.context_, disableAsking);
    }

    public void setAutomaticStarRatingSessionLimit(int limit) {
        if (this.context_ == null && Countly.sharedInstance().isLoggingEnabled()) {
            Log.e((String)TAG, (String)"Can't call this function before init has been called");
            return;
        }
        CountlyStarRating.setStarRatingInitConfig(this.context_, limit, null, null, null);
    }

    public void setHttpPostForced(boolean isItForced) {
        this.isHttpPostForced = isItForced;
    }

    public boolean isHttpPostForced() {
        return this.isHttpPostForced;
    }

    public void setOptionalParametersForInitialization(String country_code, String city, String location) {
        this.optionalParameterCountryCode = country_code;
        this.optionalParameterCity = city;
        this.optionalParameterLocation = location;
    }

    public String getOptionalParameterCountryCode() {
        return this.optionalParameterCountryCode;
    }

    public String getOptionalParameterCity() {
        return this.optionalParameterCity;
    }

    public String getOptionalParameterLocation() {
        return this.optionalParameterLocation;
    }

    private void checkIfDeviceIsAppCrawler() {
        String deviceName = DeviceInfo.getDevice();
        for (int a = 0; a < this.appCrawlerNames.size(); ++a) {
            if (!deviceName.equals(this.appCrawlerNames.get(a))) continue;
            this.deviceIsAppCrawler = true;
            return;
        }
    }

    public void setShouldIgnoreCrawlers(boolean shouldIgnore) {
        this.shouldIgnoreCrawlers = shouldIgnore;
    }

    public void addAppCrawlerName(String crawlerName) {
        if (crawlerName != null && !crawlerName.isEmpty()) {
            this.appCrawlerNames.add(crawlerName);
        }
    }

    public boolean isDeviceAppCrawler() {
        return this.deviceIsAppCrawler;
    }

    public boolean ifShouldIgnoreCrawlers() {
        return this.shouldIgnoreCrawlers;
    }

    public String getDeviceID() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("init must be called before getDeviceID");
        }
        return this.connectionQueue_.getDeviceId().getId();
    }

    public DeviceId.Type getDeviceIDType() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("init must be called before getDeviceID");
        }
        return this.connectionQueue_.getDeviceId().getType();
    }

    ConnectionQueue getConnectionQueue() {
        return this.connectionQueue_;
    }

    void setConnectionQueue(ConnectionQueue connectionQueue) {
        this.connectionQueue_ = connectionQueue;
    }

    ExecutorService getTimerService() {
        return this.timerService_;
    }

    EventQueue getEventQueue() {
        return this.eventQueue_;
    }

    void setEventQueue(EventQueue eventQueue) {
        this.eventQueue_ = eventQueue;
    }

    long getPrevSessionDurationStartTime() {
        return this.prevSessionDurationStartTime_;
    }

    void setPrevSessionDurationStartTime(long prevSessionDurationStartTime) {
        this.prevSessionDurationStartTime_ = prevSessionDurationStartTime;
    }

    int getActivityCount() {
        return this.activityCount_;
    }

    synchronized boolean getDisableUpdateSessionRequests() {
        return this.disableUpdateSessionRequests_;
    }

    public void stackOverflow() {
        this.stackOverflow();
    }

    public synchronized Countly crashTest(int crashNumber) {
        if (crashNumber == 1) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.d((String)TAG, (String)"Running crashTest 1");
            }
            this.stackOverflow();
        } else if (crashNumber == 2) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.d((String)TAG, (String)"Running crashTest 2");
            }
            int n = 10 / 0;
        } else {
            if (crashNumber == 3) {
                if (Countly.sharedInstance().isLoggingEnabled()) {
                    Log.d((String)TAG, (String)"Running crashTest 3");
                }
                Object[] o = null;
                while (true) {
                    o = new Object[]{o};
                }
            }
            if (crashNumber == 4) {
                if (Countly.sharedInstance().isLoggingEnabled()) {
                    Log.d((String)TAG, (String)"Running crashTest 4");
                }
                throw new RuntimeException("This is a crash");
            }
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.d((String)TAG, (String)"Running crashTest 5");
            }
            String test = null;
            test.charAt(1);
        }
        return Countly.sharedInstance();
    }

    static {
        timedEvents = new HashMap<String, Event>();
        timeGenerator = new TimeUniquesEnsurer();
    }

    static class TimeUniquesEnsurer {
        List<Long> lastTsMs = new ArrayList<Long>(10);
        long addition = 0L;

        TimeUniquesEnsurer() {
        }

        long currentTimeMillis() {
            return System.currentTimeMillis() + this.addition;
        }

        synchronized long uniqueTimestamp() {
            long min;
            long ms = this.currentTimeMillis();
            if (this.lastTsMs.size() > 2 && ms < (min = Collections.min(this.lastTsMs).longValue())) {
                this.lastTsMs.clear();
                this.lastTsMs.add(ms);
                return ms;
            }
            while (this.lastTsMs.contains(ms)) {
                ++ms;
            }
            while (this.lastTsMs.size() >= 10) {
                this.lastTsMs.remove(0);
            }
            this.lastTsMs.add(ms);
            return ms;
        }
    }

    private static class SingletonHolder {
        static final Countly instance = new Countly();

        private SingletonHolder() {
        }
    }

    public static enum CountlyMessagingMode {
        TEST,
        PRODUCTION;

    }
}

