/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk;

import android.content.Context;
import android.util.Log;
import ly.count.android.sdk.AdvertisingIdAdapter;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.CountlyStore;
import ly.count.android.sdk.OpenUDIDAdapter;

public class DeviceId {
    private static final String TAG = "DeviceId";
    private static final String PREFERENCE_KEY_ID_TYPE = "ly.count.android.api.DeviceId.type";
    private String id;
    private Type type;

    public DeviceId(Type type) {
        if (type == null) {
            throw new IllegalStateException("Please specify DeviceId.Type, that is which type of device ID generation you want to use");
        }
        if (type == Type.DEVELOPER_SUPPLIED) {
            throw new IllegalStateException("Please use another DeviceId constructor for device IDs supplied by developer");
        }
        this.type = type;
    }

    public DeviceId(String developerSuppliedId) {
        if (developerSuppliedId == null || "".equals(developerSuppliedId)) {
            throw new IllegalStateException("Please make sure that device ID is not null or empty");
        }
        this.type = Type.DEVELOPER_SUPPLIED;
        this.id = developerSuppliedId;
    }

    public void init(Context context, CountlyStore store, boolean raiseExceptions) {
        Type overriddenType = this.retrieveOverriddenType(store);
        if (overriddenType != null && overriddenType != this.type) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.i((String)TAG, (String)("Overridden device ID generation strategy detected: " + (Object)((Object)overriddenType) + ", using it instead of " + (Object)((Object)this.type)));
            }
            this.type = overriddenType;
        }
        switch (this.type) {
            case DEVELOPER_SUPPLIED: {
                break;
            }
            case OPEN_UDID: {
                if (OpenUDIDAdapter.isOpenUDIDAvailable()) {
                    if (Countly.sharedInstance().isLoggingEnabled()) {
                        Log.i((String)TAG, (String)"Using OpenUDID");
                    }
                    if (OpenUDIDAdapter.isInitialized()) break;
                    OpenUDIDAdapter.sync(context);
                    break;
                }
                if (!raiseExceptions) break;
                throw new IllegalStateException("OpenUDID is not available, please make sure that you have it in your classpath");
            }
            case ADVERTISING_ID: {
                if (AdvertisingIdAdapter.isAdvertisingIdAvailable()) {
                    if (Countly.sharedInstance().isLoggingEnabled()) {
                        Log.i((String)TAG, (String)"Using Advertising ID");
                    }
                    AdvertisingIdAdapter.setAdvertisingId(context, store, this);
                    break;
                }
                if (OpenUDIDAdapter.isOpenUDIDAvailable()) {
                    if (Countly.sharedInstance().isLoggingEnabled()) {
                        Log.i((String)TAG, (String)"Advertising ID is not available, falling back to OpenUDID");
                    }
                    if (OpenUDIDAdapter.isInitialized()) break;
                    OpenUDIDAdapter.sync(context);
                    break;
                }
                if (Countly.sharedInstance().isLoggingEnabled()) {
                    Log.w((String)TAG, (String)"Advertising ID is not available, neither OpenUDID is");
                }
                if (!raiseExceptions) break;
                throw new IllegalStateException("OpenUDID is not available, please make sure that you have it in your classpath");
            }
        }
    }

    private void storeOverriddenType(CountlyStore store, Type type) {
        store.setPreference(PREFERENCE_KEY_ID_TYPE, type == null ? null : type.toString());
    }

    private Type retrieveOverriddenType(CountlyStore store) {
        String oldTypeString = store.getPreference(PREFERENCE_KEY_ID_TYPE);
        Type oldType = oldTypeString == null ? null : (oldTypeString.equals(Type.DEVELOPER_SUPPLIED.toString()) ? Type.DEVELOPER_SUPPLIED : (oldTypeString.equals(Type.OPEN_UDID.toString()) ? Type.OPEN_UDID : (oldTypeString.equals(Type.ADVERTISING_ID.toString()) ? Type.ADVERTISING_ID : null)));
        return oldType;
    }

    public String getId() {
        if (this.id == null && this.type == Type.OPEN_UDID) {
            this.id = OpenUDIDAdapter.getOpenUDID();
        }
        return this.id;
    }

    protected void setId(Type type, String id) {
        if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.w((String)TAG, (String)("Device ID is " + id + " (type " + (Object)((Object)type) + ")"));
        }
        this.type = type;
        this.id = id;
    }

    protected void switchToIdType(Type type, Context context, CountlyStore store) {
        if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.w((String)TAG, (String)("Switching to device ID generation strategy " + (Object)((Object)type) + " from " + (Object)((Object)this.type)));
        }
        this.type = type;
        this.storeOverriddenType(store, type);
        this.init(context, store, false);
    }

    public Type getType() {
        return this.type;
    }

    static boolean deviceIDEqualsNullSafe(String id, Type type, DeviceId deviceId) {
        if (type == null || type == Type.DEVELOPER_SUPPLIED) {
            String deviceIdId = deviceId == null ? null : deviceId.getId();
            return deviceIdId == null && id == null || deviceIdId != null && deviceIdId.equals(id);
        }
        return true;
    }

    public static enum Type {
        DEVELOPER_SUPPLIED,
        OPEN_UDID,
        ADVERTISING_ID;

    }
}

