/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk.messaging;

import android.os.Build;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Utils {
    private static final Utils utils = new Utils();
    static final String UTF8 = "UTF-8";
    static final String CRLF = "\r\n";
    static final char[] BASE_16 = "0123456789ABCDEF".toCharArray();

    static <T> String join(Collection<T> objects, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> iter = objects.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    static String urlencode(String str) {
        try {
            return URLEncoder.encode(str, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            Log.wtf((String)"Countly", (String)("No UTF-8 encoding? " + e));
            return "";
        }
    }

    static String urldecode(String str) {
        try {
            return URLDecoder.decode(str, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    static List<Field> reflectiveGetDeclaredFields(Class<?> cls) {
        return Utils.reflectiveGetDeclaredFields(new ArrayList<Field>(), cls);
    }

    private static List<Field> reflectiveGetDeclaredFields(List<Field> list, Class<?> cls) {
        ArrayList<Field> curr = new ArrayList<Field>(Arrays.asList(cls.getDeclaredFields()));
        for (int i = 0; i < curr.size(); ++i) {
            if (!((Field)curr.get(i)).getName().contains("$")) continue;
            curr.remove(i);
            --i;
        }
        list.addAll(curr);
        if (cls.getSuperclass() != null) {
            Utils.reflectiveGetDeclaredFields(list, cls.getSuperclass());
        }
        return list;
    }

    static boolean reflectiveClassExists(String cls) {
        return utils._reflectiveClassExists(cls);
    }

    public boolean _reflectiveClassExists(String cls) {
        try {
            Class.forName(cls);
            return true;
        }
        catch (ClassNotFoundException e) {
            Log.d((String)"Countly", (String)("Class " + cls + " not found"));
            return false;
        }
    }

    static Object reflectiveCall(String className, Object instance, String methodName, Object ... args) {
        return utils._reflectiveCall(className, instance, methodName, args);
    }

    public Object _reflectiveCall(String className, Object instance, String methodName, Object ... args) {
        try {
            Log.d((String)"Countly", (String)("cls " + className + ", inst " + instance));
            className = className == null && instance != null ? instance.getClass().getName() : className;
            Class<?> cls = instance == null ? Class.forName(className) : instance.getClass();
            Class[] types = null;
            if (args != null && args.length > 0) {
                types = new Class[args.length];
                for (int i = 0; i < types.length; ++i) {
                    types[i] = args[i].getClass();
                }
            }
            Method method = cls.getDeclaredMethod(methodName, types);
            return method.invoke(instance, args);
        }
        catch (ClassNotFoundException t) {
            Log.w((String)"Countly", (String)("Cannot call " + methodName + " of " + className), (Throwable)t);
            return false;
        }
        catch (NoSuchMethodException t) {
            Log.w((String)"Countly", (String)("Cannot call " + methodName + " of " + className), (Throwable)t);
            return false;
        }
        catch (IllegalAccessException t) {
            Log.w((String)"Countly", (String)("Cannot call " + methodName + " of " + className), (Throwable)t);
            return false;
        }
        catch (InvocationTargetException t) {
            Log.w((String)"Countly", (String)("Cannot call " + methodName + " of " + className), (Throwable)t);
            return false;
        }
    }

    static Object reflectiveCallStrict(String className, Object instance, String methodName, Object ... args) {
        return utils._reflectiveCallStrict(className, instance, methodName, args);
    }

    public Object _reflectiveCallStrict(String className, Object instance, String methodName, Object ... args) {
        try {
            Object[] arguments;
            Class<?> cls = instance == null ? Class.forName(className) : instance.getClass();
            Class[] types = args == null || args.length == 0 ? null : new Class[args.length / 2];
            Object[] objectArray = arguments = args == null || args.length == 0 ? null : new Object[args.length / 2];
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length; i += 2) {
                    types[i / 2] = (Class)args[i];
                    arguments[i / 2] = args[i + 1];
                }
            }
            Method method = cls.getDeclaredMethod(methodName, types);
            return method.invoke(instance, arguments);
        }
        catch (ClassNotFoundException t) {
            Log.w((String)"Countly", (String)("Cannot call " + methodName + " of " + className), (Throwable)t);
            return false;
        }
        catch (NoSuchMethodException t) {
            Log.w((String)"Countly", (String)("Cannot call " + methodName + " of " + className), (Throwable)t);
            return false;
        }
        catch (IllegalAccessException t) {
            Log.w((String)"Countly", (String)("Cannot call " + methodName + " of " + className), (Throwable)t);
            return false;
        }
        catch (InvocationTargetException t) {
            Log.w((String)"Countly", (String)("Cannot call " + methodName + " of " + className), (Throwable)t);
            return false;
        }
    }

    public static Boolean reflectiveSetField(Object object, String name, Object value) {
        return utils._reflectiveSetField(object, object.getClass(), name, value);
    }

    static Boolean reflectiveSetField(Class cls, String name, Object value) {
        return utils._reflectiveSetField(null, cls, name, value);
    }

    Boolean _reflectiveSetField(Object object, Class cls, String name, Object value) {
        try {
            Field field = Utils.findField(cls, name);
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            field.set(object, value);
            if (!accessible) {
                field.setAccessible(false);
            }
            return true;
        }
        catch (IllegalAccessException e) {
            Log.w((String)"Countly", (String)("Cannot access field " + name + " of " + cls), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            Log.w((String)"Countly", (String)("No field " + name + " in " + cls), (Throwable)e);
        }
        return false;
    }

    static <T> T reflectiveGetField(Object object, String name) {
        return utils._reflectiveGetField(object, object.getClass(), name);
    }

    static <T> T reflectiveGetField(Class cls, String name) {
        return utils._reflectiveGetField(null, cls, name);
    }

    <T> T _reflectiveGetField(Object object, Class cls, String name) {
        try {
            Field field = Utils.findField(cls, name);
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            Object value = field.get(object);
            if (!accessible) {
                field.setAccessible(false);
            }
            return (T)value;
        }
        catch (IllegalAccessException e) {
            Log.w((String)"Countly", (String)("Cannot access field " + name + " of " + object.getClass()), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            Log.w((String)"Countly", (String)("No field " + name + " in " + object.getClass()), (Throwable)e);
        }
        return null;
    }

    private static Field findField(Class cls, String name) throws NoSuchFieldException {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            if (cls.getSuperclass() == null) {
                throw e;
            }
            return Utils.findField(cls.getSuperclass(), name);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static boolean isNotEmpty(String str) {
        return !Utils.isEmpty(str);
    }

    public static boolean API(int version) {
        return Build.VERSION.SDK_INT >= version;
    }

    public static boolean isNotEqual(Object a, Object b) {
        return !Utils.isEqual(a, b);
    }

    public static boolean isEqual(Object a, Object b) {
        if (a == null || b == null || a == b) {
            return a == b;
        }
        return a.equals(b);
    }

    public static boolean contains(String string, String part) {
        if (string == null || part == null) {
            return false;
        }
        return string.contains(part);
    }

    public static String digestHex(String digestName, String string) {
        try {
            MessageDigest digest = MessageDigest.getInstance(digestName);
            byte[] bytes = string.getBytes(UTF8);
            digest.update(bytes, 0, bytes.length);
            return Utils.hex(digest.digest());
        }
        catch (Throwable e) {
            Log.e((String)"Countly", (String)("Cannot calculate sha1: " + e));
            return null;
        }
    }

    public static String hex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = BASE_16[v >>> 4];
            hexChars[j * 2 + 1] = BASE_16[v & 0xF];
        }
        return new String(hexChars).toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = stream.read(buffer)) != -1) {
                bytes.write(buffer, 0, len);
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            Log.e((String)"Countly", (String)("Couldn't read stream: " + e));
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                bytes.close();
                stream.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

