/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk.messaging;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.messaging.CountlyPush;
import org.json.JSONArray;
import org.json.JSONObject;

class ModulePush {
    static final String PUSH_EVENT_ACTION = "[CLY]_push_action";
    static final String PUSH_EVENT_ACTION_ID_KEY = "i";
    static final String PUSH_EVENT_ACTION_INDEX_KEY = "b";
    static final String KEY_ID = "c.i";
    static final String KEY_TITLE = "title";
    static final String KEY_MESSAGE = "message";
    static final String KEY_SOUND = "sound";
    static final String KEY_BADGE = "badge";
    static final String KEY_LINK = "c.l";
    static final String KEY_MEDIA = "c.m";
    static final String KEY_BUTTONS = "c.b";
    static final String KEY_BUTTONS_TITLE = "t";
    static final String KEY_BUTTONS_LINK = "l";

    ModulePush() {
    }

    static class MessageImpl
    implements CountlyPush.Message {
        final String id;
        private final String title;
        private final String message;
        private final String sound;
        private final Integer badge;
        private final URL link;
        private final URL media;
        private final List<CountlyPush.Button> buttons;
        private final Map<String, String> data;
        public static final Parcelable.Creator<MessageImpl> CREATOR = new Parcelable.Creator<MessageImpl>(){

            public MessageImpl createFromParcel(Parcel in) {
                HashMap<String, String> map = new HashMap<String, String>();
                in.readMap(map, ClassLoader.getSystemClassLoader());
                Log.d((String)"Countly", (String)("read: " + (String)map.get(ModulePush.KEY_ID)));
                return new MessageImpl(map);
            }

            public MessageImpl[] newArray(int size) {
                return new MessageImpl[size];
            }
        };

        MessageImpl(Map<String, String> data) {
            this.data = data;
            this.id = data.get(ModulePush.KEY_ID);
            this.title = data.get(ModulePush.KEY_TITLE);
            this.message = data.get(ModulePush.KEY_MESSAGE);
            this.sound = data.get(ModulePush.KEY_SOUND);
            Log.d((String)"Countly", (String)("constructed: " + this.id));
            Integer b = null;
            try {
                b = data.containsKey(ModulePush.KEY_BADGE) ? Integer.valueOf(Integer.parseInt(data.get(ModulePush.KEY_BADGE))) : null;
            }
            catch (NumberFormatException e) {
                Log.w((String)"Countly", (String)"Bad badge value received, ignoring");
            }
            this.badge = b;
            URL u = null;
            try {
                u = data.containsKey(ModulePush.KEY_LINK) ? new URL(data.get(ModulePush.KEY_LINK)) : null;
            }
            catch (MalformedURLException e) {
                Log.w((String)"Countly", (String)"Bad link value received, ignoring");
            }
            this.link = u;
            u = null;
            try {
                u = data.containsKey(ModulePush.KEY_MEDIA) ? new URL(data.get(ModulePush.KEY_MEDIA)) : null;
            }
            catch (MalformedURLException e) {
                Log.w((String)"Countly", (String)"Bad media value received, ignoring");
            }
            this.media = u;
            this.buttons = new ArrayList<CountlyPush.Button>();
            String json = data.get(ModulePush.KEY_BUTTONS);
            if (json != null) {
                try {
                    JSONArray array = new JSONArray(json);
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject btn = array.getJSONObject(i);
                        if (!btn.has(ModulePush.KEY_BUTTONS_TITLE) || !btn.has(ModulePush.KEY_BUTTONS_LINK)) continue;
                        u = null;
                        try {
                            u = new URL(btn.getString(ModulePush.KEY_BUTTONS_LINK));
                        }
                        catch (MalformedURLException e) {
                            Log.w((String)"Countly", (String)"Bad button link value received, ignoring");
                        }
                        if (u == null) continue;
                        this.buttons.add(new Button(this, i + 1, btn.getString(ModulePush.KEY_BUTTONS_TITLE), u));
                    }
                }
                catch (Throwable e) {
                    Log.w((String)"Countly", (String)"Failed to parse buttons JSON", (Throwable)e);
                }
            }
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public String sound() {
            return this.sound;
        }

        @Override
        public Integer badge() {
            return this.badge;
        }

        @Override
        public URL link() {
            return this.link;
        }

        @Override
        public URL media() {
            return this.media;
        }

        @Override
        public List<CountlyPush.Button> buttons() {
            return this.buttons;
        }

        @Override
        public Set<String> dataKeys() {
            return this.data.keySet();
        }

        @Override
        public boolean has(String key) {
            return this.data.containsKey(key);
        }

        @Override
        public String data(String key) {
            return this.data.get(key);
        }

        @Override
        public void recordAction(Context context) {
            this.recordAction(context, 0);
        }

        @Override
        public void recordAction(Context context, int buttonIndex) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(ModulePush.PUSH_EVENT_ACTION_ID_KEY, this.id);
            map.put(ModulePush.PUSH_EVENT_ACTION_INDEX_KEY, String.valueOf(buttonIndex));
            Countly.sharedInstance().recordEvent(ModulePush.PUSH_EVENT_ACTION, map, 1);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public int describeContents() {
            return this.id.hashCode();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeMap(this.data);
            Log.d((String)"Countly", (String)("written: " + this.data.get(ModulePush.KEY_ID)));
        }

        static class Button
        implements CountlyPush.Button {
            private final CountlyPush.Message message;
            private final int index;
            private final int icon;
            private final String title;
            private final URL link;

            Button(CountlyPush.Message message, int index, String title, URL link) {
                this.message = message;
                this.index = index;
                this.title = title;
                this.link = link;
                this.icon = 0;
            }

            Button(CountlyPush.Message message, int index, String title, URL link, int icon) {
                this.message = message;
                this.index = index;
                this.title = title;
                this.link = link;
                this.icon = icon;
            }

            @Override
            public int index() {
                return this.index;
            }

            @Override
            public String title() {
                return this.title;
            }

            @Override
            public URL link() {
                return this.link;
            }

            @Override
            public void recordAction(Context context) {
                this.message.recordAction(context, this.index);
            }

            @Override
            public int icon() {
                return this.icon;
            }

            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof Button)) {
                    return false;
                }
                Button b = (Button)obj;
                return b.index == this.index && (b.title == null ? this.title == null : b.title.equals(this.title)) && (b.link == null ? this.link == null : b.link.equals(this.link) && b.icon == this.icon);
            }
        }
    }
}

