/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk.messaging;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.Application;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.messaging.ModulePush;
import ly.count.android.sdk.messaging.Utils;

public class CountlyPush {
    public static final String EXTRA_ACTION_INDEX = "ly.count.android.sdk.CountlyPush.Action";
    public static final String EXTRA_MESSAGE = "ly.count.android.sdk.CountlyPush.message";
    public static final String EXTRA_INTENT = "ly.count.android.sdk.CountlyPush.intent";
    public static final String CHANNEL_ID = "ly.count.android.sdk.CountlyPush.CHANNEL_ID";
    public static final String NOTIFICATION_BROADCAST = "ly.count.android.sdk.CountlyPush.NOTIFICATION_BROADCAST";
    private static Application.ActivityLifecycleCallbacks callbacks = null;
    private static Activity activity = null;
    private static Countly.CountlyMessagingMode mode = null;
    private static BroadcastReceiver notificationActionReceiver = null;
    private static BroadcastReceiver consentReceiver = null;
    static final String FIREBASE_MESSAGING_CLASS = "com.google.firebase.messaging.FirebaseMessaging";
    static final String FIREBASE_INSTANCEID_CLASS = "com.google.firebase.iid.FirebaseInstanceId";

    private static String getToken() {
        try {
            Object instance = Utils.reflectiveCall(FIREBASE_INSTANCEID_CLASS, null, "getInstance", new Object[0]);
            return (String)Utils.reflectiveCall(FIREBASE_INSTANCEID_CLASS, instance, "getToken", new Object[0]);
        }
        catch (Throwable logged) {
            Log.e((String)"Countly", (String)"Couldn't get token for Countly FCM", (Throwable)logged);
            return null;
        }
    }

    public static Boolean displayMessage(Context context, Map<String, String> data, int notificationSmallIcon, Intent notificationIntent) {
        return CountlyPush.displayMessage(context, CountlyPush.decodeMessage(data), notificationSmallIcon, notificationIntent);
    }

    public static Boolean displayMessage(Context context, Message msg, int notificationSmallIcon, Intent notificationIntent) {
        if (msg == null) {
            return null;
        }
        if (CountlyPush.isAppRunningInForeground(context)) {
            if (activity != null) {
                return CountlyPush.displayDialog(activity, msg);
            }
            return CountlyPush.displayNotification(context, msg, notificationSmallIcon, notificationIntent);
        }
        return CountlyPush.displayNotification(context, msg, notificationSmallIcon, notificationIntent);
    }

    public static Boolean displayNotification(Context context, final Message msg, int notificationSmallIcon, Intent notificationIntent) {
        if (!Countly.sharedInstance().getConsent("push")) {
            return null;
        }
        if (msg.title() == null && msg.message() == null) {
            return null;
        }
        final NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        if (manager == null) {
            return Boolean.FALSE;
        }
        Intent broadcast = new Intent(NOTIFICATION_BROADCAST);
        broadcast.putExtra(EXTRA_INTENT, (Parcelable)CountlyPush.actionIntent(context, notificationIntent, msg, 0));
        final Notification.Builder builder = (Build.VERSION.SDK_INT >= 26 ? new Notification.Builder(context.getApplicationContext(), CHANNEL_ID) : new Notification.Builder(context.getApplicationContext())).setAutoCancel(true).setSmallIcon(notificationSmallIcon).setTicker((CharSequence)msg.message()).setContentTitle((CharSequence)msg.title()).setContentText((CharSequence)msg.message()).setAutoCancel(true).setContentIntent(PendingIntent.getBroadcast((Context)context, (int)msg.hashCode(), (Intent)broadcast, (int)0)).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)msg.message()).setBigContentTitle((CharSequence)msg.title()));
        for (int i = 0; i < msg.buttons().size(); ++i) {
            Button button = msg.buttons().get(i);
            broadcast = new Intent(NOTIFICATION_BROADCAST);
            broadcast.putExtra(EXTRA_INTENT, (Parcelable)CountlyPush.actionIntent(context, notificationIntent, msg, i + 1));
            builder.addAction(button.icon(), (CharSequence)button.title(), PendingIntent.getBroadcast((Context)context, (int)(msg.hashCode() + i + 1), (Intent)broadcast, (int)0));
        }
        if (msg.sound() != null) {
            if (msg.sound().equals("default")) {
                builder.setDefaults(1);
            } else {
                builder.setSound(Uri.parse((String)msg.sound()));
            }
        }
        if (msg.media() != null) {
            CountlyPush.loadImage(context, msg, new BitmapCallback(){

                @Override
                public void call(Bitmap bitmap) {
                    if (bitmap != null) {
                        builder.setStyle((Notification.Style)new Notification.BigPictureStyle().bigPicture(bitmap).setBigContentTitle((CharSequence)msg.title()).setSummaryText((CharSequence)msg.message()));
                    }
                    manager.notify(msg.hashCode(), builder.build());
                }
            });
        } else {
            manager.notify(msg.hashCode(), builder.build());
        }
        return Boolean.TRUE;
    }

    private static Intent actionIntent(Context context, Intent notificationIntent, Message message, int index) {
        Intent intent = notificationIntent == null ? context.getPackageManager().getLaunchIntentForPackage(context.getPackageName()) : (Intent)notificationIntent.clone();
        intent.putExtra(EXTRA_MESSAGE, (Parcelable)message);
        intent.putExtra(EXTRA_ACTION_INDEX, index);
        return intent;
    }

    public static Boolean displayDialog(final Activity activity, final Message msg) {
        if (!Countly.sharedInstance().getConsent("push")) {
            return null;
        }
        CountlyPush.loadImage((Context)activity, msg, new BitmapCallback(){

            @Override
            public void call(Bitmap bitmap) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                if (msg.media() != null) {
                    TextView textview;
                    CountlyPush.addButtons((Context)activity, builder, msg);
                    LinearLayout layout = new LinearLayout((Context)activity);
                    layout.setBackgroundColor(0);
                    layout.setOrientation(1);
                    int padding = (int)(10.0f * activity.getResources().getDisplayMetrics().density + 0.5f);
                    if (msg.title() != null) {
                        textview = new TextView((Context)activity);
                        textview.setText((CharSequence)msg.title());
                        textview.setPadding(padding, padding, padding, padding);
                        textview.setTypeface(null, 1);
                        textview.setGravity(17);
                        layout.addView((View)textview);
                    }
                    if (bitmap != null) {
                        ImageView imageView = new ImageView((Context)activity);
                        imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 48));
                        if (msg.media() != null) {
                            imageView.setImageBitmap(bitmap);
                        }
                        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        imageView.setAdjustViewBounds(true);
                        imageView.setPadding(padding, padding, padding, padding);
                        layout.addView((View)imageView);
                    }
                    if (msg.message() != null) {
                        textview = new TextView((Context)activity);
                        textview.setText((CharSequence)msg.message());
                        textview.setPadding(padding, padding, padding, padding);
                        layout.addView((View)textview);
                    }
                    builder.setView((View)layout);
                } else if (msg.link() != null) {
                    if (msg.title() != null) {
                        builder.setTitle((CharSequence)msg.title());
                    }
                    if (msg.message() != null) {
                        builder.setMessage((CharSequence)msg.message());
                    }
                    if (msg.buttons().size() > 0) {
                        CountlyPush.addButtons((Context)activity, builder, msg);
                    } else {
                        builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                msg.recordAction((Context)activity, 0);
                                dialog.dismiss();
                            }
                        });
                    }
                } else if (msg.message() != null) {
                    if (msg.buttons().size() > 0) {
                        CountlyPush.addButtons((Context)activity, builder, msg);
                    } else {
                        msg.recordAction((Context)activity);
                    }
                    builder.setTitle((CharSequence)msg.title());
                    builder.setMessage((CharSequence)msg.message());
                    builder.setCancelable(true);
                    builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog) {
                            dialog.dismiss();
                        }
                    });
                } else {
                    throw new IllegalStateException("Countly Message with UNKNOWN type in ProxyActivity");
                }
                builder.create().show();
            }
        });
        return Boolean.TRUE;
    }

    public static void addButtons(final Context context, AlertDialog.Builder builder, final Message msg) {
        if (msg.buttons().size() > 0) {
            DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    msg.recordAction(context, which == -1 ? 1 : 2);
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)msg.buttons().get(which == -1 ? 0 : 1).link().toString()));
                    intent.putExtra(CountlyPush.EXTRA_MESSAGE, (Parcelable)msg);
                    intent.putExtra(CountlyPush.EXTRA_ACTION_INDEX, which == -1 ? 1 : 2);
                    context.startActivity(intent);
                    dialog.dismiss();
                }
            };
            builder.setPositiveButton((CharSequence)msg.buttons().get(0).title(), listener);
            if (msg.buttons().size() > 1) {
                builder.setNeutralButton((CharSequence)msg.buttons().get(1).title(), listener);
            }
        }
    }

    public static Message decodeMessage(Map<String, String> data) {
        ModulePush.MessageImpl message = new ModulePush.MessageImpl(data);
        return message.id == null ? null : message;
    }

    public static void onTokenRefresh(String token) {
        if (!Countly.sharedInstance().getConsent("push")) {
            return;
        }
        Countly.sharedInstance().onRegistrationId(token, mode);
    }

    public static void init(Application application, Countly.CountlyMessagingMode mode) throws IllegalStateException {
        if (!Utils.reflectiveClassExists(FIREBASE_MESSAGING_CLASS)) {
            throw new IllegalStateException("No FirebaseMessaging library in class path. Please either add it to your gradle config or don't use CountlyPush.");
        }
        CountlyPush.mode = mode;
        if (callbacks == null) {
            callbacks = new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                    activity = activity;
                }

                public void onActivityResumed(Activity activity) {
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityStopped(Activity activity) {
                    activity = null;
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
            application.registerActivityLifecycleCallbacks(callbacks);
            IntentFilter filter = new IntentFilter();
            filter.addAction(NOTIFICATION_BROADCAST);
            notificationActionReceiver = new NotificationBroadcastReceiver();
            application.registerReceiver(notificationActionReceiver, filter);
            filter = new IntentFilter();
            filter.addAction("ly.count.android.sdk.Countly.CONSENT_BROADCAST");
            consentReceiver = new ConsentBroadcastReceiver();
            application.registerReceiver(consentReceiver, filter);
        }
    }

    public static boolean isAppRunningInForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        String packageName = context.getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private static void loadImage(final Context context, final Message msg, final BitmapCallback callback) {
        new AsyncTask<Void, Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground(Void ... voids) {
                final Bitmap[] bitmap = new Bitmap[]{null};
                if (msg.media() != null) {
                    HttpURLConnection connection = null;
                    InputStream input = null;
                    try {
                        int read;
                        connection = (HttpURLConnection)msg.media().openConnection();
                        connection.setDoInput(true);
                        connection.setConnectTimeout(15000);
                        connection.setReadTimeout(15000);
                        connection.connect();
                        input = connection.getInputStream();
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        byte[] buf = new byte[16384];
                        while ((read = input.read(buf, 0, buf.length)) != -1) {
                            bytes.write(buf, 0, read);
                        }
                        bytes.flush();
                        byte[] data = bytes.toByteArray();
                        bitmap[0] = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    }
                    catch (Exception e) {
                        System.out.println("Cannot download message media " + e);
                        bitmap[0] = null;
                    }
                    finally {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (connection != null) {
                            try {
                                connection.disconnect();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                new Handler(context.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        callback.call(bitmap[0]);
                    }
                });
                return null;
            }
        }.doInBackground(new Void[0]);
    }

    private static interface BitmapCallback {
        public void call(Bitmap var1);
    }

    public static class ConsentBroadcastReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent broadcast) {
            String token;
            if (mode != null && Countly.sharedInstance().getConsent("push") && (token = CountlyPush.getToken()) != null) {
                CountlyPush.onTokenRefresh(CountlyPush.getToken());
            }
        }
    }

    public static class NotificationBroadcastReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent broadcast) {
            broadcast.setExtrasClassLoader(CountlyPush.class.getClassLoader());
            Intent intent = (Intent)broadcast.getParcelableExtra(CountlyPush.EXTRA_INTENT);
            intent.setExtrasClassLoader(CountlyPush.class.getClassLoader());
            int index = intent.getIntExtra(CountlyPush.EXTRA_ACTION_INDEX, 0);
            Message message = (Message)intent.getParcelableExtra(CountlyPush.EXTRA_MESSAGE);
            message.recordAction(context, index);
            if (index == 0) {
                if (message.link() != null) {
                    Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)message.link().toString()));
                    i.putExtra(CountlyPush.EXTRA_MESSAGE, (Parcelable)i);
                    i.putExtra(CountlyPush.EXTRA_ACTION_INDEX, index);
                    context.startActivity(i);
                } else {
                    context.startActivity(intent);
                }
            } else {
                Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)message.buttons().get(index - 1).link().toString()));
                i.putExtra(CountlyPush.EXTRA_MESSAGE, (Parcelable)i);
                i.putExtra(CountlyPush.EXTRA_ACTION_INDEX, index);
                context.startActivity(i);
            }
        }
    }

    public static interface Button {
        public int index();

        public String title();

        public URL link();

        public void recordAction(Context var1);

        public int icon();
    }

    public static interface Message
    extends Parcelable {
        public String id();

        public String title();

        public String message();

        public String sound();

        public Integer badge();

        public URL link();

        public URL media();

        public List<Button> buttons();

        public Set<String> dataKeys();

        public boolean has(String var1);

        public String data(String var1);

        public void recordAction(Context var1);

        public void recordAction(Context var1, int var2);
    }
}

