/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk.messaging;

import android.app.ActivityManager;
import android.app.IntentService;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import java.util.List;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.messaging.CountlyMessaging;
import ly.count.android.sdk.messaging.Message;
import ly.count.android.sdk.messaging.ProxyActivity;

public class CountlyMessagingService
extends IntentService {
    public static final String TAG = "CountlyMessagingService";
    public static final int NOTIFICATION_ID = 736192;

    public CountlyMessagingService() {
        super(TAG);
    }

    protected void onHandleIntent(final Intent intent) {
        Message msg;
        Log.i((String)TAG, (String)"Handling intent");
        Bundle extras = intent.getExtras();
        GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)this.getApplicationContext());
        String messageType = gcm.getMessageType(intent);
        if (extras != null && !extras.isEmpty() && "gcm".equals(messageType) && (msg = new Message(extras)).isValid()) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.i((String)TAG, (String)("Got a message from Countly Messaging: " + msg));
            }
            Intent broadcast = new Intent(CountlyMessaging.getBroadcastAction(this.getApplicationContext()));
            broadcast.putExtra("ly.count.android.api.messaging.broadcast.message", (Parcelable)msg);
            this.sendBroadcast(broadcast);
            msg.prepare(new Runnable(){

                @Override
                public void run() {
                    if (!Countly.sharedInstance().isInitialized() && !CountlyMessaging.initCountly(CountlyMessagingService.this.getApplicationContext())) {
                        Log.e((String)CountlyMessagingService.TAG, (String)"Cannot init Countly in background");
                    }
                    if (CountlyMessaging.isUIDisabled((Context)CountlyMessagingService.this)) {
                        Log.i((String)CountlyMessagingService.TAG, (String)"Won't do anything since Countly Messaging UI is disabled");
                        CountlyMessaging.completeWakefulIntent((Intent)intent);
                        return;
                    }
                    if (!msg.isSilent() && msg.hasMessage()) {
                        Intent proxy = new Intent(CountlyMessagingService.this.getApplicationContext(), ProxyActivity.class);
                        proxy.putExtra("ly.count.android.api.messaging.message", (Parcelable)msg);
                        CountlyMessagingService.this.notify(proxy);
                    }
                }
            });
        }
        CountlyMessaging.completeWakefulIntent((Intent)intent);
    }

    protected void notify(Intent proxy) {
        Message msg = (Message)proxy.getParcelableExtra("ly.count.android.api.messaging.message");
        if (CountlyMessagingService.isAppInForeground((Context)this)) {
            proxy.putExtra("ly.count.android.api.messaging.dialog", true);
            proxy.setFlags(0x10000000);
            this.startActivity(proxy);
        } else {
            Bitmap iconBitmap;
            int smallIcon;
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            PendingIntent contentIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)proxy, (int)0x8000000);
            int iconOverride = CountlyMessaging.getIconOverride((Context)this);
            try {
                smallIcon = iconOverride > 0 ? iconOverride : this.getPackageManager().getApplicationInfo((String)this.getPackageName(), (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException e) {
                smallIcon = 17301545;
            }
            int largeIcon = CountlyMessaging.getLargeIconId((Context)this);
            int notificationColor = CountlyMessaging.getAccentColor((Context)this);
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.getApplicationContext()).setAutoCancel(true).setSmallIcon(smallIcon).setTicker((CharSequence)msg.getNotificationMessage()).setContentTitle((CharSequence)msg.getNotificationTitle(this.getApplicationContext())).setContentText((CharSequence)msg.getNotificationMessage()).setContentIntent(contentIntent).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)msg.getNotificationMessage()).setBigContentTitle((CharSequence)msg.getNotificationTitle(this.getApplicationContext())));
            if (largeIcon > 0 && (iconBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)largeIcon)) != null) {
                builder.setLargeIcon(iconBitmap);
            }
            if (notificationColor > 0) {
                builder.setColor(notificationColor);
            }
            if (msg.hasMedia() && Message.getFromStore(msg.getMedia()) != null) {
                builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture((Bitmap)Message.getFromStore(msg.getMedia())).setBigContentTitle((CharSequence)msg.getNotificationTitle(this.getApplicationContext())).setSummaryText((CharSequence)msg.getNotificationMessage()));
            }
            for (Message.Button button : msg.getButtons()) {
                Log.d((String)"Countly", (String)(button.index + " " + button.link));
                Intent actionIntent = (Intent)proxy.clone();
                actionIntent.putExtra("ly.count.android.api.messaging.action.index", button.index);
                builder.addAction(0, (CharSequence)button.title, PendingIntent.getActivity((Context)this.getApplicationContext(), (int)button.index, (Intent)actionIntent, (int)0x8000000));
            }
            if (msg.hasSoundDefault()) {
                builder.setDefaults(1);
            } else if (msg.hasSoundUri()) {
                builder.setSound(Uri.parse((String)msg.getSoundUri()));
            }
            manager.notify(msg.getId().hashCode(), builder.build());
        }
    }

    private static boolean isAppInForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        String packageName = context.getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
            return true;
        }
        return false;
    }
}

