/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk.messaging;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import ly.count.android.sdk.messaging.CountlyMessaging;
import ly.count.android.sdk.messaging.Message;

public class ProxyActivity
extends Activity {
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
    }

    protected void onStart() {
        Message msg;
        super.onStart();
        Bundle extras = this.getIntent().getExtras();
        if (extras != null && (msg = (Message)extras.getParcelable("ly.count.android.api.messaging.message")) != null) {
            if (extras.containsKey("ly.count.android.api.messaging.dialog")) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setTitle((CharSequence)msg.getNotificationTitle((Context)this));
                builder.setCancelable(true).setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        ProxyActivity.this.finish();
                    }
                });
                if (msg.hasMedia()) {
                    this.addButtons(builder, msg);
                    LinearLayout layout = new LinearLayout((Context)this);
                    layout.setBackgroundColor(0);
                    layout.setOrientation(1);
                    ImageView imageView = new ImageView((Context)this);
                    imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 48));
                    if (msg.hasMedia() && Message.getFromStore(msg.getMedia()) != null) {
                        imageView.setImageBitmap((Bitmap)Message.getFromStore(msg.getMedia()));
                    }
                    imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                    imageView.setAdjustViewBounds(true);
                    layout.addView((View)imageView);
                    if (msg.hasMessage()) {
                        int padding = (int)(10.0f * this.getResources().getDisplayMetrics().density + 0.5f);
                        TextView textview = new TextView((Context)this);
                        textview.setText((CharSequence)msg.getMessage());
                        textview.setPadding(padding, padding, padding, padding);
                        layout.addView((View)textview);
                    }
                    builder.setView((View)layout);
                } else if (msg.hasLink()) {
                    if (msg.hasMessage()) {
                        builder.setMessage((CharSequence)msg.getNotificationMessage());
                    }
                    if (msg.hasButtons()) {
                        this.addButtons(builder, msg);
                    } else {
                        builder.setPositiveButton((CharSequence)CountlyMessaging.buttonNames[0], new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                CountlyMessaging.recordMessageAction(msg.getId(), 0);
                                ProxyActivity.this.finish();
                                Intent activity = msg.getIntent((Context)ProxyActivity.this, CountlyMessaging.getActivityClass((Context)ProxyActivity.this));
                                if (activity != null) {
                                    ProxyActivity.this.startActivity(activity);
                                }
                            }
                        });
                    }
                } else if (msg.hasMessage()) {
                    if (msg.hasButtons()) {
                        this.addButtons(builder, msg);
                    } else {
                        CountlyMessaging.recordMessageAction(msg.getId());
                    }
                    builder.setMessage((CharSequence)msg.getNotificationMessage());
                    builder.setCancelable(true);
                    builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog) {
                            ProxyActivity.this.finish();
                        }
                    });
                } else {
                    throw new IllegalStateException("Countly Message with UNKNOWN type in ProxyActivity");
                }
                builder.create().show();
            } else {
                Intent activity = msg.getIntent((Context)this, CountlyMessaging.getActivityClass((Context)this));
                if (activity != null) {
                    this.startActivity(activity);
                } else {
                    Log.e((String)"Countly", (String)"Countly Message with UNKNOWN type in ProxyActivity");
                }
                if (extras.containsKey("ly.count.android.api.messaging.action.index")) {
                    CountlyMessaging.recordMessageAction(msg.getId(), extras.getInt("ly.count.android.api.messaging.action.index"));
                    for (Message.Button button : msg.getButtons()) {
                        if (button.index != extras.getInt("ly.count.android.api.messaging.action.index")) continue;
                        this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)button.link)));
                        break;
                    }
                } else {
                    CountlyMessaging.recordMessageAction(msg.getId(), 0);
                    if (msg.hasLink()) {
                        this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)msg.getLink())));
                    }
                }
                this.finish();
                NotificationManager manager = (NotificationManager)this.getSystemService("notification");
                manager.cancel(msg.getId().hashCode());
            }
        }
    }

    private void addButtons(AlertDialog.Builder builder, final Message msg) {
        if (msg.hasButtons()) {
            DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    CountlyMessaging.recordMessageAction(msg.getId(), which == -1 ? 1 : 2);
                    ProxyActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)msg.getButtons().get((int)(which == -1 ? 0 : 1)).link)));
                    ProxyActivity.this.finish();
                }
            };
            builder.setPositiveButton((CharSequence)msg.getButtons().get((int)0).title, listener);
            if (msg.getButtons().size() > 1) {
                builder.setNeutralButton((CharSequence)msg.getButtons().get((int)1).title, listener);
            }
        }
    }

    protected void onStop() {
        super.onStop();
    }
}

