/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk.messaging;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ly.count.android.sdk.messaging.CountlyMessaging;
import org.json.JSONArray;
import org.json.JSONObject;

public class Message
implements Parcelable {
    private static final String TAG = "Countly|Message";
    private Bundle data;
    private int type;
    private List<Button> buttons;
    private static Map<String, Object> dataStore = new HashMap<String, Object>();
    public static final Parcelable.Creator<Message> CREATOR = new Parcelable.Creator<Message>(){

        public Message createFromParcel(Parcel in) {
            return new Message(in);
        }

        public Message[] newArray(int size) {
            return new Message[size];
        }
    };

    public Message(Bundle data) {
        this.data = data;
        this.readButtons();
        this.type = this.setType();
    }

    private void readButtons() {
        this.buttons = new ArrayList<Button>();
        String json = this.data.getString("c.b");
        if (json != null) {
            try {
                JSONArray array = new JSONArray(json);
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject btn = array.getJSONObject(i);
                    if (!btn.has("t") || !btn.has("l")) continue;
                    Button button = new Button();
                    button.index = i + 1;
                    button.title = btn.getString("t");
                    button.link = btn.getString("l");
                    this.buttons.add(button);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public String getId() {
        return this.data.getString("c.i");
    }

    public String getLink() {
        return this.data.getString("c.l");
    }

    public String getMessage() {
        return this.data.getString("message");
    }

    public String getTitle() {
        return this.data.getString("title");
    }

    public String getMedia() {
        return this.data.getString("c.m");
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public String getSoundUri() {
        return this.data.getString("sound");
    }

    public Bundle getData() {
        return this.data;
    }

    public int getType() {
        return this.type;
    }

    private int setType() {
        int t = 0;
        if (this.getMessage() != null && !"".equals(this.getMessage())) {
            t |= 1;
        }
        if (this.getTitle() != null && !"".equals(this.getTitle())) {
            t |= 0x40;
        }
        if (this.getMedia() != null && !"".equals(this.getMedia())) {
            t |= 0x80;
        }
        if (this.getButtons() != null && this.getButtons().size() > 0) {
            t |= 0x100;
        }
        if (this.getLink() != null && !"".equals(this.getLink())) {
            t |= 2;
        }
        if ("true".equals(this.data.getString("c.s"))) {
            t |= 8;
        }
        if (this.getSoundUri() != null && !"".equals(this.getSoundUri())) {
            t = "default".equals(this.getSoundUri()) ? (t |= 0x10) : (t |= 0x20);
        }
        return t;
    }

    public boolean hasLink() {
        return (this.type & 2) > 0;
    }

    public boolean hasMessage() {
        return (this.type & 1) > 0;
    }

    public boolean hasTitle() {
        return (this.type & 0x40) > 0;
    }

    public boolean hasMedia() {
        return (this.type & 0x80) > 0;
    }

    public boolean hasButtons() {
        return (this.type & 0x100) > 0;
    }

    public boolean isSilent() {
        return (this.type & 8) > 0;
    }

    public boolean hasSoundUri() {
        return (this.type & 0x20) > 0;
    }

    public boolean hasSoundDefault() {
        return (this.type & 0x10) > 0;
    }

    public boolean isUnknown() {
        return this.type == 0;
    }

    public boolean isValid() {
        String id = this.data.getString("c.i");
        return !this.isUnknown() && id != null && id.length() == 24;
    }

    public Intent getIntent(Context context, Class<? extends Activity> activityClass) {
        if (this.hasLink()) {
            return new Intent("android.intent.action.VIEW", Uri.parse((String)this.getLink()));
        }
        if (this.hasMessage()) {
            if (activityClass == null) {
                activityClass = CountlyMessaging.getMainActivityClass(context);
            }
            if (activityClass != null) {
                Intent intent = new Intent(context, activityClass);
                intent.setFlags(0x20000000);
                return intent;
            }
        }
        return null;
    }

    public String getNotificationTitle(Context context) {
        return this.hasTitle() ? this.getTitle() : CountlyMessaging.getAppTitle(context);
    }

    public String getNotificationMessage() {
        if (this.hasLink()) {
            return this.hasMessage() ? this.getMessage() : "";
        }
        if (this.hasMessage()) {
            return this.getMessage();
        }
        return null;
    }

    public String toString() {
        return this.data == null ? "empty" : this.data.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.data);
    }

    Message(Parcel in) {
        this.data = in.readBundle(this.getClass().getClassLoader());
        this.readButtons();
        this.type = this.setType();
    }

    void prepare(final Runnable callback) {
        if (this.hasMedia()) {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    try {
                        URL url = new URL(Message.this.getMedia());
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setDoInput(true);
                        connection.connect();
                        InputStream input = connection.getInputStream();
                        dataStore.put(Message.this.getMedia(), BitmapFactory.decodeStream((InputStream)input));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    callback.run();
                    return null;
                }
            }.doInBackground(new Void[0]);
        } else {
            callback.run();
        }
    }

    static Object getFromStore(String key) {
        return dataStore.get(key);
    }

    static Object removeFromStore(String key) {
        return dataStore.remove(key);
    }

    static final class Button {
        int index;
        String title;
        String link;

        Button() {
        }
    }
}

