/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk.messaging;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import ly.count.android.sdk.messaging.CountlyMessaging;
import ly.count.android.sdk.messaging.Message;

public class ProxyActivity
extends Activity {
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
    }

    protected void onStart() {
        Message msg;
        super.onStart();
        Bundle extras = this.getIntent().getExtras();
        if (extras != null && (msg = (Message)extras.getParcelable("ly.count.android.api.messaging.message")) != null) {
            if (extras.containsKey("ly.count.android.api.messaging.dialog")) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setTitle((CharSequence)msg.getNotificationTitle((Context)this)).setMessage((CharSequence)msg.getNotificationMessage());
                if (msg.hasLink()) {
                    builder.setCancelable(true).setPositiveButton((CharSequence)CountlyMessaging.buttonNames[0], new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            CountlyMessaging.recordMessageAction(msg.getId());
                            ProxyActivity.this.finish();
                            Intent activity = msg.getIntent((Context)ProxyActivity.this, CountlyMessaging.getActivityClass((Context)ProxyActivity.this));
                            if (activity != null) {
                                ProxyActivity.this.startActivity(activity);
                            }
                        }
                    }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog) {
                            ProxyActivity.this.finish();
                        }
                    });
                } else if (msg.hasMessage()) {
                    CountlyMessaging.recordMessageAction(msg.getId());
                    builder.setCancelable(true);
                    builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog) {
                            ProxyActivity.this.finish();
                        }
                    });
                } else {
                    throw new IllegalStateException("Countly Message with UNKNOWN type in ProxyActivity");
                }
                builder.create().show();
            } else {
                CountlyMessaging.recordMessageAction(msg.getId());
                Intent activity = msg.getIntent((Context)this, CountlyMessaging.getActivityClass((Context)this));
                if (activity != null) {
                    this.startActivity(activity);
                } else {
                    Log.e((String)"Countly", (String)"Countly Message with UNKNOWN type in ProxyActivity");
                }
            }
        }
    }

    protected void onStop() {
        super.onStop();
    }
}

