/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk.messaging;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import java.io.IOException;
import java.util.HashMap;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.DeviceId;
import ly.count.android.sdk.messaging.CountlyMessagingService;

public class CountlyMessaging
extends WakefulBroadcastReceiver {
    private static final String TAG = "CountlyMessaging";
    protected static final String NOTIFICATION_SHOW_DIALOG = "ly.count.android.api.messaging.dialog";
    protected static final String EXTRA_MESSAGE = "ly.count.android.api.messaging.message";
    protected static final String EVENT_OPEN = "[CLY]_push_open";
    protected static final String EVENT_ACTION = "[CLY]_push_action";
    protected static String[] buttonNames = new String[]{"Open", "Review"};
    protected static final int NOTIFICATION_TYPE_UNKNOWN = 0;
    protected static final int NOTIFICATION_TYPE_MESSAGE = 1;
    protected static final int NOTIFICATION_TYPE_URL = 2;
    protected static final int NOTIFICATION_TYPE_REVIEW = 4;
    protected static final int NOTIFICATION_TYPE_SILENT = 8;
    protected static final int NOTIFICATION_TYPE_SOUND_DEFAULT = 16;
    protected static final int NOTIFICATION_TYPE_SOUND_URI = 32;
    public static String BROADCAST_RECEIVER_ACTION_MESSAGE = "ly.count.android.api.messaging.broadcast.message";
    private static Context context;
    private static Class<? extends Activity> activityClass;
    private static final String PREFERENCES_NAME = "ly.count.android.api.messaging";
    private static final String PROPERTY_REGISTRATION_ID = "ly.count.android.api.messaging.registration.id";
    private static final String PROPERTY_REGISTRATION_VERSION = "ly.count.android.api.messaging.version";
    private static final String PROPERTY_REGISTRATION_SENDER = "ly.count.android.api.messaging.sender";
    private static final String PROPERTY_APPLICATION_TITLE = "ly.count.android.api.messaging.app.title";
    private static final String PROPERTY_SERVER_URL = "ly.count.android.api.messaging.server.url";
    private static final String PROPERTY_APP_KEY = "ly.count.android.api.messaging.app.key";
    private static final String PROPERTY_DEVICE_ID = "ly.count.android.api.messaging.device.id";
    private static final String PROPERTY_DEVICE_ID_MODE = "ly.count.android.api.messaging.device.id.mode";
    private static final String PROPERTY_ACTIVITY_CLASS = "ly.count.android.api.messaging.activity.class";
    private static final int PLAY_SERVICES_RESOLUTION_REQUEST = 9000;
    private static GoogleCloudMessaging gcm;

    public static String getBroadcastAction(Context context) {
        try {
            ComponentName name = new ComponentName(context, CountlyMessagingService.class);
            Bundle data = context.getPackageManager().getServiceInfo((ComponentName)name, (int)128).metaData;
            return data.getString("broadcast_action");
        }
        catch (PackageManager.NameNotFoundException ignored) {
            Log.w((String)TAG, (String)"Set broadcast_action metadata for CountlyMessagingService in AndroidManifest.xml to receive broadcasts about received messages.");
            return null;
        }
    }

    public static void setActivity(Activity activity) {
        CountlyMessaging.setActivity(activity, activity.getClass());
    }

    public static void setActivity(Activity activity, Class<? extends Activity> claz) {
        context = activity.getApplicationContext();
        activityClass = claz == null ? activity.getClass() : claz;
    }

    protected static Context getContext() {
        return context;
    }

    protected static Class<? extends Activity> getActivityClass() {
        return activityClass;
    }

    protected static Class<? extends Activity> getMainActivityClass(Context context) {
        String packageName = context.getPackageName();
        Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        String className = launchIntent.getComponent().getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void onReceive(Context context, Intent intent) {
        Log.i((String)TAG, (String)("Starting service @ " + SystemClock.elapsedRealtime()));
        ComponentName comp = new ComponentName(context.getPackageName(), CountlyMessagingService.class.getName());
        if (Build.VERSION.SDK_INT >= 12) {
            intent.addFlags(32);
        }
        CountlyMessaging.startWakefulService((Context)context, (Intent)intent.setComponent(comp));
        this.setResultCode(-1);
    }

    public static void init(Activity activity, Class<? extends Activity> activityClass, String sender, String[] buttonNames) {
        CountlyMessaging.setActivity(activity, activityClass);
        if (gcm != null) {
            return;
        }
        if (buttonNames != null) {
            CountlyMessaging.buttonNames = buttonNames;
        }
        if (CountlyMessaging.checkPlayServices(activity)) {
            gcm = GoogleCloudMessaging.getInstance((Context)activity);
            String registrationId = CountlyMessaging.getRegistrationId(activity, sender);
            if (registrationId.isEmpty()) {
                CountlyMessaging.registerInBackground((Context)activity, sender);
            } else {
                Countly.sharedInstance().onRegistrationId(registrationId);
            }
        } else if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.w((String)TAG, (String)"No valid Google Play Services APK found.");
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void storeConfiguration(Context context, String serverURL, String appKey, String deviceID, DeviceId.Type idMode) {
        String label;
        block4: {
            label = "App";
            try {
                label = context.getString(context.getApplicationInfo().labelRes);
            }
            catch (Throwable t) {
                if (!Countly.sharedInstance().isLoggingEnabled()) break block4;
                Log.wtf((String)TAG, (String)"Couldn't find android:label='@string/app_name' resource, please set it in AndroidManifest.xml", (Throwable)t);
            }
        }
        if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.i((String)TAG, (String)("Storing configuration: " + label + ", " + serverURL + ", " + appKey + ", " + deviceID + ", " + idMode));
        }
        SharedPreferences.Editor editor = CountlyMessaging.getGCMPreferences(context).edit().putString(PROPERTY_APPLICATION_TITLE, label).putString(PROPERTY_SERVER_URL, serverURL).putString(PROPERTY_APP_KEY, appKey).putString(PROPERTY_DEVICE_ID, deviceID).putInt(PROPERTY_DEVICE_ID_MODE, idMode == null ? -1 : idMode.ordinal());
        if (activityClass != null) {
            editor.putString(PROPERTY_ACTIVITY_CLASS, activityClass.getName());
        }
        editor.commit();
    }

    protected static boolean initCountly(Context context) {
        String serverURL = CountlyMessaging.getGCMPreferences(context).getString(PROPERTY_SERVER_URL, null);
        String appKey = CountlyMessaging.getGCMPreferences(context).getString(PROPERTY_APP_KEY, null);
        String deviceID = CountlyMessaging.getGCMPreferences(context).getString(PROPERTY_DEVICE_ID, null);
        String activityClassName = CountlyMessaging.getGCMPreferences(context).getString(PROPERTY_ACTIVITY_CLASS, null);
        DeviceId.Type idMode = null;
        int mode = CountlyMessaging.getGCMPreferences(context).getInt(PROPERTY_DEVICE_ID_MODE, -1);
        if (mode != -1) {
            idMode = DeviceId.Type.values()[mode];
        }
        if (serverURL == null || appKey == null) {
            return false;
        }
        Countly.sharedInstance().init(context, serverURL, appKey, deviceID, idMode);
        try {
            activityClass = Class.forName(activityClassName);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Could not find class " + activityClassName), (Throwable)e);
        }
        return true;
    }

    private static void registerInBackground(final Context context, final String sender) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    String registrationId = gcm.register(new String[]{sender});
                    Countly.sharedInstance().onRegistrationId(registrationId);
                    CountlyMessaging.storeRegistrationId(context, registrationId, sender);
                }
                catch (IOException ex) {
                    Log.e((String)CountlyMessaging.TAG, (String)("Failed to register for GCM identificator: " + ex.getMessage()));
                }
                return null;
            }
        }.execute((Object[])new Void[]{null, null, null});
    }

    private static void storeRegistrationId(Context context, String regId, String sender) {
        int appVersion = CountlyMessaging.getAppVersion(context);
        if (Countly.sharedInstance().isLoggingEnabled()) {
            Log.i((String)TAG, (String)("Saving regId " + regId + " for sender ID " + sender + " for app version " + appVersion));
        }
        CountlyMessaging.getGCMPreferences(context).edit().putString(PROPERTY_REGISTRATION_ID, regId).putString(PROPERTY_REGISTRATION_SENDER, sender).putInt(PROPERTY_REGISTRATION_VERSION, appVersion).commit();
    }

    private static SharedPreferences getGCMPreferences(Context context) {
        return context.getSharedPreferences(PREFERENCES_NAME, 0);
    }

    private static boolean checkPlayServices(Activity activity) {
        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
        if (GooglePlayServicesUtil.isUserRecoverableError((int)resultCode)) {
            GooglePlayServicesUtil.getErrorDialog((int)resultCode, (Activity)activity, (int)9000).show();
        } else {
            Log.w((String)TAG, (String)"Unable to install Play Services.");
        }
        return resultCode == 0 || resultCode == 2;
    }

    private static String getRegistrationId(Activity activity, String sender) {
        int currentVersion;
        SharedPreferences preferences = CountlyMessaging.getGCMPreferences((Context)activity);
        String registrationId = preferences.getString(PROPERTY_REGISTRATION_ID, "");
        if (registrationId.isEmpty()) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.i((String)TAG, (String)"Registration not found.");
            }
            return "";
        }
        int registeredVersion = preferences.getInt(PROPERTY_REGISTRATION_VERSION, Integer.MIN_VALUE);
        if (registeredVersion != (currentVersion = CountlyMessaging.getAppVersion(activity.getApplicationContext()))) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.i((String)TAG, (String)"App version changed.");
            }
            return "";
        }
        String registeredSender = preferences.getString(PROPERTY_REGISTRATION_SENDER, "");
        if (!registeredSender.equals(sender)) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.i((String)TAG, (String)"Sender ID changed.");
            }
            return "";
        }
        return registrationId;
    }

    private static int getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Could not get package name: " + (Object)((Object)e));
        }
    }

    protected static String getAppTitle(Context context) {
        return CountlyMessaging.getGCMPreferences(context).getString(PROPERTY_APPLICATION_TITLE, "");
    }

    public static void recordMessageOpen(String messageId) {
        if (!Countly.sharedInstance().isInitialized()) {
            CountlyMessaging.initCountly(CountlyMessaging.getContext());
        }
        HashMap<String, String> segmentation = new HashMap<String, String>();
        segmentation.put("i", messageId);
        Countly.sharedInstance().recordEvent(EVENT_OPEN, segmentation, 1);
    }

    public static void recordMessageAction(String messageId) {
        if (!Countly.sharedInstance().isInitialized()) {
            CountlyMessaging.initCountly(CountlyMessaging.getContext());
        }
        HashMap<String, String> segmentation = new HashMap<String, String>();
        segmentation.put("i", messageId);
        Countly.sharedInstance().recordEvent(EVENT_ACTION, segmentation, 1);
    }
}

