/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk.messaging;

import android.app.ActivityManager;
import android.app.IntentService;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import java.util.List;
import ly.count.android.sdk.Countly;
import ly.count.android.sdk.messaging.CountlyMessaging;
import ly.count.android.sdk.messaging.Message;
import ly.count.android.sdk.messaging.ProxyActivity;

public class CountlyMessagingService
extends IntentService {
    public static final String TAG = "CountlyMessagingService";

    public CountlyMessagingService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        Message msg;
        Bundle extras = intent.getExtras();
        GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)this.getApplicationContext());
        String messageType = gcm.getMessageType(intent);
        if (!extras.isEmpty() && "gcm".equals(messageType) && (msg = new Message(extras)).isValid()) {
            if (Countly.sharedInstance().isLoggingEnabled()) {
                Log.i((String)TAG, (String)("Got a message from Countly Messaging: " + msg));
            }
            Intent broadcast = new Intent(CountlyMessaging.getBroadcastAction(this.getApplicationContext()));
            broadcast.putExtra(CountlyMessaging.BROADCAST_RECEIVER_ACTION_MESSAGE, (Parcelable)msg);
            this.sendBroadcast(broadcast);
            if (!Countly.sharedInstance().isInitialized() && !CountlyMessaging.initCountly(this.getApplicationContext())) {
                Log.e((String)TAG, (String)"Cannot init Countly in background");
            }
            if (msg.isSilent()) {
                CountlyMessaging.recordMessageOpen(msg.getId());
            } else {
                Intent proxy = new Intent(this.getApplicationContext(), ProxyActivity.class);
                proxy.putExtra("ly.count.android.api.messaging.message", (Parcelable)msg);
                this.notify(proxy);
            }
        }
        CountlyMessaging.completeWakefulIntent((Intent)intent);
    }

    protected void notify(Intent proxy) {
        Message msg = (Message)proxy.getParcelableExtra("ly.count.android.api.messaging.message");
        if (CountlyMessagingService.isAppInForeground((Context)this)) {
            proxy.putExtra("ly.count.android.api.messaging.dialog", true);
            proxy.setFlags(0x10000000);
            this.startActivity(proxy);
        } else {
            int icon;
            CountlyMessaging.recordMessageOpen(msg.getId());
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            PendingIntent contentIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)proxy, (int)0x8000000);
            try {
                icon = this.getPackageManager().getApplicationInfo((String)this.getPackageName(), (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException e) {
                icon = 17301545;
            }
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.getApplicationContext()).setAutoCancel(true).setSmallIcon(icon).setTicker((CharSequence)msg.getNotificationMessage()).setContentTitle((CharSequence)msg.getNotificationTitle(this.getApplicationContext())).setContentText((CharSequence)msg.getNotificationMessage()).setContentIntent(contentIntent);
            if (msg.hasSoundDefault()) {
                builder.setDefaults(1);
            } else if (msg.hasSoundUri()) {
                builder.setSound(Uri.parse((String)msg.getSoundUri()));
            }
            manager.notify(1, builder.build());
        }
    }

    private static boolean isAppInForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        String packageName = context.getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
            return true;
        }
        return false;
    }
}

