/*
 * Decompiled with CFR 0.152.
 */
package ly.count.android.sdk.messaging;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import ly.count.android.sdk.messaging.CountlyMessaging;

public class Message
implements Parcelable {
    private static final String TAG = "Countly|Message";
    private Bundle data;
    private int type;
    public static final Parcelable.Creator<Message> CREATOR = new Parcelable.Creator<Message>(){

        public Message createFromParcel(Parcel in) {
            return new Message(in);
        }

        public Message[] newArray(int size) {
            return new Message[size];
        }
    };

    public Message(Bundle data) {
        this.data = data;
        this.type = this.setType();
    }

    public String getId() {
        return this.data.getString("c.i");
    }

    public String getLink() {
        return this.data.getString("c.l");
    }

    public String getReview() {
        return this.data.getString("c.r");
    }

    public String getMessage() {
        return this.data.getString("message");
    }

    public String getSoundUri() {
        return this.data.getString("sound");
    }

    public Bundle getData() {
        return this.data;
    }

    public int getType() {
        return this.type;
    }

    private int setType() {
        int t = 0;
        if (this.getMessage() != null && !"".equals(this.getMessage())) {
            t |= 1;
        }
        if (this.getLink() != null && !"".equals(this.getLink())) {
            t |= 2;
        }
        if (this.getReview() != null && !"".equals(this.getReview())) {
            t |= 4;
        }
        if ("true".equals(this.data.getString("c.s"))) {
            t |= 8;
        }
        if (this.getSoundUri() != null && !"".equals(this.getSoundUri())) {
            t = "default".equals(this.getSoundUri()) ? (t |= 0x10) : (t |= 0x20);
        }
        return t;
    }

    public boolean hasLink() {
        return (this.type & 2) > 0;
    }

    public boolean hasReview() {
        return (this.type & 4) > 0;
    }

    public boolean hasMessage() {
        return (this.type & 1) > 0;
    }

    public boolean isSilent() {
        return (this.type & 8) > 0;
    }

    public boolean hasSoundUri() {
        return (this.type & 0x20) > 0;
    }

    public boolean hasSoundDefault() {
        return (this.type & 0x10) > 0;
    }

    public boolean isUnknown() {
        return this.type == 0;
    }

    public boolean isValid() {
        String id = this.data.getString("c.i");
        return !this.isUnknown() && id != null && id.length() == 24;
    }

    public Intent getIntent(Context context, Class<? extends Activity> activityClass) {
        if (this.hasLink()) {
            return new Intent("android.intent.action.VIEW", Uri.parse((String)this.getLink()));
        }
        if (this.hasReview()) {
            return new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + context.getPackageName())));
        }
        if (this.hasMessage()) {
            Intent intent = new Intent(context, activityClass);
            intent.setFlags(0x20000000);
            return intent;
        }
        return null;
    }

    public String getNotificationTitle(Context context) {
        return CountlyMessaging.getAppTitle(context);
    }

    public String getNotificationMessage() {
        if (this.hasLink()) {
            return this.hasMessage() ? this.getMessage() : "";
        }
        if (this.hasReview()) {
            return this.hasMessage() ? this.getMessage() : "";
        }
        if (this.hasMessage()) {
            return this.getMessage();
        }
        return null;
    }

    public String toString() {
        return this.data == null ? "empty" : this.data.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.data);
    }

    Message(Parcel in) {
        this.data = in.readBundle();
        this.type = this.setType();
    }
}

