/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dwango.cbb.dc;

import java.util.ArrayList;
import java.util.Map;
import jp.co.dwango.cbb.db.DataBus;
import jp.co.dwango.cbb.db.DataBusHandler;
import jp.co.dwango.cbb.dc.DataChannelCallback;
import jp.co.dwango.cbb.dc.DataChannelHandler;
import jp.co.dwango.cbb.dc.DataChannelResponseHandler;
import jp.co.dwango.cbb.dc.DataChannelWaitingResponseTable;
import jp.co.dwango.cbb.dc.ErrorType;
import jp.co.dwango.cbb.dc.Logger;
import jp.co.dwango.cbb.dc.RequestTag;
import org.json.JSONArray;
import org.json.JSONException;

public class DataChannel {
    private static final int DATA_TYPE_PUSH = 1;
    private static final int DATA_TYPE_REQUEST = 2;
    private static final int DATA_TYPE_RESPONSE = 3;
    private static final int DATA_TYPE_ERROR = 4;
    public final DataBus dataBus;
    private final DataChannelWaitingResponseTable waitingCallbacks = new DataChannelWaitingResponseTable();
    private DataBusHandler dataBusHandler;
    private ArrayList<DataChannelHandler> handlers = new ArrayList();
    private int latestTagNumber = 1;
    private boolean destroyed = false;

    public DataChannel(DataBus dataBus) {
        this.dataBus = dataBus;
        this.dataBusHandler = new DataBusHandler(){

            public void onReceive(JSONArray packet) {
                block16: {
                    if (DataChannel.this.destroyed) {
                        return;
                    }
                    try {
                        if (2 != packet.length()) {
                            Logger.w("invalid packet received: " + packet.toString());
                            return;
                        }
                        int dataType = packet.getInt(0);
                        JSONArray data = packet.getJSONArray(1);
                        switch (dataType) {
                            case 1: {
                                Object channelPacket = data.get(0);
                                if (0 == DataChannel.this.handlers.size()) {
                                    Logger.w("data lost: " + packet.toString());
                                    break;
                                }
                                for (DataChannelHandler handler : DataChannel.this.handlers) {
                                    handler.onPush(channelPacket);
                                }
                                break;
                            }
                            case 2: {
                                final RequestTag tag = new RequestTag(data.getString(0));
                                Object channelPacket = data.get(1);
                                if (0 == DataChannel.this.handlers.size()) {
                                    Logger.w("data lost: " + packet.toString());
                                    break;
                                }
                                for (DataChannelHandler handler : DataChannel.this.handlers) {
                                    handler.onRequest(channelPacket, new DataChannelCallback(){

                                        @Override
                                        public void send(Object packet) {
                                            DataChannel.this.sendResponse(tag.toString(), packet);
                                        }
                                    });
                                }
                                break;
                            }
                            case 3: {
                                RequestTag tag = new RequestTag(data.getString(0));
                                Object channelPacket = data.get(1);
                                DataChannelResponseHandler callback = DataChannel.this.waitingCallbacks.get(tag);
                                if (null == callback) {
                                    Logger.w("invalid response: " + packet.toString());
                                    break;
                                }
                                callback.onResponse(channelPacket);
                                break;
                            }
                            case 4: {
                                RequestTag tag = new RequestTag(data.getString(0));
                                String error = data.getString(1);
                                DataChannelResponseHandler callback = DataChannel.this.waitingCallbacks.get(tag);
                                if (null == callback) {
                                    Logger.w("invalid response: " + packet.toString());
                                    break;
                                }
                                callback.onError(ErrorType.get(error));
                                break;
                            }
                            default: {
                                Logger.e("invalid packet: " + packet.toString());
                            }
                        }
                    }
                    catch (JSONException e) {
                        if (!Logger.enabled) break block16;
                        e.printStackTrace();
                    }
                }
            }
        };
        this.dataBus.addHandler(this.dataBusHandler);
    }

    public static void logging(boolean enabled) {
        Logger.enabled = enabled;
    }

    public void sendPush(Object push) {
        if (this.destroyed) {
            return;
        }
        JSONArray data = new JSONArray().put(push);
        JSONArray packet = new JSONArray();
        packet.put(1);
        packet.put((Object)data);
        this.dataBus.send(packet);
    }

    public void sendRequest(Object request, DataChannelResponseHandler callback) {
        if (this.destroyed) {
            return;
        }
        if (null == callback) {
            this.sendPush(request);
            return;
        }
        JSONArray data = new JSONArray();
        RequestTag tag = new RequestTag("A", this.latestTagNumber++);
        data.put((Object)tag.toString());
        this.waitingCallbacks.put(tag, callback);
        data.put(request);
        JSONArray packet = new JSONArray();
        packet.put(2);
        packet.put((Object)data);
        this.dataBus.send(packet);
    }

    void sendResponse(String tag, Object response) {
        if (this.destroyed) {
            return;
        }
        JSONArray data = new JSONArray();
        data.put((Object)tag);
        data.put(response);
        JSONArray packet = new JSONArray();
        packet.put(3);
        packet.put((Object)data);
        this.dataBus.send(packet);
    }

    public void addHandler(DataChannelHandler handler) {
        if (this.destroyed || 0 <= this.handlers.indexOf(handler)) {
            return;
        }
        this.handlers.add(handler);
    }

    public void removeHandler(DataChannelHandler handler) {
        if (this.destroyed) {
            return;
        }
        this.handlers.remove(handler);
    }

    public void removeAllHandlers() {
        if (this.destroyed) {
            return;
        }
        this.handlers.clear();
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.handlers.clear();
        this.dataBus.removeHandler(this.dataBusHandler);
        Map<RequestTag, DataChannelResponseHandler> waitingCallbacksMap = this.waitingCallbacks.popAllHandlers();
        for (RequestTag key : waitingCallbacksMap.keySet()) {
            waitingCallbacksMap.get(key).onError(ErrorType.Close);
        }
        this.destroyed = true;
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.destroy();
        }
    }
}

