/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dwango.cbb.db;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.os.Message;
import android.util.Base64;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jp.co.dwango.cbb.db.DataBus;
import jp.co.dwango.cbb.db.DataBusHandler;
import jp.co.dwango.cbb.db.Logger;
import jp.co.dwango.cbb.db.WebViewDataBusJSI;
import jp.co.dwango.cbb.db.WebViewDataBusJSIHandler;
import org.json.JSONArray;

public class WebViewDataBus
extends DataBus {
    private static final String JAVASCRIPT_INTERFACE = "AndroidDataBusJSI";
    private final Context context;
    private final WebView webView;
    private final boolean injectManually;
    private boolean addedJavaScriptInterface = false;

    @SuppressLint(value={"AddJavascriptInterface"})
    public WebViewDataBus(Context context, WebView webView) {
        this(context, webView, null);
    }

    @SuppressLint(value={"AddJavascriptInterface"})
    public WebViewDataBus(Context context, WebView webView, boolean injectManually) {
        this(context, webView, null, injectManually);
    }

    public WebViewDataBus(Context context, WebView webView, WebViewClient client) {
        this(context, webView, client, false);
    }

    @SuppressLint(value={"AddJavascriptInterface"})
    public WebViewDataBus(Context context, WebView webView, final WebViewClient client, boolean injectManually) {
        this.context = context;
        this.webView = webView;
        this.injectManually = injectManually;
        if (this.injectManually && null != client) {
            throw new IllegalArgumentException("Cannot specify client if injectManually");
        }
        this.webView.addJavascriptInterface((Object)new WebViewDataBusJSI(new WebViewDataBusJSIHandler(){

            @Override
            public void onSend(JSONArray data) {
                for (DataBusHandler h : WebViewDataBus.this.handlers) {
                    h.onReceive(data);
                }
            }
        }), JAVASCRIPT_INTERFACE);
        this.addedJavaScriptInterface = true;
        if (this.injectManually) {
            return;
        }
        if (null != client) {
            this.webView.setWebViewClient(new WebViewClient(){

                public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
                    client.doUpdateVisitedHistory(view, url, isReload);
                }

                public void onFormResubmission(WebView view, Message dontResend, Message resend) {
                    client.onFormResubmission(view, dontResend, resend);
                }

                public void onLoadResource(WebView view, String url) {
                    client.onLoadResource(view, url);
                }

                public void onPageCommitVisible(WebView view, String url) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        client.onPageCommitVisible(view, url);
                    }
                }

                public void onPageFinished(WebView view, String url) {
                    client.onPageFinished(view, url);
                }

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    WebViewDataBus.this.injectJavaScript();
                    client.onPageStarted(view, url, favicon);
                }

                public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        client.onReceivedClientCertRequest(view, request);
                    }
                }

                public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        client.onReceivedError(view, request, error);
                    }
                }

                public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
                    client.onReceivedHttpAuthRequest(view, handler, host, realm);
                }

                public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        client.onReceivedHttpError(view, request, errorResponse);
                    }
                }

                public void onReceivedLoginRequest(WebView view, String realm, String account, String args) {
                    client.onReceivedLoginRequest(view, realm, account, args);
                }

                public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                    client.onReceivedSslError(view, handler, error);
                }

                public void onScaleChanged(WebView view, float oldScale, float newScale) {
                    client.onScaleChanged(view, oldScale, newScale);
                }
            });
        } else {
            this.webView.setWebViewClient(new WebViewClient(){

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    WebViewDataBus.this.injectJavaScript();
                }
            });
        }
    }

    private void injectJavaScript() {
        if (this.destroyed) {
            Logger.e("already destroyed");
            return;
        }
        String script = this.getInjectJavaScript();
        if (null == script) {
            Logger.e("Cannot get inject script.");
            return;
        }
        String encoded = Base64.encodeToString((byte[])script.getBytes(), (int)2);
        Logger.d("inject: " + encoded);
        this.webView.loadUrl("javascript:(function() {var script = document.createElement('script');script.type = 'text/javascript';script.innerHTML = window.atob('" + encoded + "');document.getElementsByTagName('head').item(0).appendChild(script)})()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInjectJavaScript() {
        if (this.destroyed) {
            Logger.e("already destroyed");
            return null;
        }
        InputStream is = null;
        BufferedReader br = null;
        StringBuilder result = new StringBuilder(16384);
        try {
            String str;
            is = this.context.getAssets().open("js/AndroidDataBus.js");
            br = new BufferedReader(new InputStreamReader(is));
            while ((str = br.readLine()) != null) {
                result.append(str).append("\n");
            }
        }
        catch (IOException e) {
            Logger.printStackTrace(e);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Logger.printStackTrace(e);
                }
            }
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    Logger.printStackTrace(e);
                }
            }
        }
        return result.toString();
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void send(final JSONArray data) {
        if (this.destroyed) {
            Logger.e("already destroyed");
            return;
        }
        Logger.d("sending: " + data.toString());
        ((Activity)this.context).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebViewDataBus.this.webView.loadUrl(String.format("javascript: window.AndroidDataBusNI.onSend(%s);", data.toString()));
            }
        });
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.addedJavaScriptInterface) {
            this.webView.removeJavascriptInterface(JAVASCRIPT_INTERFACE);
            this.addedJavaScriptInterface = false;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.destroy();
        }
    }
}

