/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dwango.cbb.db;

import jp.co.dwango.cbb.db.DataBus;
import jp.co.dwango.cbb.db.DataBusHandler;
import jp.co.dwango.cbb.db.Logger;
import jp.co.dwango.cbb.db.MemoryQueue;
import jp.co.dwango.cbb.db.MemoryQueueHandler;
import org.json.JSONArray;
import org.json.JSONException;

public class MemoryQueueDataBus
extends DataBus {
    private final MemoryQueue sendingMemoryQueue;
    private final MemoryQueue receivingMemoryQueue;
    private final MemoryQueueHandler listener;

    public MemoryQueueDataBus(MemoryQueue sendingMemoryQueue, MemoryQueue receivingMemoryQueue) {
        this.sendingMemoryQueue = sendingMemoryQueue;
        this.receivingMemoryQueue = receivingMemoryQueue;
        this.listener = new MemoryQueueHandler(){

            @Override
            public void onReceive(String data) {
                block3: {
                    try {
                        JSONArray jsonData = new JSONArray(data);
                        for (DataBusHandler h : MemoryQueueDataBus.this.handlers) {
                            h.onReceive(jsonData);
                        }
                    }
                    catch (JSONException e) {
                        if (!Logger.enabled) break block3;
                        e.printStackTrace();
                    }
                }
            }
        };
        this.receivingMemoryQueue.addListener(this.listener);
    }

    @Override
    public void send(JSONArray data) {
        if (this.destroyed) {
            Logger.e("already destroyed");
            return;
        }
        this.sendingMemoryQueue.send(data.toString());
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            Logger.e("already destroyed");
            return;
        }
        this.receivingMemoryQueue.removeListener(this.listener);
        super.destroy();
    }
}

