/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.util.OpenGlUtils;
import jp.co.cyberagent.android.gpuimage.util.Rotation;
import jp.co.cyberagent.android.gpuimage.util.TextureRotationUtil;

public class GPUImageTwoInputFilter
extends GPUImageFilter {
    private static final String VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n}";
    private int filterSecondTextureCoordinateAttribute;
    private int filterInputTextureUniform2;
    private int filterSourceTexture2 = -1;
    private ByteBuffer texture2CoordinatesBuffer;
    private Bitmap bitmap;

    public GPUImageTwoInputFilter(String fragmentShader) {
        this(VERTEX_SHADER, fragmentShader);
    }

    public GPUImageTwoInputFilter(String vertexShader, String fragmentShader) {
        super(vertexShader, fragmentShader);
        this.setRotation(Rotation.NORMAL, false, false);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.filterSecondTextureCoordinateAttribute = GLES20.glGetAttribLocation((int)this.getProgram(), (String)"inputTextureCoordinate2");
        this.filterInputTextureUniform2 = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"inputImageTexture2");
        GLES20.glEnableVertexAttribArray((int)this.filterSecondTextureCoordinateAttribute);
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            this.setBitmap(this.bitmap);
        }
    }

    public void setBitmap(final Bitmap bitmap) {
        if (bitmap != null && bitmap.isRecycled()) {
            return;
        }
        this.bitmap = bitmap;
        if (this.bitmap == null) {
            return;
        }
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                if (GPUImageTwoInputFilter.this.filterSourceTexture2 == -1) {
                    if (bitmap == null || bitmap.isRecycled()) {
                        return;
                    }
                    GLES20.glActiveTexture((int)33987);
                    GPUImageTwoInputFilter.this.filterSourceTexture2 = OpenGlUtils.loadTexture(bitmap, -1, false);
                }
            }
        });
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public void recycleBitmap() {
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            this.bitmap.recycle();
            this.bitmap = null;
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.filterSourceTexture2}, (int)0);
        this.filterSourceTexture2 = -1;
    }

    @Override
    protected void onDrawArraysPre() {
        GLES20.glEnableVertexAttribArray((int)this.filterSecondTextureCoordinateAttribute);
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)3553, (int)this.filterSourceTexture2);
        GLES20.glUniform1i((int)this.filterInputTextureUniform2, (int)3);
        this.texture2CoordinatesBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.filterSecondTextureCoordinateAttribute, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.texture2CoordinatesBuffer);
    }

    public void setRotation(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        float[] buffer = TextureRotationUtil.getRotation(rotation, flipHorizontal, flipVertical);
        ByteBuffer bBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder());
        FloatBuffer fBuffer = bBuffer.asFloatBuffer();
        fBuffer.put(buffer);
        fBuffer.flip();
        this.texture2CoordinatesBuffer = bBuffer;
    }
}

