/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;

public class GPUImageLevelsFilter
extends GPUImageFilter {
    private static final String LOGTAG = GPUImageLevelsFilter.class.getSimpleName();
    public static final String LEVELS_FRAGMET_SHADER = " varying highp vec2 textureCoordinate;\n \n uniform sampler2D inputImageTexture;\n uniform mediump vec3 levelMinimum;\n uniform mediump vec3 levelMiddle;\n uniform mediump vec3 levelMaximum;\n uniform mediump vec3 minOutput;\n uniform mediump vec3 maxOutput;\n \n void main()\n {\n     mediump vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     \n     gl_FragColor = vec4( mix(minOutput, maxOutput, pow(min(max(textureColor.rgb -levelMinimum, vec3(0.0)) / (levelMaximum - levelMinimum  ), vec3(1.0)), 1.0 /levelMiddle)) , textureColor.a);\n }\n";
    private int minLocation;
    private float[] min;
    private int midLocation;
    private float[] mid;
    private int maxLocation;
    private float[] max;
    private int minOutputLocation;
    private float[] minOutput;
    private int maxOutputLocation;
    private float[] maxOutput;

    public GPUImageLevelsFilter() {
        this(new float[]{0.0f, 0.0f, 0.0f}, new float[]{1.0f, 1.0f, 1.0f}, new float[]{1.0f, 1.0f, 1.0f}, new float[]{0.0f, 0.0f, 0.0f}, new float[]{1.0f, 1.0f, 1.0f});
    }

    private GPUImageLevelsFilter(float[] min, float[] mid, float[] max, float[] minOUt, float[] maxOut) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", LEVELS_FRAGMET_SHADER);
        this.min = min;
        this.mid = mid;
        this.max = max;
        this.minOutput = minOUt;
        this.maxOutput = maxOut;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.minLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"levelMinimum");
        this.midLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"levelMiddle");
        this.maxLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"levelMaximum");
        this.minOutputLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"minOutput");
        this.maxOutputLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"maxOutput");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setMin(0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        this.updateUniforms();
    }

    public void updateUniforms() {
        this.setFloatVec3(this.minLocation, this.min);
        this.setFloatVec3(this.midLocation, this.mid);
        this.setFloatVec3(this.maxLocation, this.max);
        this.setFloatVec3(this.minOutputLocation, this.minOutput);
        this.setFloatVec3(this.maxOutputLocation, this.maxOutput);
    }

    public void setMin(float min, float mid, float max, float minOut, float maxOut) {
        this.setRedMin(min, mid, max, minOut, maxOut);
        this.setGreenMin(min, mid, max, minOut, maxOut);
        this.setBlueMin(min, mid, max, minOut, maxOut);
    }

    public void setMin(float min, float mid, float max) {
        this.setMin(min, mid, max, 0.0f, 1.0f);
    }

    public void setRedMin(float min, float mid, float max, float minOut, float maxOut) {
        this.min[0] = min;
        this.mid[0] = mid;
        this.max[0] = max;
        this.minOutput[0] = minOut;
        this.maxOutput[0] = maxOut;
        this.updateUniforms();
    }

    public void setRedMin(float min, float mid, float max) {
        this.setRedMin(min, mid, max, 0.0f, 1.0f);
    }

    public void setGreenMin(float min, float mid, float max, float minOut, float maxOut) {
        this.min[1] = min;
        this.mid[1] = mid;
        this.max[1] = max;
        this.minOutput[1] = minOut;
        this.maxOutput[1] = maxOut;
        this.updateUniforms();
    }

    public void setGreenMin(float min, float mid, float max) {
        this.setGreenMin(min, mid, max, 0.0f, 1.0f);
    }

    public void setBlueMin(float min, float mid, float max, float minOut, float maxOut) {
        this.min[2] = min;
        this.mid[2] = mid;
        this.max[2] = max;
        this.minOutput[2] = minOut;
        this.maxOutput[2] = maxOut;
        this.updateUniforms();
    }

    public void setBlueMin(float min, float mid, float max) {
        this.setBlueMin(min, mid, max, 0.0f, 1.0f);
    }
}

